/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;

@Entity
@Table(name="citations")
public class Citation
extends Resource {
    @ManyToOne
    @JoinColumn(name="cited_document_id", nullable=false)
    private Document citedDocument;
    @ManyToOne
    @JoinColumn(name="citing_document_id", nullable=false)
    private Document citingDocument;
    private String context;
    private Integer countChapter;
    private Integer countCharacter;
    private Integer countParagraph;
    private Integer countSentence;
    private Integer countWord;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(nullable=false)
    private Integer id;

    public Citation getCitation(Citation c) {
        if (c.getId() != null) {
            return this.getCitation(c.getId());
        }
        return this.getCitation(c.getCitedDocument(), c.getCitingDocument(), c.getCountChapter(), c.getCountCharacter(), c.getCountParagraph(), c.getCountSentence(), c.getCountWord());
    }

    public Citation getCitation(Integer id) {
        return (Citation)this.getSession().get(Citation.class, (Serializable)id);
    }

    public Citation getCitation(Document cited, Document citing, Integer chapter, Integer character, Integer paragraph, Integer sentence, Integer word) {
        return (Citation)this.getSession().createCriteria(Citation.class).add((Criterion)Restrictions.eq((String)"citedDocument", (Object)cited)).add((Criterion)Restrictions.eq((String)"citingDocument", (Object)citing)).add((Criterion)Restrictions.eq((String)"countChapter", (Object)chapter)).add((Criterion)Restrictions.eq((String)"countCharacter", (Object)character)).add((Criterion)Restrictions.eq((String)"countParagraph", (Object)paragraph)).add((Criterion)Restrictions.eq((String)"countSentence", (Object)sentence)).add((Criterion)Restrictions.eq((String)"countWord", (Object)word)).setMaxResults(1).uniqueResult();
    }

    public List<Citation> getCitations() {
        List cs = this.getSession().createCriteria(Citation.class).list();
        return cs;
    }

    public Citation() {
    }

    public Citation(Session s) {
        this.setSession(s);
    }

    public Document getCitedDocument() {
        return this.citedDocument;
    }

    public Document getCitingDocument() {
        return this.citingDocument;
    }

    public String getContext() {
        return this.context;
    }

    public Integer getCountChapter() {
        return this.countChapter;
    }

    public Integer getCountCharacter() {
        return this.countCharacter;
    }

    public Integer getCountParagraph() {
        return this.countParagraph;
    }

    public Integer getCountSentence() {
        return this.countSentence;
    }

    public Integer getCountWord() {
        return this.countWord;
    }

    public Integer getId() {
        return this.id;
    }

    public void setCitedDocument(Document citedDocument) {
        this.citedDocument = citedDocument;
    }

    public void setCitingDocument(Document citingDocument) {
        this.citingDocument = citingDocument;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setCountChapter(Integer countChapter) {
        this.countChapter = countChapter;
    }

    public void setCountCharacter(Integer countCharacter) {
        this.countCharacter = countCharacter;
    }

    public void setCountParagraph(Integer countParagraph) {
        this.countParagraph = countParagraph;
    }

    public void setCountSentence(Integer countSentence) {
        this.countSentence = countSentence;
    }

    public void setCountWord(Integer countWord) {
        this.countWord = countWord;
    }

    public void setId(Integer id) {
        this.id = id;
    }
}

