/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import freemind.main.FreeMindMain;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;
import splmm.Gui.EnterValueDialog;
import splmm.Listeners.PreferencesMouseListener;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.Preferences.UserDataState;
import splmm.SciPloreUtils;
import splmm.Thread.PrefEventSenderThread;

public class Preferences
extends JDialog {
    private JButton bibTeXFileButton;
    private JCheckBox updateCheckBox;
    private JCheckBox usageMiningCheckBox;
    private JButton okButton;
    private JButton cancelButton;
    private JButton privacyButton;
    private JCheckBox backupCheckBox;
    private JCheckBox ironmmCheckBox;
    private JCheckBox ironldCheckBox;
    private JPanel contentPane;
    private JLabel notifyInfoLabel;
    private JLabel backupInfoLabel;
    private JLabel usageMiningInfoLabel;
    private JLabel ironmmInfoLabel;
    private JLabel ironldInfoLabel;
    private JTextField userNameTextField;
    private JPasswordField backupPasswordField;
    private JLabel registerLinkLabel;
    private JTextField jabrefpathTextField;
    private JTabbedPane tabbedPane1;
    private JPanel servicePanel;
    private JPanel privacyPanel;
    private JPanel referencePanel;
    private JPanel monitoringPanel;
    private JButton addFileTypeButton;
    private JButton editFileTypeButton;
    private JButton removeFileTypeButton;
    private JList listImportFiles;
    private JButton AddSubDirButton;
    private JButton EditSubDirButton;
    private JButton removeSubDirButton;
    private JList listIgnoreSubDirs;
    private JCheckBox updateMonitoringFolderAutomaticallyCheckBox;
    private JCheckBox importFilesFromSubCheckBox;
    private JLabel privacyInfoLabel;
    private JPanel pdfmanagementPanel;
    private JCheckBox importBookmarks;
    private JCheckBox importComments;
    private JCheckBox importHighlights;
    private JLabel selectedPDFReadersLink;
    private FreeMindMain freemind;
    private DefaultListModel fileTypeModel = new DefaultListModel();
    private DefaultListModel subfolderModel = new DefaultListModel();
    private boolean firstStart = false;

    public Preferences(FreeMindMain freemind) {
        this.$$$setupUI$$$();
        this.InitializePrefDialog(freemind);
    }

    private void InitializePrefDialog(FreeMindMain freemind) {
        this.removeFileTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onRemoveFileTypeButton();
            }
        });
        this.removeSubDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onRemoveSubDirButton();
            }
        });
        this.addFileTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onAddFileTypeButton();
            }
        });
        this.editFileTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onEditFileTypeButton();
            }
        });
        this.AddSubDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onAddSubDirButton();
            }
        });
        this.EditSubDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onEditSubDirButton();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onCancel();
            }
        });
        this.bibTeXFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onBibTeXFile();
            }
        });
        this.privacyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onPrivacy();
            }
        });
        this.backupCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onBackUp();
            }
        });
        this.backupPasswordField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    Preferences.this.backupPasswordField.setText("");
                }
            }
        });
        this.registerLinkLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.registerLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    SciPloreUtils.openURL(LocalizationSupport.message("http.www.sciplore.org.register.en.php"));
                }
            }
        });
        this.selectedPDFReadersLink.setCursor(Cursor.getPredefinedCursor(12));
        this.selectedPDFReadersLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    SciPloreUtils.openURL("http://www.sciplore.org/software/sciplore_mindmapping/manual/en/#highlightedtext");
                }
            }
        });
        this.notifyInfoLabel.addMouseListener(new PreferencesMouseListener(this, "splmm_preferences_notifyInfoText"));
        this.backupInfoLabel.addMouseListener(new PreferencesMouseListener(this, "splmm_preferences_backupInfoText"));
        this.usageMiningInfoLabel.addMouseListener(new PreferencesMouseListener(this, "splmm_preferences_usageMiningInfoText"));
        this.ironmmInfoLabel.addMouseListener(new PreferencesMouseListener(this, "splmm_preferences_ironmmInfoText"));
        this.ironldInfoLabel.addMouseListener(new PreferencesMouseListener(this, "splmm_preferences_ironldInfoText"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.loadUserData();
        this.freemind = freemind;
        this.setContentPane(this.contentPane);
        this.setTitle(LocalizationSupport.message("sciplore.mindmapping.preferences"));
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(freemind.getJFrame());
    }

    private void onRemoveSubDirButton() {
        this.subfolderModel.removeElementAt(this.listIgnoreSubDirs.getSelectedIndex());
    }

    private void onRemoveFileTypeButton() {
        this.fileTypeModel.removeElementAt(this.listImportFiles.getSelectedIndex());
    }

    private void onAddFileTypeButton() {
        EnterValueDialog dialog = new EnterValueDialog((Component)this);
        dialog.setTitle(LocalizationSupport.message("add.monitored.file.type"));
        dialog.setLabelHeadline(LocalizationSupport.message("define.new.monitored.file.type"));
        dialog.setLabelSubHeadline(LocalizationSupport.message("enter.file.type.to.be.monitored.doc.for.example"));
        dialog.setLabelEnterText(LocalizationSupport.message("file.type"));
        dialog.showDialog();
        if (dialog.getValue() != null && !dialog.getValue().isEmpty()) {
            this.fileTypeModel.addElement(dialog.getValue());
        }
    }

    private void onEditFileTypeButton() {
        EnterValueDialog dialog = new EnterValueDialog((Component)this);
        dialog.setTitle(LocalizationSupport.message("edit.monitored.file.type"));
        dialog.setLabelHeadline(LocalizationSupport.message("edit.monitored.file.type"));
        dialog.setLabelSubHeadline(LocalizationSupport.message("edit.file.type.to.be.monitored.doc.for.example"));
        dialog.setLabelEnterText(LocalizationSupport.message("file.type"));
        dialog.setValue("" + this.listImportFiles.getSelectedValue());
        dialog.showDialog();
        if (dialog.getValue() != null && !dialog.getValue().isEmpty()) {
            this.fileTypeModel.set(this.listImportFiles.getSelectedIndex(), dialog.getValue());
        }
    }

    private void onAddSubDirButton() {
        EnterValueDialog dialog = new EnterValueDialog((Component)this);
        dialog.setTitle(LocalizationSupport.message("add.ignored.subfolder"));
        dialog.setLabelHeadline(LocalizationSupport.message("define.new.subfolder"));
        dialog.setLabelSubHeadline(LocalizationSupport.message("enter.subfolder.to.be.ignored.svn.for.example"));
        dialog.setLabelEnterText(LocalizationSupport.message("subfolder"));
        dialog.showDialog();
        if (dialog.getValue() != null && !dialog.getValue().isEmpty()) {
            this.subfolderModel.addElement(dialog.getValue());
        }
    }

    private void onEditSubDirButton() {
        EnterValueDialog dialog = new EnterValueDialog((Component)this);
        dialog.setTitle(LocalizationSupport.message("edit.ignored.subfolder"));
        dialog.setLabelHeadline(LocalizationSupport.message("edit.ignored.subfolder"));
        dialog.setLabelSubHeadline(LocalizationSupport.message("edit.subfolder.to.be.ignored.svn.for.example"));
        dialog.setLabelEnterText(LocalizationSupport.message("subfolder"));
        dialog.setValue("" + this.listIgnoreSubDirs.getSelectedValue());
        dialog.showDialog();
        if (dialog.getValue() != null && !dialog.getValue().isEmpty()) {
            this.subfolderModel.set(this.listIgnoreSubDirs.getSelectedIndex(), dialog.getValue());
        }
    }

    public void selectTab(Component c) {
        this.tabbedPane1.setSelectedComponent(c);
    }

    public void activateFirstStart() {
        this.cancelButton.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    public void showPrefs(JPanel showPanel) {
        this.pack();
        this.tabbedPane1.setSelectedComponent(showPanel);
        this.setVisible(true);
    }

    public void showPrefs() {
        this.pack();
        this.setVisible(true);
    }

    public void showPrefs(boolean firstStart) {
        this.firstStart = firstStart;
        this.pack();
        this.setVisible(true);
    }

    private void loadUserData() {
        this.jabrefpathTextField.setText(SplmmPreferences.getJabRefPath());
        this.updateCheckBox.setSelected(SplmmPreferences.getUpdateInfo());
        this.backupCheckBox.setSelected(SplmmPreferences.getAllowBackup());
        this.usageMiningCheckBox.setSelected(SplmmPreferences.getAllowUsageMining());
        this.ironmmCheckBox.setSelected(SplmmPreferences.getAllowIRonMM());
        this.ironldCheckBox.setSelected(SplmmPreferences.getAllowIRonLD());
        this.userNameTextField.setEnabled(SplmmPreferences.getAllowBackup());
        this.backupPasswordField.setEnabled(SplmmPreferences.getAllowBackup());
        this.updateMonitoringFolderAutomaticallyCheckBox.setSelected(SplmmPreferences.getAutoMonDir());
        this.importFilesFromSubCheckBox.setSelected(SplmmPreferences.getImportSubfolders());
        this.importBookmarks.setSelected(SplmmPreferences.getImportBookmarks());
        this.importComments.setSelected(SplmmPreferences.getImportComments());
        this.importHighlights.setSelected(SplmmPreferences.getImportHighlights());
        if (SplmmPreferences.getAllowBackup().booleanValue() && SplmmPreferences.getUserName() != null) {
            if (SplmmPreferences.getAnonymousUserName() != null) {
                if (!SplmmPreferences.getAnonymousUserName().equalsIgnoreCase(SplmmPreferences.getUserName())) {
                    this.userNameTextField.setText(SplmmPreferences.getUserName());
                    this.backupPasswordField.setText(SplmmPreferences.getPassword());
                }
            } else {
                this.userNameTextField.setText(SplmmPreferences.getUserName());
                this.backupPasswordField.setText(SplmmPreferences.getPassword());
            }
        }
        ArrayList<String> fileTypes = SplmmPreferences.getStringList("FileTypes", SciPloreUtils.DEFAULT_FILE_TYPES);
        for (String string : fileTypes) {
            this.fileTypeModel.addElement(string);
        }
        this.listImportFiles.setModel(this.fileTypeModel);
        ArrayList<String> subfolders = SplmmPreferences.getStringList("SubFolders", SciPloreUtils.DEFAULT_SUBFOLDERS);
        for (String string : subfolders) {
            this.subfolderModel.addElement(string);
        }
        this.listIgnoreSubDirs.setModel(this.subfolderModel);
    }

    private void onOK() {
        UserDataState userDataState = new UserDataState(this);
        if (userDataState.isUserDataUpdateNeeded().booleanValue()) {
            switch (userDataState.getNewState()) {
                case 1: {
                    if (SplmmPreferences.validateBackupEntry(this.userNameTextField.getText(), String.valueOf(this.backupPasswordField.getPassword()))) break;
                    this.tabbedPane1.setSelectedComponent(this.getServicePanel());
                    return;
                }
                case 2: {
                    SplmmPreferences.createUUID();
                    break;
                }
                case 3: {
                    SplmmPreferences.createUUID();
                }
            }
        }
        if (!SplmmPreferences.getUpdateInfo().booleanValue() && this.updateCheckBox.isSelected()) {
            SciPloreUtils.checkForUpdate(this.freemind);
        }
        this.checkForEvents();
        SplmmPreferences.setAllowUsageMining(this.usageMiningCheckBox.isSelected());
        SplmmPreferences.setUpdateInfo(this.updateCheckBox.isSelected());
        SplmmPreferences.setJabRefPath(this.jabrefpathTextField.getText());
        SplmmPreferences.setAllowBackup(this.backupCheckBox.isSelected());
        SplmmPreferences.setAllowIRonMM(this.ironmmCheckBox.isSelected());
        SplmmPreferences.setAllowIRonLD(this.ironldCheckBox.isSelected());
        SplmmPreferences.setAutoMonDir(this.updateMonitoringFolderAutomaticallyCheckBox.isSelected());
        SplmmPreferences.setImportSubfolders(this.importFilesFromSubCheckBox.isSelected());
        SplmmPreferences.setImportBookmarks(this.importBookmarks.isSelected());
        SplmmPreferences.setImportComments(this.importComments.isSelected());
        SplmmPreferences.setImportHighlights(this.importHighlights.isSelected());
        this.saveStringList(this.fileTypeModel.elements(), "FileTypes");
        this.saveStringList(this.subfolderModel.elements(), "SubFolders");
        if (!this.firstStart) {
            new PrefEventSenderThread(this.freemind);
        }
        this.dispose();
    }

    private void saveStringList(Enumeration elements, String name) {
        ArrayList<String> strings = new ArrayList<String>();
        while (elements.hasMoreElements()) {
            strings.add(elements.nextElement().toString());
        }
        SplmmPreferences.setStringList(name, strings);
    }

    private void checkForEvents() {
        if (SplmmPreferences.getJabRefPath() != null && !SplmmPreferences.getJabRefPath().equalsIgnoreCase(this.jabrefpathTextField.getText())) {
            SplmmPreferences.setSendEventBibLinked(true);
        }
        if (SplmmPreferences.getAllowBackup().booleanValue() != this.backupCheckBox.isSelected()) {
            SplmmPreferences.setSendEventBackup(true);
        }
        if (SplmmPreferences.getAllowUsageMining().booleanValue() != this.usageMiningCheckBox.isSelected()) {
            SplmmPreferences.setSendEventUsageMining(true);
        }
        if (SplmmPreferences.getAllowIRonMM().booleanValue() != this.ironmmCheckBox.isSelected()) {
            SplmmPreferences.setSendEventIrmm(true);
        }
        if (SplmmPreferences.getAllowIRonLD().booleanValue() != this.ironldCheckBox.isSelected()) {
            SplmmPreferences.setSendEventIrld(true);
        }
    }

    private void onCancel() {
        this.dispose();
    }

    private void onBibTeXFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileNameExtensionFilter("BibTeX file", "bib"));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.jabrefpathTextField.setText(chooser.getSelectedFile().getPath());
        }
    }

    public void setPrivacyTab(int random) {
        switch (random) {
            case 1: {
                this.tabbedPane1.removeAll();
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab2"), this.servicePanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab1"), this.privacyPanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab3"), this.referencePanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab4"), this.monitoringPanel);
                break;
            }
            case 2: {
                this.tabbedPane1.removeAll();
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab2"), this.servicePanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab3"), this.referencePanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab1"), this.privacyPanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab4"), this.monitoringPanel);
                break;
            }
            case 3: {
                this.tabbedPane1.removeAll();
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab2"), this.servicePanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab3"), this.referencePanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab4"), this.monitoringPanel);
                this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab1"), this.privacyPanel);
            }
        }
        SplmmPreferences.setRandomTab("" + random);
    }

    public void setRandomSelection(int selectUM, int selectIRMM, int selectIRLD, int selectBackup) {
        this.usageMiningCheckBox.setSelected(SciPloreUtils.parseInt(selectUM));
        SplmmPreferences.setRandomUM("" + selectUM);
        this.ironmmCheckBox.setSelected(SciPloreUtils.parseInt(selectIRMM));
        SplmmPreferences.setRandomIRMM("" + selectIRMM);
        this.ironldCheckBox.setSelected(SciPloreUtils.parseInt(selectIRLD));
        SplmmPreferences.setRandomIRLD("" + selectIRLD);
        this.backupCheckBox.setSelected(SciPloreUtils.parseInt(selectBackup));
        SplmmPreferences.setRandomBackup("" + selectBackup);
    }

    public void setInfoText(int showInfoText) {
        switch (showInfoText) {
            case 1: {
                this.privacyInfoLabel.setText("");
                break;
            }
            case 2: {
                this.privacyInfoLabel.setText(LocalizationSupport.message("ir_notification_text"));
            }
        }
        SplmmPreferences.setRandomInfoText("" + showInfoText);
    }

    public void setInfoLinks(int showInfoLinks) {
        if (!SciPloreUtils.parseInt(showInfoLinks)) {
            this.usageMiningInfoLabel.setVisible(false);
            this.ironmmInfoLabel.setVisible(false);
            this.ironldInfoLabel.setVisible(false);
            this.backupInfoLabel.setVisible(false);
            this.notifyInfoLabel.setVisible(false);
        }
        SplmmPreferences.setRandomInfoLabel("" + showInfoLinks);
    }

    public void setPrivacyInfoButton(int showButton) {
        this.privacyButton.setVisible(SciPloreUtils.parseInt(showButton));
        SplmmPreferences.setRandomPrivacyButton("" + showButton);
    }

    private void onPrivacy() {
        SciPloreUtils.openURL(SciPloreUtils.PRIVACY_URL);
    }

    private void onBackUp() {
        this.userNameTextField.setEnabled(this.backupCheckBox.isSelected());
        this.backupPasswordField.setEnabled(this.backupCheckBox.isSelected());
    }

    public JCheckBox getBackupCheckBox() {
        return this.backupCheckBox;
    }

    public JCheckBox getIronmmCheckBox() {
        return this.ironmmCheckBox;
    }

    public JPasswordField getBackupPasswordField() {
        return this.backupPasswordField;
    }

    public JTextField getUserNameTextField() {
        return this.userNameTextField;
    }

    public JCheckBox getIronldCheckBox() {
        return this.ironldCheckBox;
    }

    public JCheckBox getUsageMiningCheckBox() {
        return this.usageMiningCheckBox;
    }

    public JPanel getServicePanel() {
        return this.servicePanel;
    }

    public JPanel getPrivacyPanel() {
        return this.privacyPanel;
    }

    public JPanel getReferencePanel() {
        return this.referencePanel;
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(5, 5, 5, 5), -1, -1));
        this.contentPane.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 3, null, null, null, 0, false));
        this.tabbedPane1 = new JTabbedPane();
        this.tabbedPane1.setToolTipText("");
        panel1.add((Component)this.tabbedPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null, 0, false));
        this.servicePanel = new JPanel();
        this.servicePanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(10, 5, 5, 5), -1, -1));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab2"), this.servicePanel);
        Spacer spacer1 = new Spacer();
        this.servicePanel.add((Component)spacer1, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 7), null, 0, false));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.servicePanel.add((Component)panel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        this.$$$loadLabelText$$$(label1, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_username"));
        panel2.add((Component)label1, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        this.$$$loadLabelText$$$(label2, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_password"));
        panel2.add((Component)label2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.backupPasswordField = new JPasswordField();
        panel2.add((Component)this.backupPasswordField, new GridConstraints(1, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        this.userNameTextField = new JTextField();
        panel2.add((Component)this.userNameTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.servicePanel.add((Component)panel3, new GridConstraints(1, 0, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel4, new GridConstraints(1, 0, 1, 1, 8, 2, 3, 3, null, null, null, 0, false));
        this.backupInfoLabel = new JLabel();
        this.backupInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.backupInfoLabel.setText("");
        panel4.add((Component)this.backupInfoLabel, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        JLabel label3 = new JLabel();
        this.$$$loadLabelText$$$(label3, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_backup2"));
        panel4.add((Component)label3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        this.backupCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.backupCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_backup"));
        this.backupCheckBox.setToolTipText("");
        panel4.add((Component)this.backupCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, new Dimension(57, 22), null, 0, false));
        this.registerLinkLabel = new JLabel();
        this.registerLinkLabel.setFont(new Font(this.registerLinkLabel.getFont().getName(), 1, this.registerLinkLabel.getFont().getSize()));
        this.registerLinkLabel.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(this.registerLinkLabel, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_registerLink"));
        this.registerLinkLabel.setVerticalTextPosition(0);
        panel4.add((Component)this.registerLinkLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, new Dimension(89, 14), null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel3.add((Component)panel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.updateCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.updateCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_notify"));
        this.updateCheckBox.setToolTipText("");
        panel5.add((Component)this.updateCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.notifyInfoLabel = new JLabel();
        this.notifyInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.notifyInfoLabel.setText("");
        panel5.add((Component)this.notifyInfoLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(23, 16), null, 0, false));
        Spacer spacer2 = new Spacer();
        panel5.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, new Dimension(97, 11), null, 0, false));
        Spacer spacer3 = new Spacer();
        this.servicePanel.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 10), new Dimension(-1, 10), new Dimension(-1, 10), 0, false));
        Spacer spacer4 = new Spacer();
        this.servicePanel.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.privacyPanel = new JPanel();
        this.privacyPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(10, 5, 5, 5), -1, -1));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab1"), this.privacyPanel);
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.privacyPanel.add((Component)panel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.usageMiningCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.usageMiningCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_prferences_usageMining"));
        this.usageMiningCheckBox.setToolTipText("");
        panel6.add((Component)this.usageMiningCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.usageMiningInfoLabel = new JLabel();
        this.usageMiningInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.usageMiningInfoLabel.setText("");
        panel6.add((Component)this.usageMiningInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        panel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.privacyPanel.add((Component)panel7, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.ironmmCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ironmmCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_informationMindMaps"));
        this.ironmmCheckBox.setToolTipText("");
        panel7.add((Component)this.ironmmCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.ironmmInfoLabel = new JLabel();
        this.ironmmInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.ironmmInfoLabel.setText("");
        panel7.add((Component)this.ironmmInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer6 = new Spacer();
        panel7.add((Component)spacer6, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel8 = new JPanel();
        panel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.privacyPanel.add((Component)panel8, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.ironldCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.ironldCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_informationLinkedData"));
        this.ironldCheckBox.setToolTipText("");
        panel8.add((Component)this.ironldCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null, 0, false));
        this.ironldInfoLabel = new JLabel();
        this.ironldInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/images/icons/info.png")));
        this.ironldInfoLabel.setText("");
        panel8.add((Component)this.ironldInfoLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        panel8.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        Spacer spacer8 = new Spacer();
        this.privacyPanel.add((Component)spacer8, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 10), null, 0, false));
        this.privacyInfoLabel = new JLabel();
        this.privacyInfoLabel.setFont(new Font(this.privacyInfoLabel.getFont().getName(), 1, this.privacyInfoLabel.getFont().getSize()));
        this.$$$loadLabelText$$$(this.privacyInfoLabel, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_helpText"));
        this.privacyPanel.add((Component)this.privacyInfoLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer9 = new Spacer();
        this.privacyPanel.add((Component)spacer9, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.referencePanel = new JPanel();
        this.referencePanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 5, 5, 5), -1, -1));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab3"), this.referencePanel);
        JLabel label4 = new JLabel();
        label4.setFont(new Font(label4.getFont().getName(), 1, label4.getFont().getSize()));
        this.$$$loadLabelText$$$(label4, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_BibTexText"));
        this.referencePanel.add((Component)label4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        JPanel panel9 = new JPanel();
        panel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.referencePanel.add((Component)panel9, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.bibTeXFileButton = new JButton();
        this.$$$loadButtonText$$$(this.bibTeXFileButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_BibTexButton"));
        panel9.add((Component)this.bibTeXFileButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.jabrefpathTextField = new JTextField();
        panel9.add((Component)this.jabrefpathTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 4, 0, null, new Dimension(150, -1), null, 0, false));
        Spacer spacer10 = new Spacer();
        this.referencePanel.add((Component)spacer10, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 70), null, null, 0, false));
        Spacer spacer11 = new Spacer();
        this.referencePanel.add((Component)spacer11, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.monitoringPanel = new JPanel();
        this.monitoringPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1));
        this.tabbedPane1.addTab(ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_tab4"), this.monitoringPanel);
        JPanel panel10 = new JPanel();
        panel10.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.monitoringPanel.add((Component)panel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel10.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_default_values")));
        Spacer spacer12 = new Spacer();
        panel10.add((Component)spacer12, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.updateMonitoringFolderAutomaticallyCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.updateMonitoringFolderAutomaticallyCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_MonAutoUpdate"));
        panel10.add((Component)this.updateMonitoringFolderAutomaticallyCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        this.importFilesFromSubCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(this.importFilesFromSubCheckBox, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_importSubDirs"));
        panel10.add((Component)this.importFilesFromSubCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        JPanel panel11 = new JPanel();
        panel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.monitoringPanel.add((Component)panel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel12 = new JPanel();
        panel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel11.add((Component)panel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_JlistTitle1")));
        JPanel panel13 = new JPanel();
        panel13.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel12.add((Component)panel13, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.addFileTypeButton = new JButton();
        this.$$$loadButtonText$$$(this.addFileTypeButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_add"));
        panel13.add((Component)this.addFileTypeButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer13 = new Spacer();
        panel13.add((Component)spacer13, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.editFileTypeButton = new JButton();
        this.$$$loadButtonText$$$(this.editFileTypeButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_edit"));
        panel13.add((Component)this.editFileTypeButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.removeFileTypeButton = new JButton();
        this.$$$loadButtonText$$$(this.removeFileTypeButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_Remove"));
        panel13.add((Component)this.removeFileTypeButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JScrollPane scrollPane1 = new JScrollPane();
        panel12.add((Component)scrollPane1, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        scrollPane1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.listImportFiles = new JList();
        this.listImportFiles.setSelectionMode(0);
        scrollPane1.setViewportView(this.listImportFiles);
        JPanel panel14 = new JPanel();
        panel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        panel11.add((Component)panel14, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel14.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_Jlist2Title2")));
        JPanel panel15 = new JPanel();
        panel15.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        panel14.add((Component)panel15, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.AddSubDirButton = new JButton();
        this.$$$loadButtonText$$$(this.AddSubDirButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_add"));
        panel15.add((Component)this.AddSubDirButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        Spacer spacer14 = new Spacer();
        panel15.add((Component)spacer14, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.EditSubDirButton = new JButton();
        this.$$$loadButtonText$$$(this.EditSubDirButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_edit"));
        panel15.add((Component)this.EditSubDirButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.removeSubDirButton = new JButton();
        this.$$$loadButtonText$$$(this.removeSubDirButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_Remove"));
        panel15.add((Component)this.removeSubDirButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JScrollPane scrollPane2 = new JScrollPane();
        panel14.add((Component)scrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        scrollPane2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLoweredBevelBorder(), null));
        this.listIgnoreSubDirs = new JList();
        scrollPane2.setViewportView(this.listIgnoreSubDirs);
        this.pdfmanagementPanel = new JPanel();
        this.pdfmanagementPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.tabbedPane1.addTab("PDF Management", this.pdfmanagementPanel);
        JPanel panel16 = new JPanel();
        panel16.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.pdfmanagementPanel.add((Component)panel16, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null, 1, false));
        panel16.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Annotations to import from PDFs"));
        this.importBookmarks = new JCheckBox();
        this.importBookmarks.setText("Bookmarks");
        panel16.add((Component)this.importBookmarks, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(152, 22), null, 0, false));
        this.importComments = new JCheckBox();
        this.importComments.setText("Comments");
        panel16.add((Component)this.importComments, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, new Dimension(152, 22), null, 0, false));
        Spacer spacer15 = new Spacer();
        panel16.add((Component)spacer15, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 4, null, new Dimension(152, 14), new Dimension(-1, 30), 0, false));
        JPanel panel17 = new JPanel();
        panel17.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1));
        panel16.add((Component)panel17, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.importHighlights = new JCheckBox();
        this.importHighlights.setHorizontalTextPosition(11);
        this.importHighlights.setText("Highlighted text (works only with");
        panel17.add((Component)this.importHighlights, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, new Dimension(40, 22), null, 0, false));
        this.selectedPDFReadersLink = new JLabel();
        this.selectedPDFReadersLink.setFont(new Font(this.selectedPDFReadersLink.getFont().getName(), 1, this.selectedPDFReadersLink.getFont().getSize()));
        this.selectedPDFReadersLink.setHorizontalAlignment(2);
        this.selectedPDFReadersLink.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(this.selectedPDFReadersLink, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_pdfReadersLink"));
        this.selectedPDFReadersLink.setVerticalTextPosition(0);
        panel17.add((Component)this.selectedPDFReadersLink, new GridConstraints(0, 1, 1, 1, 8, 0, 1, 3, null, null, null, 0, false));
        JLabel label5 = new JLabel();
        label5.setHorizontalAlignment(2);
        label5.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(label5, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_backup21"));
        panel17.add((Component)label5, new GridConstraints(0, 2, 1, 1, 8, 0, 1, 0, null, null, null, 0, false));
        Spacer spacer16 = new Spacer();
        panel17.add((Component)spacer16, new GridConstraints(0, 3, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel18 = new JPanel();
        panel18.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel18, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.privacyButton = new JButton();
        this.$$$loadButtonText$$$(this.privacyButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_preferences_moreInfo"));
        panel18.add((Component)this.privacyButton, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 3, null, new Dimension(134, 24), null, 0, false));
        this.cancelButton = new JButton();
        this.$$$loadButtonText$$$(this.cancelButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("cancel"));
        panel18.add((Component)this.cancelButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        this.okButton = new JButton();
        this.$$$loadButtonText$$$(this.okButton, ResourceBundle.getBundle("splmm/Localization/splmm").getString("splmm_update_ok"));
        panel18.add((Component)this.okButton, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 3, null, null, null, 0, false));
        Spacer spacer17 = new Spacer();
        panel18.add((Component)spacer17, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 4, null, new Dimension(-1, 5), null, 0, false));
    }

    private void $$$loadLabelText$$$(JLabel component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setDisplayedMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    private void $$$loadButtonText$$$(AbstractButton component, String text) {
        StringBuffer result = new StringBuffer();
        boolean haveMnemonic = false;
        char mnemonic = '\u0000';
        int mnemonicIndex = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '&') {
                if (++i == text.length()) break;
                if (!haveMnemonic && text.charAt(i) != '&') {
                    haveMnemonic = true;
                    mnemonic = text.charAt(i);
                    mnemonicIndex = result.length();
                }
            }
            result.append(text.charAt(i));
        }
        component.setText(result.toString());
        if (haveMnemonic) {
            component.setMnemonic(mnemonic);
            component.setDisplayedMnemonicIndex(mnemonicIndex);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

