/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.main.FreeMindMain;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public class UpdateAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    MindMapController controller;
    HashMap<String, Collection<BibTex>> bibTexMap;
    int newcounter = 0;
    int oldcounter = 0;
    FreeMindMain frame;

    public UpdateAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_menu_update"));
        this.controller = controller;
        this.frame = controller.getFrame();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.newcounter = 0;
        File file = new File("" + SplmmPreferences.getJabRefPath());
        if (file.exists()) {
            BibTex bib = new BibTex();
            this.bibTexMap = bib.readBibtex(file);
            ControllerAdapter adapter = this.controller.getModeController();
            MindMapNode node = adapter.getRootNode();
            this.newcounter = 0;
            this.oldcounter = 0;
            this.help(node);
            if (this.newcounter > 0) {
                JOptionPane.showMessageDialog(this.frame.getContentPane(), this.oldcounter + " " + LocalizationSupport.message("splmm_update_KeyFound2") + " " + this.newcounter + " " + LocalizationSupport.message("splmm_update_KeyFound"));
            } else {
                JOptionPane.showMessageDialog(this.frame.getContentPane(), LocalizationSupport.message("splmm_update_noKeyFound"));
            }
            new EventSenderThread(SciPloreUtils.EVENT_UPDATE_REFKEYS, this.oldcounter + ";" + this.newcounter);
        } else {
            JOptionPane.showMessageDialog(this.frame.getContentPane(), LocalizationSupport.message("splmm_update_noBibTex"));
        }
    }

    private void help(MindMapNode parent) {
        BibTex.RefKeyState state = BibTex.addBibtexData(parent, this.bibTexMap);
        if (state.equals((Object)BibTex.RefKeyState.newRefkey)) {
            ++this.newcounter;
        }
        if (state.equals((Object)BibTex.RefKeyState.oldRefkey)) {
            ++this.oldcounter;
        }
        List children = parent.getChildren();
        for (MindMapNode child : children) {
            this.help(child);
        }
    }

    private void setAttribute(MindMapNode node, String value, String attributeKey) {
        if (node == null || value == null || value.isEmpty() || attributeKey.isEmpty() || attributeKey == null) {
            return;
        }
        Attribute pAttribute = new Attribute(attributeKey, value);
        if (node.getAttributeKeyList().size() == 0) {
            node.createAttributeTableModel();
        }
        if (this.HasSplmmAttribute(attributeKey, node)) {
            Attribute splmmAttribute = this.GetSplmmAttribute(attributeKey, node);
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME) && splmmAttribute.getValue().equalsIgnoreCase(value)) {
                ++this.oldcounter;
            } else if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME) && splmmAttribute.getValue().equalsIgnoreCase(value)) {
                ++this.newcounter;
            }
            splmmAttribute.setValue(value);
            this.controller.getModeController().nodeChanged(node);
        } else {
            if (attributeKey.equalsIgnoreCase(SciPloreUtils.SPLMM_REFKEY_NAME)) {
                ++this.newcounter;
            }
            node.getAttributes().addRowNoUndo(pAttribute);
            this.controller.getModeController().nodeChanged(node);
        }
        BookmarkMindMapNode.SetOptimalColumnWidth(node);
    }

    private Attribute GetSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return a;
        }
        return null;
    }

    private boolean HasSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return true;
        }
        return false;
    }

    private boolean IsNewAttribute(MindMapNode node, Attribute attribute) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attribute.getName()) || !a.getValue().equalsIgnoreCase(attribute.getValue())) continue;
            return false;
        }
        return true;
    }
}

