/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

class ForkMainView
extends MainView {
    ForkMainView() {
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        NodeView nodeView = this.getNodeView();
        MindMapNode model = nodeView.getModel();
        if (model == null) {
            return;
        }
        Object renderingHint = this.getController().setEdgesRenderingHint(g);
        this.paintSelected(g);
        this.paintDragOver(g);
        int edgeWidth = model.getEdge().getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        Color oldColor = g.getColor();
        g.setColor(model.getEdge().getColor());
        g.drawLine(0, this.getHeight() - edgeWidth / 2 - 1, this.getWidth(), this.getHeight() - edgeWidth / 2 - 1);
        g.setColor(oldColor);
        Tools.restoreAntialiasing(g, renderingHint);
        super.paint(g);
    }

    @Override
    void paintFoldingMark(NodeView nodeView, Graphics2D g, Point p) {
        int zoomedFoldingSymbolHalfWidth = this.getZoomedFoldingSymbolHalfWidth();
        p.x = nodeView.isLeft() ? (p.x -= zoomedFoldingSymbolHalfWidth) : (p.x += zoomedFoldingSymbolHalfWidth);
        super.paintFoldingMark(nodeView, g, p);
    }

    @Override
    protected int getMainViewWidthWithFoldingMark() {
        int width = this.getWidth();
        if (this.getNodeView().getModel().isFolded()) {
            width += this.getZoomedFoldingSymbolHalfWidth() * 2 + this.getZoomedFoldingSymbolHalfWidth();
        }
        return width;
    }

    @Override
    protected int getMainViewHeightWithFoldingMark() {
        int height = this.getHeight();
        if (this.getNodeView().getModel().isFolded()) {
            height += this.getZoomedFoldingSymbolHalfWidth();
        }
        return height;
    }

    @Override
    public int getDeltaX() {
        if (this.getNodeView().getModel().isFolded() && this.getNodeView().isLeft()) {
            return super.getDeltaX() + this.getZoomedFoldingSymbolHalfWidth() * 3;
        }
        return super.getDeltaX();
    }

    @Override
    String getStyle() {
        return "fork";
    }

    @Override
    int getAlignment() {
        return -1;
    }

    @Override
    Point getLeftPoint() {
        int edgeWidth = this.getNodeView().getModel().getEdge().getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        Point in = new Point(0, this.getHeight() - edgeWidth / 2 - 1);
        return in;
    }

    @Override
    Point getCenterPoint() {
        Point in = new Point(this.getWidth() / 2, this.getHeight() / 2);
        return in;
    }

    @Override
    Point getRightPoint() {
        int edgeWidth = this.getNodeView().getModel().getEdge().getWidth();
        if (edgeWidth == 0) {
            edgeWidth = 1;
        }
        Point in = new Point(this.getWidth() - 1, this.getHeight() - edgeWidth / 2 - 1);
        return in;
    }
}

