/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller.filter;

import freemind.common.NamedObject;
import freemind.controller.Controller;
import freemind.controller.filter.FilterController;
import freemind.controller.filter.FilterToolbar;
import freemind.controller.filter.condition.Condition;
import freemind.controller.filter.condition.ConditionNotSatisfiedDecorator;
import freemind.controller.filter.condition.ConjunctConditions;
import freemind.controller.filter.condition.DisjunctConditions;
import freemind.controller.filter.util.ExtendedComboBoxModel;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MapRegistry;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.ModeController;
import freemind.modes.attributes.AttributeRegistry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class FilterComposerDialog
extends JDialog {
    private static final Dimension maxButtonDimension = new Dimension(1000, 1000);
    private static final int NODE_POSITION = 0;
    private static final int ICON_POSITION = 1;
    private Controller c;
    private FilterController fc;
    private JList conditionList;
    private JComboBox simpleCondition;
    private JComboBox values;
    private JComboBox attributes;
    private FilterToolbar ft;
    private JButton btnAdd;
    private JButton btnNot;
    private JButton btnAnd;
    private JButton btnOr;
    private JButton btnDelete;
    private JCheckBox caseInsensitive;
    private ExtendedComboBoxModel icons;
    private ExtendedComboBoxModel nodes;
    private AttributeRegistry registeredAttributes;
    private DefaultComboBoxModel simpleNodeConditionComboBoxModel;
    private DefaultComboBoxModel simpleIconConditionComboBoxModel;
    private DefaultComboBoxModel simpleAttributeConditionComboBoxModel;
    private ExtendedComboBoxModel filteredAttributeComboBoxModel;
    private DefaultComboBoxModel internalConditionsModel;
    private ComboBoxModel externalConditionsModel;
    private JButton btnOK;
    private JButton btnApply;
    private JButton btnCancel;
    private JButton btnSave;
    private JButton btnLoad;
    private ConditionListSelectionListener conditionListListener;

    protected JFileChooser getFileChooser() {
        ModeController modeController = this.fc.getMap().getModeController();
        JFileChooser chooser = modeController.getFileChooser(MindMapFilterFileFilter.filter);
        return chooser;
    }

    public FilterComposerDialog(Controller c, FilterToolbar ft) {
        super((Frame)c.getJFrame(), c.getResourceString("filter_dialog"));
        this.c = c;
        this.fc = c.getFilterController();
        this.ft = ft;
        Box simpleConditionBox = Box.createHorizontalBox();
        simpleConditionBox.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.getContentPane().add((Component)simpleConditionBox, "North");
        this.attributes = new JComboBox();
        this.filteredAttributeComboBoxModel = new ExtendedComboBoxModel(new NamedObject[]{Resources.getInstance().createTranslatedString("filter_node"), Resources.getInstance().createTranslatedString("filter_icon")});
        MapRegistry registry = c.getModel().getRegistry();
        this.registeredAttributes = registry.getAttributes();
        this.filteredAttributeComboBoxModel.setExtensionList(this.registeredAttributes.getListBoxModel());
        this.attributes.setModel(this.filteredAttributeComboBoxModel);
        this.attributes.addItemListener(new SelectedAttributeChangeListener());
        simpleConditionBox.add(Box.createHorizontalGlue());
        simpleConditionBox.add(this.attributes);
        this.attributes.setRenderer(this.fc.getConditionRenderer());
        FilterComposerDialog filterComposerDialog = this;
        this.simpleNodeConditionComboBoxModel = new DefaultComboBoxModel<NamedObject>(filterComposerDialog.fc.getConditionFactory().getNodeConditionNames());
        FilterComposerDialog filterComposerDialog2 = this;
        this.simpleIconConditionComboBoxModel = new DefaultComboBoxModel<Object>(filterComposerDialog2.fc.getConditionFactory().getIconConditionNames());
        this.simpleCondition = new JComboBox();
        this.simpleCondition.setModel(this.simpleNodeConditionComboBoxModel);
        this.simpleCondition.addItemListener(new SimpleConditionChangeListener());
        simpleConditionBox.add(Box.createHorizontalGlue());
        simpleConditionBox.add(this.simpleCondition);
        this.simpleCondition.setRenderer(this.fc.getConditionRenderer());
        FilterComposerDialog filterComposerDialog3 = this;
        this.simpleAttributeConditionComboBoxModel = new DefaultComboBoxModel<NamedObject>(filterComposerDialog3.fc.getConditionFactory().getAttributeConditionNames());
        this.values = new JComboBox();
        this.nodes = new ExtendedComboBoxModel();
        this.values.setModel(this.nodes);
        simpleConditionBox.add(Box.createHorizontalGlue());
        simpleConditionBox.add(this.values);
        this.values.setRenderer(this.fc.getConditionRenderer());
        this.values.setEditable(true);
        this.icons = new ExtendedComboBoxModel();
        this.icons.setExtensionList(registry.getIcons());
        this.caseInsensitive = new JCheckBox();
        simpleConditionBox.add(Box.createHorizontalGlue());
        simpleConditionBox.add(this.caseInsensitive);
        this.caseInsensitive.setText(Resources.getInstance().getResourceString("filter_ignore_case"));
        Box conditionButtonBox = Box.createVerticalBox();
        conditionButtonBox.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.getContentPane().add((Component)conditionButtonBox, "East");
        this.btnAdd = new JButton(new AddConditionAction());
        this.btnAdd.setMaximumSize(maxButtonDimension);
        conditionButtonBox.add(Box.createVerticalGlue());
        conditionButtonBox.add(this.btnAdd);
        this.btnNot = new JButton(new CreateNotSatisfiedConditionAction());
        conditionButtonBox.add(Box.createVerticalGlue());
        this.btnNot.setMaximumSize(maxButtonDimension);
        conditionButtonBox.add(this.btnNot);
        this.btnNot.setEnabled(false);
        this.btnAnd = new JButton(new CreateConjunctConditionAction());
        conditionButtonBox.add(Box.createVerticalGlue());
        this.btnAnd.setMaximumSize(maxButtonDimension);
        conditionButtonBox.add(this.btnAnd);
        this.btnAnd.setEnabled(false);
        this.btnOr = new JButton(new CreateDisjunctConditionAction());
        conditionButtonBox.add(Box.createVerticalGlue());
        this.btnOr.setMaximumSize(maxButtonDimension);
        conditionButtonBox.add(this.btnOr);
        this.btnOr.setEnabled(false);
        this.btnDelete = new JButton(new DeleteConditionAction());
        this.btnDelete.setEnabled(false);
        conditionButtonBox.add(Box.createVerticalGlue());
        this.btnDelete.setMaximumSize(maxButtonDimension);
        conditionButtonBox.add(this.btnDelete);
        conditionButtonBox.add(Box.createVerticalGlue());
        Box controllerBox = Box.createHorizontalBox();
        controllerBox.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.getContentPane().add((Component)controllerBox, "South");
        CloseAction closeAction = new CloseAction();
        this.btnOK = new JButton();
        Tools.setLabelAndMnemonic(this.btnOK, Resources.getInstance().getResourceString("ok"));
        this.btnOK.addActionListener(closeAction);
        this.btnOK.setMaximumSize(maxButtonDimension);
        this.btnApply = new JButton();
        Tools.setLabelAndMnemonic(this.btnApply, Resources.getInstance().getResourceString("apply"));
        this.btnApply.addActionListener(closeAction);
        this.btnApply.setMaximumSize(maxButtonDimension);
        this.btnCancel = new JButton();
        Tools.setLabelAndMnemonic(this.btnCancel, Resources.getInstance().getResourceString("cancel"));
        this.btnCancel.addActionListener(closeAction);
        this.btnCancel.setMaximumSize(maxButtonDimension);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(this.btnOK);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(this.btnApply);
        controllerBox.add(Box.createHorizontalGlue());
        controllerBox.add(this.btnCancel);
        controllerBox.add(Box.createHorizontalGlue());
        if (!c.getFrame().isApplet()) {
            SaveAction saveAction = new SaveAction();
            this.btnSave = new JButton();
            Tools.setLabelAndMnemonic(this.btnSave, Resources.getInstance().getResourceString("save"));
            this.btnSave.addActionListener(saveAction);
            this.btnSave.setMaximumSize(maxButtonDimension);
            LoadAction loadAction = new LoadAction();
            this.btnLoad = new JButton();
            Tools.setLabelAndMnemonic(this.btnLoad, Resources.getInstance().getResourceString("load"));
            this.btnLoad.addActionListener(loadAction);
            this.btnLoad.setMaximumSize(maxButtonDimension);
            controllerBox.add(this.btnSave);
            controllerBox.add(Box.createHorizontalGlue());
            controllerBox.add(this.btnLoad);
            controllerBox.add(Box.createHorizontalGlue());
        }
        this.conditionList = new JList();
        this.conditionList.setSelectionMode(2);
        this.conditionList.setCellRenderer(this.fc.getConditionRenderer());
        this.conditionList.setLayoutOrientation(0);
        this.conditionList.setAlignmentX(0.0f);
        this.conditionListListener = new ConditionListSelectionListener();
        this.conditionList.addListSelectionListener(this.conditionListListener);
        this.conditionList.addMouseListener(new ConditionListMouseListener());
        JScrollPane conditionScrollPane = new JScrollPane(this.conditionList);
        JLabel conditionColumnHeader = new JLabel(Resources.getInstance().getResourceString("filter_conditions"));
        conditionColumnHeader.setHorizontalAlignment(0);
        conditionScrollPane.setColumnHeaderView(conditionColumnHeader);
        conditionScrollPane.setPreferredSize(new Dimension(500, 200));
        this.getContentPane().add((Component)conditionScrollPane, "Center");
        Tools.addEscapeActionToDialog(this);
        this.pack();
    }

    private String getAttributeValue() {
        if (this.attributes.getSelectedIndex() == 1) {
            MindIcon mi = (MindIcon)this.values.getSelectedItem();
            return mi.getName();
        }
        Object item = this.values.getSelectedItem();
        return item != null ? item.toString() : "";
    }

    void mapChanged(MindMap newMap) {
        if (newMap != null) {
            this.icons.setExtensionList(newMap.getRegistry().getIcons());
            if (this.icons.getSize() >= 1 && this.values.getModel() == this.icons) {
                this.values.setSelectedIndex(0);
            } else {
                this.values.setSelectedIndex(-1);
                if (this.values.getModel() == this.icons) {
                    this.values.setSelectedItem(null);
                }
            }
            if (this.attributes.getSelectedIndex() > 1) {
                this.attributes.setSelectedIndex(0);
            }
            this.registeredAttributes = newMap.getRegistry().getAttributes();
            this.filteredAttributeComboBoxModel.setExtensionList(this.registeredAttributes.getListBoxModel());
        } else {
            this.icons.setExtensionList(null);
            this.values.setSelectedIndex(-1);
            this.attributes.setSelectedIndex(0);
            this.filteredAttributeComboBoxModel.setExtensionList(null);
        }
    }

    private boolean selectCondition() {
        int max;
        int min = this.conditionList.getMinSelectionIndex();
        if (min >= 0 && min == (max = this.conditionList.getMinSelectionIndex())) {
            this.applyChanges();
            return true;
        }
        return false;
    }

    public void setSelectedItem(Object selectedItem) {
        this.conditionList.setSelectedValue(selectedItem, true);
    }

    @Override
    public void show() {
        this.initInternalConditionModel();
        super.show();
    }

    private void initInternalConditionModel() {
        this.externalConditionsModel = this.fc.getFilterConditionModel();
        if (this.internalConditionsModel == null) {
            this.internalConditionsModel = new DefaultComboBoxModel();
            this.internalConditionsModel.addListDataListener(this.conditionListListener);
            this.conditionList.setModel(this.internalConditionsModel);
        } else {
            this.internalConditionsModel.removeAllElements();
        }
        int index = -1;
        for (int i = 2; i < this.externalConditionsModel.getSize(); ++i) {
            Object element = this.externalConditionsModel.getElementAt(i);
            this.internalConditionsModel.addElement(element);
            if (element != this.externalConditionsModel.getSelectedItem()) continue;
            index = i - 2;
        }
        if (index >= 0) {
            this.conditionList.setSelectedIndex(index);
        } else {
            this.conditionList.clearSelection();
        }
    }

    private void applyChanges() {
        this.internalConditionsModel.setSelectedItem(this.conditionList.getSelectedValue());
        this.internalConditionsModel.removeListDataListener(this.conditionListListener);
        this.fc.setFilterConditionModel(this.internalConditionsModel);
        this.internalConditionsModel = null;
    }

    private class SelectedAttributeChangeListener
    implements ItemListener {
        private SelectedAttributeChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (FilterComposerDialog.this.attributes.getSelectedIndex() == 0) {
                    FilterComposerDialog.this.simpleCondition.setModel(FilterComposerDialog.this.simpleNodeConditionComboBoxModel);
                    FilterComposerDialog.this.simpleCondition.setEnabled(true);
                    FilterComposerDialog.this.values.setEditable(true);
                    FilterComposerDialog.this.values.setEnabled(true);
                    FilterComposerDialog.this.nodes.setExtensionList(null);
                    FilterComposerDialog.this.values.setModel(FilterComposerDialog.this.nodes);
                    FilterComposerDialog.this.caseInsensitive.setEnabled(true);
                    return;
                }
                if (FilterComposerDialog.this.attributes.getSelectedIndex() == 1) {
                    FilterComposerDialog.this.simpleCondition.setModel(FilterComposerDialog.this.simpleIconConditionComboBoxModel);
                    FilterComposerDialog.this.simpleCondition.setSelectedIndex(0);
                    FilterComposerDialog.this.simpleCondition.setEnabled(false);
                    FilterComposerDialog.this.values.setEditable(false);
                    FilterComposerDialog.this.values.setEnabled(true);
                    FilterComposerDialog.this.values.setModel(FilterComposerDialog.this.icons);
                    if (FilterComposerDialog.this.icons.getSize() >= 1) {
                        FilterComposerDialog.this.values.setSelectedIndex(0);
                    }
                    FilterComposerDialog.this.caseInsensitive.setEnabled(false);
                    return;
                }
                if (FilterComposerDialog.this.attributes.getSelectedIndex() > 0) {
                    String attributeName = FilterComposerDialog.this.attributes.getSelectedItem().toString();
                    FilterComposerDialog.this.nodes.setExtensionList(FilterComposerDialog.this.registeredAttributes.getElement((Comparable)((Object)attributeName)).getValues());
                    FilterComposerDialog.this.values.setModel(FilterComposerDialog.this.nodes);
                    if (FilterComposerDialog.this.values.getSelectedItem() != null) {
                        if (FilterComposerDialog.this.nodes.getSize() >= 1) {
                            FilterComposerDialog.this.values.setSelectedIndex(0);
                        } else {
                            FilterComposerDialog.this.values.setSelectedItem(null);
                        }
                    }
                    if (FilterComposerDialog.this.simpleCondition.getModel() != FilterComposerDialog.this.simpleAttributeConditionComboBoxModel) {
                        FilterComposerDialog.this.simpleCondition.setModel(FilterComposerDialog.this.simpleAttributeConditionComboBoxModel);
                        FilterComposerDialog.this.simpleCondition.setSelectedIndex(0);
                    }
                    if (FilterComposerDialog.this.simpleCondition.getSelectedIndex() == 0) {
                        FilterComposerDialog.this.caseInsensitive.setEnabled(false);
                        FilterComposerDialog.this.values.setEnabled(false);
                    }
                    FilterComposerDialog.this.values.setEditable(true);
                    FilterComposerDialog.this.simpleCondition.setEnabled(true);
                    return;
                }
            }
        }
    }

    private class SimpleConditionChangeListener
    implements ItemListener {
        private SimpleConditionChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                boolean considerValue = !FilterComposerDialog.this.simpleCondition.getSelectedItem().equals("filter_exist") && !FilterComposerDialog.this.simpleCondition.getSelectedItem().equals("filter_does_not_exist");
                FilterComposerDialog.this.caseInsensitive.setEnabled(considerValue);
                FilterComposerDialog.this.values.setEnabled(considerValue);
            }
        }
    }

    private class LoadAction
    implements ActionListener {
        private LoadAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = FilterComposerDialog.this.getFileChooser();
            int returnVal = chooser.showOpenDialog(FilterComposerDialog.this);
            if (returnVal == 0) {
                try {
                    File theFile = chooser.getSelectedFile();
                    FilterComposerDialog.this.fc.loadConditions(FilterComposerDialog.this.internalConditionsModel, theFile.getCanonicalPath());
                }
                catch (Exception ex) {
                    this.handleLoadingException(ex);
                }
            }
        }

        private void handleLoadingException(Exception ex) {
        }
    }

    private class SaveAction
    implements ActionListener {
        private SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = FilterComposerDialog.this.getFileChooser();
            chooser.setDialogTitle(Resources.getInstance().getResourceString("save_as"));
            int returnVal = chooser.showSaveDialog(FilterComposerDialog.this);
            if (returnVal != 0) {
                return;
            }
            try {
                File f = chooser.getSelectedFile();
                String canonicalPath = f.getCanonicalPath();
                String suffix = ".mmfilter";
                if (!canonicalPath.endsWith(".mmfilter")) {
                    canonicalPath = canonicalPath + ".mmfilter";
                }
                FilterComposerDialog.this.fc.saveConditions(FilterComposerDialog.this.internalConditionsModel, canonicalPath);
            }
            catch (Exception ex) {
                this.handleSavingException(ex);
            }
        }

        private void handleSavingException(Exception ex) {
        }
    }

    private static class MindMapFilterFileFilter
    extends FileFilter {
        static FileFilter filter = new MindMapFilterFileFilter();

        private MindMapFilterFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Tools.getExtension(f.getName());
            if (extension != null) {
                return extension.equals("mmfilter");
            }
            return false;
        }

        @Override
        public String getDescription() {
            return Resources.getInstance().getResourceString("mindmaps_filter_desc");
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == FilterComposerDialog.this.btnOK || source == FilterComposerDialog.this.btnApply) {
                FilterComposerDialog.this.applyChanges();
            }
            if (source == FilterComposerDialog.this.btnOK || source == FilterComposerDialog.this.btnCancel) {
                FilterComposerDialog.this.dispose();
            } else {
                FilterComposerDialog.this.initInternalConditionModel();
            }
        }
    }

    private class ConditionListMouseListener
    extends MouseAdapter {
        private ConditionListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (FilterComposerDialog.this.selectCondition()) {
                            FilterComposerDialog.this.dispose();
                        }
                    }
                });
            }
        }
    }

    private class ConditionListSelectionListener
    implements ListSelectionListener,
    ListDataListener {
        private ConditionListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (FilterComposerDialog.this.conditionList.getMinSelectionIndex() == -1) {
                FilterComposerDialog.this.btnNot.setEnabled(false);
                FilterComposerDialog.this.btnAnd.setEnabled(false);
                FilterComposerDialog.this.btnOr.setEnabled(false);
                FilterComposerDialog.this.btnDelete.setEnabled(false);
                return;
            }
            if (FilterComposerDialog.this.conditionList.getMinSelectionIndex() == FilterComposerDialog.this.conditionList.getMaxSelectionIndex()) {
                FilterComposerDialog.this.btnNot.setEnabled(true);
                FilterComposerDialog.this.btnAnd.setEnabled(false);
                FilterComposerDialog.this.btnOr.setEnabled(false);
                FilterComposerDialog.this.btnDelete.setEnabled(true);
                return;
            }
            FilterComposerDialog.this.btnNot.setEnabled(false);
            FilterComposerDialog.this.btnAnd.setEnabled(true);
            FilterComposerDialog.this.btnOr.setEnabled(true);
            FilterComposerDialog.this.btnDelete.setEnabled(true);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            FilterComposerDialog.this.conditionList.setSelectedIndex(e.getIndex0());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }
    }

    private class CreateDisjunctConditionAction
    extends AbstractAction {
        CreateDisjunctConditionAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("filter_or"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues = FilterComposerDialog.this.conditionList.getSelectedValues();
            if (selectedValues.length < 2) {
                return;
            }
            DisjunctConditions newCond = new DisjunctConditions(selectedValues);
            DefaultComboBoxModel model = (DefaultComboBoxModel)FilterComposerDialog.this.conditionList.getModel();
            model.addElement(newCond);
            FilterComposerDialog.this.validate();
        }
    }

    private class CreateConjunctConditionAction
    extends AbstractAction {
        CreateConjunctConditionAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("filter_and"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues = FilterComposerDialog.this.conditionList.getSelectedValues();
            if (selectedValues.length < 2) {
                return;
            }
            ConjunctConditions newCond = new ConjunctConditions(selectedValues);
            DefaultComboBoxModel model = (DefaultComboBoxModel)FilterComposerDialog.this.conditionList.getModel();
            model.addElement(newCond);
            FilterComposerDialog.this.validate();
        }
    }

    private class CreateNotSatisfiedConditionAction
    extends AbstractAction {
        CreateNotSatisfiedConditionAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("filter_not"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int max;
            int min = FilterComposerDialog.this.conditionList.getMinSelectionIndex();
            if (min >= 0 && min == (max = FilterComposerDialog.this.conditionList.getMinSelectionIndex())) {
                Condition oldCond = (Condition)FilterComposerDialog.this.conditionList.getSelectedValue();
                ConditionNotSatisfiedDecorator newCond = new ConditionNotSatisfiedDecorator(oldCond);
                DefaultComboBoxModel model = (DefaultComboBoxModel)FilterComposerDialog.this.conditionList.getModel();
                model.addElement(newCond);
                FilterComposerDialog.this.validate();
            }
        }
    }

    private class DeleteConditionAction
    extends AbstractAction {
        DeleteConditionAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("filter_delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedIndex;
            DefaultComboBoxModel model = (DefaultComboBoxModel)FilterComposerDialog.this.conditionList.getModel();
            int minSelectionIndex = FilterComposerDialog.this.conditionList.getMinSelectionIndex();
            while (0 <= (selectedIndex = FilterComposerDialog.this.conditionList.getSelectedIndex())) {
                model.removeElementAt(selectedIndex);
            }
            int size = FilterComposerDialog.this.conditionList.getModel().getSize();
            if (size > 0) {
                FilterComposerDialog.this.conditionList.setSelectedIndex(minSelectionIndex < size ? minSelectionIndex : size - 1);
            }
            FilterComposerDialog.this.validate();
        }
    }

    private class AddConditionAction
    extends AbstractAction {
        AddConditionAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("filter_add"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object item;
            Condition newCond;
            Object attribute;
            String value;
            try {
                value = FilterComposerDialog.this.getAttributeValue();
            }
            catch (NullPointerException ex) {
                return;
            }
            NamedObject simpleCond = (NamedObject)FilterComposerDialog.this.simpleCondition.getSelectedItem();
            boolean ignoreCase = FilterComposerDialog.this.caseInsensitive.isSelected();
            Object selectedItem = FilterComposerDialog.this.attributes.getSelectedItem();
            if (selectedItem instanceof NamedObject) {
                attribute = (NamedObject)selectedItem;
                FilterComposerDialog.this.fc;
                newCond = FilterController.getConditionFactory().createCondition((NamedObject)attribute, simpleCond, value, ignoreCase);
            } else {
                attribute = selectedItem.toString();
                FilterComposerDialog.this.fc;
                newCond = FilterController.getConditionFactory().createAttributeCondition((String)attribute, simpleCond, value, ignoreCase);
            }
            DefaultComboBoxModel model = (DefaultComboBoxModel)FilterComposerDialog.this.conditionList.getModel();
            if (newCond != null) {
                model.addElement(newCond);
            }
            if (FilterComposerDialog.this.values.isEditable() && (item = FilterComposerDialog.this.values.getSelectedItem()) != null && !item.equals("")) {
                FilterComposerDialog.this.values.removeItem(item);
                FilterComposerDialog.this.values.insertItemAt(item, 0);
                FilterComposerDialog.this.values.setSelectedIndex(0);
                if (FilterComposerDialog.this.values.getItemCount() >= 10) {
                    FilterComposerDialog.this.values.removeItemAt(9);
                }
            }
            FilterComposerDialog.this.validate();
        }
    }
}

