/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.util.html;

import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.commons.lang.StringEscapeUtils;

public class ClickableImageCreator {
    Vector area = new Vector();
    private final MindMapNode root;
    private final ModeController modeController;
    private Rectangle innerBounds;
    private final String regExpLinkReplacement;
    private MapView mapView;

    public ClickableImageCreator(MindMapNode root, ModeController modeController, String regExpLinkReplacement) {
        this.root = root;
        this.regExpLinkReplacement = regExpLinkReplacement;
        this.mapView = modeController.getView();
        this.innerBounds = this.mapView != null ? this.mapView.getInnerBounds() : new Rectangle(0, 0, 100, 100);
        this.modeController = modeController;
        this.createArea();
    }

    public String generateHtml() {
        StringBuffer htmlArea = new StringBuffer();
        for (AreaHolder holder : this.area) {
            htmlArea.append("<area shape=\"" + holder.shape + "\" href=\"#" + holder.href.replaceFirst("^(.*)$", this.regExpLinkReplacement) + "\" alt=\"" + StringEscapeUtils.escapeHtml(holder.alt) + "\" title=\"" + StringEscapeUtils.escapeHtml(holder.title) + "\" coords=\"" + holder.coordinates.x + "," + holder.coordinates.y + "," + (holder.coordinates.width + holder.coordinates.x) + "," + (holder.coordinates.height + holder.coordinates.y) + "\" />");
        }
        return htmlArea.toString();
    }

    private void createArea() {
        this.createArea(this.root);
    }

    private void createArea(MindMapNode node) {
        NodeView nodeView = this.mapView.getNodeView(node);
        if (nodeView != null) {
            AreaHolder holder = new AreaHolder();
            holder.title = node.getShortText(this.modeController);
            holder.alt = node.getShortText(this.modeController);
            holder.href = node.getObjectId(this.modeController);
            Point contentXY = this.mapView.getNodeContentLocation(nodeView);
            JComponent content = nodeView.getContent();
            holder.coordinates.x = (int)((double)contentXY.x - this.innerBounds.getMinX());
            holder.coordinates.y = (int)((double)contentXY.y - this.innerBounds.getMinY());
            holder.coordinates.width = content.getWidth();
            holder.coordinates.height = content.getHeight();
            this.area.add(holder);
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                MindMapNode child = (MindMapNode)i.next();
                this.createArea(child);
            }
        }
    }

    public static class AreaHolder {
        String shape = "rect";
        String href;
        String alt;
        String title;
        Rectangle coordinates = new Rectangle();
    }
}

