/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.type1;

import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;

public class Type1Font {
    private AFM afm;
    private ILocator locator;

    public static Type1Font createFromLocator(ILocator locator) throws IOException {
        Type1Font result = new Type1Font();
        result.setLocator(locator);
        result.initializeFromLocator();
        return result;
    }

    public Type1Font() {
    }

    public Type1Font(AFM afm) {
        this.afm = afm;
    }

    public String getFontFamilyName() {
        return FontTools.getFontFamilyName(this.getFontName());
    }

    public synchronized AFM getFontMetrics() {
        return this.afm;
    }

    public String getFontName() {
        return this.afm.getFontName();
    }

    public FontStyle getFontStyle() {
        return FontTools.getFontStyle(this.getFontName());
    }

    public ILocator getLocator() {
        return this.locator;
    }

    protected void initializeAfm() throws IOException {
        ILocator parentLocator = this.getLocator().getParent();
        if (parentLocator == null) {
            return;
        }
        String localName = this.getLocator().getLocalName();
        ILocator afmLocator = parentLocator.getChild(String.valueOf(localName) + ".afm");
        this.afm = AFM.createFromLocator(afmLocator);
    }

    protected void initializeFromLocator() throws IOException {
        this.initializePfb();
        this.initializeAfm();
    }

    protected void initializePfb() {
    }

    public boolean isSymbolFont() {
        return false;
    }

    protected void setLocator(ILocator locator) {
        this.locator = locator;
    }
}

