/*
 * Decompiled with CFR 0.152.
 */
package atp;

import atp.ColorMaskFilter;
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;

class SymbolLoader {
    private ImageProducer[] imageSources = new ImageProducer[]{null, null, null, null, null};
    private String[] fontsizes = new String[]{"8", "10", "12", "14", "18"};
    private Hashtable fontdesH = new Hashtable(189);
    private static boolean kLocalFonts = true;

    public Image getImage(boolean appletB, boolean beanB, String filenameS, Graphics g, Applet app) {
        StringTokenizer st = new StringTokenizer(filenameS, "/");
        String fontsize = st.nextToken();
        fontsize = st.nextToken().substring(5);
        String fn = st.nextToken();
        int k = -1;
        boolean loop = true;
        while (loop) {
            if (this.fontsizes[++k].equals(fontsize)) {
                loop = false;
            }
            if (k != 4) continue;
            loop = false;
        }
        if (this.imageSources[k] == null) {
            this.imageSources[k] = this.getBigImage(appletB, beanB, "Fonts" + fontsize + ".gif", app);
            String desname = "Des" + fontsize + ".gif";
            BufferedInputStream istream = null;
            try {
                if (kLocalFonts) {
                    InputStream ip = this.getClass().getResourceAsStream(desname);
                    istream = new BufferedInputStream(this.getClass().getResourceAsStream(desname));
                } else if (!appletB & !beanB) {
                    istream = new BufferedInputStream(new URL(desname).openStream());
                } else if (appletB) {
                    istream = new BufferedInputStream(new URL(app.getCodeBase(), desname).openStream());
                } else {
                    try {
                        istream = new BufferedInputStream(this.getClass().getResource(desname).openStream());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                ObjectInputStream p = new ObjectInputStream(istream);
                int len = p.readInt();
                for (int i = 0; i < len; ++i) {
                    String ft = (String)p.readObject();
                    this.fontdesH.put(fontsize + ft, new Rectangle((Rectangle)p.readObject()));
                }
                istream.close();
            }
            catch (Exception exf) {
                System.out.println(exf.toString());
                this.imageSources[k] = null;
            }
        }
        Image image = null;
        if (this.imageSources[k] != null) {
            Rectangle r = (Rectangle)this.fontdesH.get(fontsize + fn);
            image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(new FilteredImageSource(this.imageSources[k], new CropImageFilter(r.x, r.y, r.width, r.height)), new ColorMaskFilter(g.getColor())));
        }
        return image;
    }

    public ImageProducer getBigImage(boolean appletB, boolean beanB, String filenameS, Applet app) {
        ImageProducer imageSource = null;
        if (kLocalFonts) {
            imageSource = this.getLocalImageSource(filenameS);
        }
        if (imageSource == null) {
            kLocalFonts = false;
            if (!appletB & !beanB) {
                imageSource = Toolkit.getDefaultToolkit().getImage(filenameS).getSource();
            } else if (appletB) {
                imageSource = app.getImage(app.getCodeBase(), filenameS).getSource();
            } else {
                try {
                    URL url = this.getClass().getResource(filenameS);
                    imageSource = (ImageProducer)url.getContent();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return imageSource;
    }

    ImageProducer getLocalImageSource(String resourceName) {
        ImageProducer source = null;
        try {
            InputStream imageStream = this.getClass().getResourceAsStream(resourceName);
            int numBytes = imageStream.available();
            byte[] imageBytes = new byte[numBytes];
            int alreadyRead = 0;
            int justRead = 0;
            while (justRead != -1) {
                int totalBytes;
                justRead = imageStream.read(imageBytes, alreadyRead, numBytes);
                if (justRead != -1 && (totalBytes = (alreadyRead += justRead) + (numBytes = imageStream.available())) > imageBytes.length) {
                    byte[] tempImageBytes = (byte[])imageBytes.clone();
                    imageBytes = new byte[totalBytes];
                    System.arraycopy(tempImageBytes, 0, imageBytes, 0, alreadyRead);
                }
                if (numBytes != 0) continue;
            }
            source = Toolkit.getDefaultToolkit().createImage(imageBytes).getSource();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return source;
    }
}

