/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.tree.ParseTree;
import org.antlr.tool.Grammar;
import org.antlr.tool.Interpreter;

public class Interp {
    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("java Interp file.g tokens-to-ignore start-rule input-file");
            return;
        }
        String grammarFileName = args[0];
        String ignoreTokens = args[1];
        String startRule = args[2];
        String inputFileName = args[3];
        Grammar parser = new Grammar(null, grammarFileName, new BufferedReader(new FileReader(grammarFileName)));
        String lexerGrammarText = parser.getLexerGrammar();
        Grammar lexer = new Grammar();
        lexer.importTokenVocabulary(parser);
        lexer.setGrammarContent(lexerGrammarText);
        ANTLRFileStream input = new ANTLRFileStream(inputFileName);
        Interpreter lexEngine = new Interpreter(lexer, input);
        CommonTokenStream tokens = new CommonTokenStream(lexEngine);
        StringTokenizer tk = new StringTokenizer(ignoreTokens, " ");
        while (tk.hasMoreTokens()) {
            String tokenName = tk.nextToken();
            tokens.setTokenTypeChannel(lexer.getTokenType(tokenName), 99);
        }
        if (parser.getRule(startRule) == null) {
            System.err.println("Rule " + startRule + " does not exist in " + grammarFileName);
            return;
        }
        Interpreter parseEngine = new Interpreter(parser, tokens);
        ParseTree t = parseEngine.parse(startRule);
        System.out.println(t.toStringTree());
    }
}

