/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.export.layout.format.XMLChars;
import net.sf.jabref.mods.PageNumbers;
import net.sf.jabref.mods.PersonName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MODSEntry {
    protected String entryType = "mods";
    protected String id;
    protected List<PersonName> authors = null;
    protected String issuance = "monographic";
    protected PageNumbers pages = null;
    protected String publisher = null;
    protected String date = null;
    protected String place = null;
    protected String title = null;
    protected String type = "text";
    protected String number;
    protected String volume;
    protected String genre = null;
    protected Set<String> handledExtensions;
    protected MODSEntry host;
    Map<String, String> extensionFields = new HashMap<String, String>();
    public static String BIBTEX = "bibtex_";
    private final boolean CHARFORMAT = false;

    public MODSEntry() {
        this.handledExtensions = new HashSet<String>();
    }

    public MODSEntry(BibtexEntry bibtex) {
        this();
        this.handledExtensions.add(BIBTEX + "publisher");
        this.handledExtensions.add(BIBTEX + "title");
        this.handledExtensions.add(BIBTEX + "bibtexkey");
        this.handledExtensions.add(BIBTEX + "author");
        this.populateFromBibtex(bibtex);
    }

    protected void populateFromBibtex(BibtexEntry bibtex) {
        XMLChars chars = new XMLChars();
        if (bibtex.getField("title") != null) {
            this.title = bibtex.getField("title").toString();
        }
        if (bibtex.getField("publisher") != null) {
            this.publisher = bibtex.getField("publisher").toString();
        }
        if (bibtex.getField("bibtexkey") != null) {
            this.id = bibtex.getField("bibtexkey").toString();
        }
        if (bibtex.getField("place") != null) {
            this.place = bibtex.getField("place").toString();
        }
        this.date = this.getDate(bibtex);
        this.genre = this.getMODSgenre(bibtex);
        if (bibtex.getField("author") != null) {
            this.authors = this.getAuthors(bibtex.getField("author").toString());
        }
        if (bibtex.getType() == BibtexEntryType.ARTICLE || bibtex.getType() == BibtexEntryType.INPROCEEDINGS) {
            this.host = new MODSEntry();
            this.host.entryType = "relatedItem";
            this.host.title = bibtex.getField("booktitle");
            this.host.publisher = bibtex.getField("publisher");
            this.host.number = bibtex.getField("number");
            if (bibtex.getField("pages") != null) {
                this.host.volume = bibtex.getField("volume");
            }
            this.host.issuance = "continuing";
            if (bibtex.getField("pages") != null) {
                this.host.pages = new PageNumbers(bibtex.getField("pages"));
            }
        }
        this.populateExtensionFields(bibtex);
    }

    protected void populateExtensionFields(BibtexEntry e) {
        for (String field : e.getAllFields()) {
            String value = e.getField(field);
            field = BIBTEX + field;
            this.extensionFields.put(field, value);
        }
    }

    protected List<PersonName> getAuthors(String authors) {
        LinkedList<PersonName> result = new LinkedList<PersonName>();
        XMLChars chars = new XMLChars();
        if (authors.indexOf(" and ") == -1) {
            result.add(new PersonName(authors));
        } else {
            String[] names = authors.split(" and ");
            for (int i = 0; i < names.length; ++i) {
                result.add(new PersonName(names[i]));
            }
        }
        return result;
    }

    protected String getDate(BibtexEntry bibtex) {
        String result = "";
        if (bibtex.getField("year") != null) {
            result = result + bibtex.getField("year").toString();
        }
        if (bibtex.getField("month") != null) {
            result = result + "-" + bibtex.getField("month").toString();
        }
        return result;
    }

    protected String getMODSgenre(BibtexEntry bibtex) {
        String bibtexType = bibtex.getType().getName();
        return bibtexType;
    }

    public Node getDOMrepresentation() {
        Element result = null;
        try {
            DocumentBuilder d = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            result = this.getDOMrepresentation(d.newDocument());
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    public Element getDOMrepresentation(Document d) {
        try {
            Element mods = d.createElement(this.entryType);
            mods.setAttribute("version", "3.0");
            if (this.title != null) {
                Element titleInfo = d.createElement("titleInfo");
                Element mainTitle = d.createElement("title");
                mainTitle.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.title)));
                titleInfo.appendChild(mainTitle);
                mods.appendChild(titleInfo);
            }
            if (this.authors != null) {
                for (PersonName name : this.authors) {
                    Element namePart;
                    Element modsName = d.createElement("name");
                    modsName.setAttribute("type", "personal");
                    if (name.getSurname() != null) {
                        namePart = d.createElement("namePart");
                        namePart.setAttribute("type", "family");
                        namePart.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(name.getSurname())));
                        modsName.appendChild(namePart);
                    }
                    if (name.getGivenNames() != null) {
                        namePart = d.createElement("namePart");
                        namePart.setAttribute("type", "given");
                        namePart.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(name.getGivenNames())));
                        modsName.appendChild(namePart);
                    }
                    Element role = d.createElement("role");
                    Element roleTerm = d.createElement("roleTerm");
                    roleTerm.setAttribute("type", "text");
                    roleTerm.appendChild(d.createTextNode("author"));
                    role.appendChild(roleTerm);
                    modsName.appendChild(role);
                    mods.appendChild(modsName);
                }
            }
            Element originInfo = d.createElement("originInfo");
            mods.appendChild(originInfo);
            if (this.publisher != null) {
                Element publisher = d.createElement("publisher");
                publisher.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.publisher)));
                originInfo.appendChild(publisher);
            }
            if (this.date != null) {
                Element dateIssued = d.createElement("dateIssued");
                dateIssued.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.date)));
                originInfo.appendChild(dateIssued);
            }
            Element issuance = d.createElement("issuance");
            issuance.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.issuance)));
            originInfo.appendChild(issuance);
            if (this.id != null) {
                Element idref = d.createElement("identifier");
                idref.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.id)));
                mods.appendChild(idref);
                mods.setAttribute("ID", this.id);
            }
            Element typeOfResource = d.createElement("typeOfResource");
            typeOfResource.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.type)));
            mods.appendChild(typeOfResource);
            if (this.genre != null) {
                Element genreElement = d.createElement("genre");
                genreElement.setAttribute("authority", "marc");
                genreElement.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(this.genre)));
                mods.appendChild(genreElement);
            }
            if (this.host != null) {
                Element relatedItem = this.host.getDOMrepresentation(d);
                relatedItem.setAttribute("type", "host");
                mods.appendChild(relatedItem);
            }
            if (this.pages != null) {
                mods.appendChild(this.pages.getDOMrepresentation(d));
            }
            for (Map.Entry<String, String> theEntry : this.extensionFields.entrySet()) {
                Element extension = d.createElement("extension");
                String field = theEntry.getKey();
                String value = theEntry.getValue();
                if (this.handledExtensions.contains(field)) continue;
                Element theData = d.createElement(field);
                theData.appendChild(d.createTextNode(this.stripNonValidXMLCharacters(value)));
                extension.appendChild(theData);
                mods.appendChild(extension);
            }
            return mods;
        }
        catch (Exception e) {
            System.out.println("Exception caught..." + e);
            e.printStackTrace();
            throw new Error(e);
        }
    }

    public String stripNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public String toString() {
        StringWriter sresult = new StringWriter();
        try {
            DOMSource source = new DOMSource(this.getDOMrepresentation());
            StreamResult result = new StreamResult(sresult);
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.transform(source, result);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return sresult.toString();
    }
}

