/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.labelPattern.LabelPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelPatternUtil {
    private static String CHARS = "abcdefghijklmnopqrstuvwxyz";
    public static ArrayList<String> DEFAULT_LABELPATTERN;
    private static BibtexDatabase _db;

    public static void updateDefaultPattern() {
        DEFAULT_LABELPATTERN = LabelPatternUtil.split(JabRefPreferences.getInstance().get("defaultLabelPattern"));
    }

    public static ArrayList<String> split(String labelPattern) {
        ArrayList<String> _alist = new ArrayList<String>();
        _alist.add(labelPattern);
        StringTokenizer tok = new StringTokenizer(labelPattern, "[]", true);
        while (tok.hasMoreTokens()) {
            _alist.add(tok.nextToken());
        }
        return _alist;
    }

    public static BibtexEntry makeLabel(LabelPattern table, BibtexDatabase database, BibtexEntry _entry) {
        _db = database;
        StringBuffer _sb = new StringBuffer();
        boolean forceUpper = false;
        boolean forceLower = false;
        try {
            String _type = _entry.getType().getName().toLowerCase();
            ArrayList<String> _al = table.getValue(_type);
            int _alSize = _al.size();
            boolean field = false;
            for (int i = 1; i < _alSize; ++i) {
                String val = _al.get(i).toString();
                if (val.equals("[")) {
                    field = true;
                    continue;
                }
                if (val.equals("]")) {
                    field = false;
                    continue;
                }
                if (field) {
                    String[] parts = LabelPatternUtil.parseFieldMarker(val);
                    String label = LabelPatternUtil.makeLabel(_entry, parts[0]);
                    if (parts.length > 1) {
                        label = LabelPatternUtil.applyModifiers(label, parts, 1);
                    }
                    _sb.append(label);
                    continue;
                }
                _sb.append(val);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        String _label = Util.checkLegalKey(_sb.toString());
        String regex = Globals.prefs.get("KeyPatternRegex");
        if (regex != null && regex.trim().length() > 0) {
            String replacement = Globals.prefs.get("KeyPatternReplacement");
            _label = _label.replaceAll(regex, replacement);
        }
        if (forceUpper) {
            _label = _label.toUpperCase();
        }
        if (forceLower) {
            _label = _label.toLowerCase();
        }
        String oldKey = _entry.getCiteKey();
        int occurences = _db.getNumberOfKeyOccurences(_label);
        if (oldKey != null && oldKey.equals(_label)) {
            --occurences;
        }
        if (occurences == 0) {
            if (!_label.equals(oldKey)) {
                _db.setCiteKeyForEntry(_entry.getId(), _label);
            }
        } else {
            int number = 0;
            String moddedKey = _label + LabelPatternUtil.getAddition(number);
            occurences = _db.getNumberOfKeyOccurences(moddedKey);
            if (oldKey != null && oldKey.equals(moddedKey)) {
                --occurences;
            }
            while (occurences > 0) {
                moddedKey = _label + LabelPatternUtil.getAddition(++number);
                occurences = _db.getNumberOfKeyOccurences(moddedKey);
                if (oldKey == null || !oldKey.equals(moddedKey)) continue;
                --occurences;
            }
            if (!moddedKey.equals(oldKey)) {
                _db.setCiteKeyForEntry(_entry.getId(), moddedKey);
            }
        }
        return _entry;
    }

    public static String applyModifiers(String label, String[] parts, int offset) {
        if (parts.length > offset) {
            for (int j = offset; j < parts.length; ++j) {
                String modifier = parts[j];
                if (modifier.equals("lower")) {
                    label = label.toLowerCase();
                    continue;
                }
                if (modifier.equals("upper")) {
                    label = label.toUpperCase();
                    continue;
                }
                if (modifier.equals("abbr")) {
                    StringBuffer abbr = new StringBuffer();
                    String[] words = label.toString().replaceAll("[\\{\\}']", "").split("[ \r\n\"]");
                    for (int word = 0; word < words.length; ++word) {
                        if (words[word].length() <= 0) continue;
                        abbr.append(words[word].charAt(0));
                    }
                    label = abbr.toString();
                    continue;
                }
                if (modifier.startsWith("(") && modifier.endsWith(")")) {
                    if (!label.equals("") || modifier.length() <= 2) continue;
                    return modifier.substring(1, modifier.length() - 1);
                }
                Globals.logger("Key generator warning: unknown modifier '" + modifier + "'.");
            }
        }
        return label;
    }

    public static String makeLabel(BibtexEntry _entry, String val) {
        try {
            if (val.startsWith("auth") || val.startsWith("pureauth")) {
                String authString = _entry.getField("author");
                if (val.startsWith("pure")) {
                    val = val.substring(4);
                } else if (authString == null || authString.equals("")) {
                    authString = _entry.getField("editor");
                }
                if (val.equals("auth")) {
                    return LabelPatternUtil.firstAuthor(authString);
                }
                if (val.equals("authors")) {
                    return LabelPatternUtil.allAuthors(authString);
                }
                if (val.equals("authorsAlpha")) {
                    return LabelPatternUtil.authorsAlpha(authString);
                }
                if (val.equals("authorLast")) {
                    return LabelPatternUtil.lastAuthor(authString);
                }
                if (val.equals("authorIni")) {
                    String s = LabelPatternUtil.oneAuthorPlusIni(authString);
                    return s == null ? "" : s;
                }
                if (val.matches("authIni[\\d]+")) {
                    int num = Integer.parseInt(val.substring(7));
                    String s = LabelPatternUtil.authIniN(authString, num);
                    return s == null ? "" : s;
                }
                if (val.equals("auth.auth.ea")) {
                    String s = LabelPatternUtil.authAuthEa(authString);
                    return s == null ? "" : s;
                }
                if (val.equals("auth.etal")) {
                    String s = LabelPatternUtil.authEtal(authString);
                    return s == null ? "" : s;
                }
                if (val.equals("authshort")) {
                    String s = LabelPatternUtil.authshort(authString);
                    return s == null ? "" : s;
                }
                if (val.matches("auth[\\d]+_[\\d]+")) {
                    String[] nums = val.substring(4).split("_");
                    String s = LabelPatternUtil.authN_M(authString, Integer.parseInt(nums[0]), Integer.parseInt(nums[1]) - 1);
                    return s == null ? "" : s;
                }
                if (val.matches("auth\\d+")) {
                    int num = Integer.parseInt(val.substring(4));
                    String fa = LabelPatternUtil.firstAuthor(authString);
                    if (fa == null) {
                        return "";
                    }
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                if (val.matches("authors\\d+")) {
                    String s = LabelPatternUtil.NAuthors(authString, Integer.parseInt(val.substring(7)));
                    return s == null ? "" : s;
                }
                return LabelPatternUtil.getField(_entry, val);
            }
            if (val.startsWith("ed")) {
                if (val.equals("edtr")) {
                    return LabelPatternUtil.firstAuthor(_entry.getField("editor").toString());
                }
                if (val.equals("editors")) {
                    return LabelPatternUtil.allAuthors(_entry.getField("editor").toString());
                }
                if (val.equals("editorLast")) {
                    return LabelPatternUtil.lastAuthor(_entry.getField("editor").toString());
                }
                if (val.equals("editorIni")) {
                    String s = LabelPatternUtil.oneAuthorPlusIni(_entry.getField("editor").toString());
                    return s == null ? "" : s;
                }
                if (val.matches("edtrIni[\\d]+")) {
                    int num = Integer.parseInt(val.substring(7));
                    String s = LabelPatternUtil.authIniN(_entry.getField("editor").toString(), num);
                    return s == null ? "" : s;
                }
                if (val.matches("edtr[\\d]+_[\\d]+")) {
                    String[] nums = val.substring(4).split("_");
                    String s = LabelPatternUtil.authN_M(_entry.getField("editor").toString(), Integer.parseInt(nums[0]), Integer.parseInt(nums[1]) - 1);
                    return s == null ? "" : s;
                }
                if (val.equals("edtr.edtr.ea")) {
                    String s = LabelPatternUtil.authAuthEa(_entry.getField("editor").toString());
                    return s == null ? "" : s;
                }
                if (val.equals("edtrshort")) {
                    String s = LabelPatternUtil.authshort(_entry.getField("editor").toString());
                    return s == null ? "" : s;
                }
                if (val.matches("edtr\\d+")) {
                    int num = Integer.parseInt(val.substring(4));
                    String fa = LabelPatternUtil.firstAuthor(_entry.getField("editor").toString());
                    if (fa == null) {
                        return "";
                    }
                    if (num > fa.length()) {
                        num = fa.length();
                    }
                    return fa.substring(0, num);
                }
                return LabelPatternUtil.getField(_entry, val);
            }
            if (val.equals("firstpage")) {
                return LabelPatternUtil.firstPage(_entry.getField("pages"));
            }
            if (val.equals("lastpage")) {
                return LabelPatternUtil.lastPage(_entry.getField("pages"));
            }
            if (val.equals("shorttitle")) {
                return LabelPatternUtil.keepLettersAndDigitsOnly(LabelPatternUtil.getTitleWords(3, _entry));
            }
            if (val.equals("shortyear")) {
                String ss = _entry.getField("year");
                if (ss.startsWith("in") || ss.startsWith("sub")) {
                    return "IP";
                }
                if (ss.length() > 2) {
                    return ss.substring(ss.length() - 2);
                }
                return ss;
            }
            if (val.equals("veryshorttitle")) {
                return LabelPatternUtil.keepLettersAndDigitsOnly(LabelPatternUtil.getTitleWords(1, _entry));
            }
            if (val.matches("keyword\\d+")) {
                StringBuilder sb = new StringBuilder();
                int num = Integer.parseInt(val.substring(7));
                String kw = LabelPatternUtil.getField(_entry, "keywords");
                if (kw != null) {
                    String[] keywords = kw.split("[,;]\\s*");
                    if (num > 0 && num < keywords.length) {
                        sb.append(keywords[num - 1].trim());
                    }
                }
                return sb.toString();
            }
            return LabelPatternUtil.getField(_entry, val);
        }
        catch (NullPointerException ex) {
            return "";
        }
    }

    private static String getField(BibtexEntry entry, String field) {
        String o = entry.getField(field);
        return o != null ? o : "";
    }

    private static String getAddition(int number) {
        if (number >= CHARS.length()) {
            int lastChar = number % CHARS.length();
            return LabelPatternUtil.getAddition(number / CHARS.length() - 1) + CHARS.substring(lastChar, lastChar + 1);
        }
        return CHARS.substring(number, number + 1);
    }

    static String getTitleWords(int number, BibtexEntry _entry) {
        String ss = new RemoveLatexCommands().format(_entry.getField("title").toString());
        StringBuffer _sbvalue = new StringBuffer();
        int piv = 0;
        int words = 0;
        block0: while (piv < ss.length() && words < number) {
            StringBuffer current = new StringBuffer();
            while (piv < ss.length() && !Character.isWhitespace(ss.charAt(piv)) && ss.charAt(piv) != '-') {
                current.append(ss.charAt(piv));
                ++piv;
            }
            ++piv;
            String word = current.toString().trim();
            if (word.length() == 0) continue;
            for (int _i = 0; _i < Globals.SKIP_WORDS.length; ++_i) {
                if (word.equalsIgnoreCase(Globals.SKIP_WORDS[_i])) continue block0;
            }
            if (_sbvalue.length() > 0) {
                _sbvalue.append(" ");
            }
            _sbvalue.append(word);
            ++words;
        }
        return _sbvalue.toString();
    }

    static String keepLettersAndDigitsOnly(String in) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            if (!Character.isLetterOrDigit(in.charAt(i))) continue;
            sb.append(in.charAt(i));
        }
        return sb.toString();
    }

    public static boolean isLabelUnique(String label) {
        boolean _isUnique = true;
        int _dbSize = _db.getEntryCount();
        for (int i = 0; i < _dbSize; ++i) {
            BibtexEntry _entry = _db.getEntryById(String.valueOf(i));
            if (!_entry.getField("bibtexkey").equals(label)) continue;
            _isUnique = false;
            break;
        }
        return _isUnique;
    }

    public static String firstAuthor(String authorField) {
        AuthorList al = AuthorList.getAuthorList(authorField);
        if (al.size() == 0) {
            return "";
        }
        String s = al.getAuthor(0).getLast();
        return s != null ? s : "";
    }

    public static String firstAuthorVonAndLast(String authorField) {
        AuthorList al = AuthorList.getAuthorList(authorField);
        if (al.size() == 0) {
            return "";
        }
        String s = al.getAuthor(0).getVon();
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            sb.append(s);
            sb.append(' ');
        }
        if ((s = al.getAuthor(0).getLast()) != null) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static String lastAuthor(String authorField) {
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\band\\b");
        if (tokens.length > 0) {
            String[] lastAuthor = tokens[tokens.length - 1].replaceAll("\\s+", " ").trim().split(" ");
            return lastAuthor[0];
        }
        return "";
    }

    private static String allAuthors(String authorField) {
        String author = "";
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\band\\b");
        for (int i = 0; tokens.length > i; ++i) {
            String[] firstAuthor = tokens[i].replaceAll("\\s+", " ").trim().split(" ");
            author = author + firstAuthor[0];
        }
        return author;
    }

    private static String authorsAlpha(String authorField) {
        int max;
        String authors = "";
        String fixedAuthors = AuthorList.fixAuthor_lastNameOnlyCommas(authorField, false);
        String[] tokens = (fixedAuthors = fixedAuthors.replace(" and ", ", ")).split(",");
        int n = max = tokens.length > 4 ? 3 : tokens.length;
        if (max == 1) {
            String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").trim().split(" ");
            for (int j = 0; j < firstAuthor.length - 1; ++j) {
                authors = authors.concat(firstAuthor[j].substring(0, 1));
            }
            authors = authors.concat(firstAuthor[firstAuthor.length - 1].substring(0, Math.min(3, firstAuthor[firstAuthor.length - 1].length())));
        } else {
            for (int i = 0; i < max; ++i) {
                String[] curAuthor = tokens[i].replaceAll("\\s+", " ").trim().split(" ");
                for (int j = 0; j < curAuthor.length; ++j) {
                    authors = authors.concat(curAuthor[j].substring(0, 1));
                }
            }
            if (tokens.length > 4) {
                authors = authors.concat("+");
            }
        }
        return authors;
    }

    private static String NAuthors(String authorField, int n) {
        String author = "";
        String[] tokens = AuthorList.fixAuthorForAlphabetization(authorField).split("\\band\\b");
        for (int i = 0; tokens.length > i && i < n; ++i) {
            String[] firstAuthor = tokens[i].replaceAll("\\s+", " ").trim().split(" ");
            author = author + firstAuthor[0];
        }
        if (tokens.length <= n) {
            return author;
        }
        author = author + "EtAl";
        return author;
    }

    private static String oneAuthorPlusIni(String authorField) {
        int CHARS_OF_FIRST = 5;
        authorField = AuthorList.fixAuthorForAlphabetization(authorField);
        String author = "";
        String[] tokens = authorField.split("\\band\\b");
        if (tokens.length == 0) {
            return author;
        }
        String[] firstAuthor = tokens[0].replaceAll("\\s+", " ").split(" ");
        author = firstAuthor[0].substring(0, Math.min(5, firstAuthor[0].length()));
        for (int i = 1; tokens.length > i; ++i) {
            author = author + tokens[i].trim().charAt(0);
        }
        return author;
    }

    private static String authAuthEa(String authorField) {
        authorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuffer author = new StringBuffer();
        String[] tokens = authorField.split("\\band\\b");
        if (tokens.length == 0) {
            return "";
        }
        author.append(tokens[0].split(",")[0]);
        if (tokens.length >= 2) {
            author.append(".").append(tokens[1].split(",")[0]);
        }
        if (tokens.length > 2) {
            author.append(".ea");
        }
        return author.toString();
    }

    private static String authEtal(String authorField) {
        authorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuffer author = new StringBuffer();
        String[] tokens = authorField.split("\\band\\b");
        if (tokens.length == 0) {
            return "";
        }
        author.append(tokens[0].split(",")[0]);
        if (tokens.length == 2) {
            author.append(".").append(tokens[1].split(",")[0]);
        } else if (tokens.length > 2) {
            author.append(".etal");
        }
        return author.toString();
    }

    private static String authN_M(String authorField, int n, int m) {
        String[] tokens = (authorField = AuthorList.fixAuthorForAlphabetization(authorField)).split("\\band\\b");
        if (tokens.length <= m || n < 0 || m < 0) {
            return "";
        }
        String lastName = tokens[m].split(",")[0].trim();
        if (lastName.length() <= n) {
            return lastName;
        }
        return lastName.substring(0, n);
    }

    private static String authshort(String authorField) {
        authorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuffer author = new StringBuffer();
        String[] tokens = authorField.split("\\band\\b");
        if (tokens.length == 1) {
            author.append(LabelPatternUtil.authN_M(authorField, authorField.length(), 0));
        } else if (tokens.length >= 2) {
            for (int i = 0; tokens.length > i && i < 3; ++i) {
                author.append(LabelPatternUtil.authN_M(authorField, 1, i));
            }
            if (tokens.length > 3) {
                author.append("+");
            }
        }
        return author.toString();
    }

    public static String authIniN(String authorField, int n) {
        if (n <= 0) {
            return "";
        }
        authorField = AuthorList.fixAuthorForAlphabetization(authorField);
        StringBuffer author = new StringBuffer();
        String[] tokens = authorField.split("\\band\\b");
        int charsAll = n / tokens.length;
        if (tokens.length == 0) {
            return author.toString();
        }
        for (int i = 0; tokens.length > i; ++i) {
            if (i < n % tokens.length) {
                author.append(LabelPatternUtil.authN_M(authorField, charsAll + 1, i));
                continue;
            }
            author.append(LabelPatternUtil.authN_M(authorField, charsAll, i));
        }
        if (author.length() <= n) {
            return author.toString();
        }
        return author.toString().substring(0, n);
    }

    public static String firstPage(String pages) {
        String[] _pages = pages.split("\\D+");
        int result = Integer.MAX_VALUE;
        for (String n : _pages) {
            if (!n.matches("\\d+")) continue;
            result = Math.min(Integer.parseInt(n), result);
        }
        if (result == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(result);
    }

    public static String lastPage(String pages) {
        String[] _pages = pages.split("\\D+");
        int result = Integer.MIN_VALUE;
        for (String n : _pages) {
            if (!n.matches("\\d+")) continue;
            result = Math.max(Integer.parseInt(n), result);
        }
        if (result == Integer.MIN_VALUE) {
            return "";
        }
        return String.valueOf(result);
    }

    public static String[] parseFieldMarker(String arg) {
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean escaped = false;
        int inParenthesis = 0;
        for (int i = 0; i < arg.length(); ++i) {
            if (arg.charAt(i) == ':' && !escaped && inParenthesis == 0) {
                parts.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (arg.charAt(i) == '(' && !escaped) {
                ++inParenthesis;
                current.append(arg.charAt(i));
                continue;
            }
            if (arg.charAt(i) == ')' && !escaped && inParenthesis > 0) {
                --inParenthesis;
                current.append(arg.charAt(i));
                continue;
            }
            if (arg.charAt(i) == '\\') {
                if (escaped) {
                    escaped = false;
                    current.append(arg.charAt(i));
                    continue;
                }
                escaped = true;
                continue;
            }
            if (escaped) {
                current.append(arg.charAt(i));
                escaped = false;
                continue;
            }
            current.append(arg.charAt(i));
        }
        parts.add(current.toString());
        return parts.toArray(new String[parts.size()]);
    }

    static {
        LabelPatternUtil.updateDefaultPattern();
    }
}

