/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.sf.jabref.autocompleter.AbstractAutoCompleter;

public class AutoCompleteListener
extends KeyAdapter
implements FocusListener {
    AbstractAutoCompleter completer;
    protected String toSetIn = null;
    protected String lastBeginning = null;
    protected int lastCaretPosition = -1;
    protected Object[] lastCompletions = null;
    protected int lastShownCompletion = 0;
    protected FocusListener nextFocusListener = null;
    static final int ANY_NAME = 0;
    static final int FIRST_NAME = 1;
    static final int LAST_NAME = 2;

    public AutoCompleteListener(AbstractAutoCompleter completer) {
        this.completer = completer;
    }

    public void setNextFocusListener(FocusListener listener) {
        this.nextFocusListener = listener;
    }

    public void keyPressed(KeyEvent e) {
        if (this.toSetIn != null && e.getKeyCode() == 10) {
            JTextComponent comp = (JTextComponent)e.getSource();
            int end = comp.getSelectionEnd();
            comp.select(end, end);
            e.consume();
            return;
        }
        if (e.getKeyCode() == 34 && this.lastCompletions != null) {
            this.cycle((JTextComponent)e.getSource(), 1);
            e.consume();
        } else if (e.getKeyCode() == 33 && this.lastCompletions != null) {
            this.cycle((JTextComponent)e.getSource(), -1);
            e.consume();
        }
    }

    private void cycle(JTextComponent comp, int increment) {
        this.lastShownCompletion += increment;
        if (this.lastShownCompletion >= this.lastCompletions.length) {
            this.lastShownCompletion = 0;
        } else if (this.lastShownCompletion < 0) {
            this.lastShownCompletion = this.lastCompletions.length - 1;
        }
        String sno = (String)this.lastCompletions[this.lastShownCompletion];
        this.toSetIn = sno.substring(this.lastBeginning.length() - 1);
        StringBuffer alltext = new StringBuffer(comp.getText());
        int deletedChars = comp.getSelectionEnd() - comp.getSelectionStart();
        alltext.delete(comp.getSelectionStart(), comp.getSelectionEnd());
        int cp = comp.getCaretPosition() - deletedChars;
        alltext.insert(cp, this.toSetIn.substring(1));
        comp.setText(alltext.toString());
        comp.setCaretPosition(cp + this.toSetIn.length() - 1);
        comp.select(cp, cp + sno.length() - this.lastBeginning.length());
        this.lastCaretPosition = comp.getCaretPosition();
    }

    public void keyTyped(KeyEvent e) {
        char ch = e.getKeyChar();
        if (Character.isLetter(ch)) {
            JTextComponent comp = (JTextComponent)e.getSource();
            if (this.toSetIn != null && this.toSetIn.length() > 1 && ch == this.toSetIn.charAt(1)) {
                this.toSetIn = this.toSetIn.substring(1);
                if (this.toSetIn.length() > 0) {
                    int cp = comp.getCaretPosition();
                    comp.select(cp + 1 - this.toSetIn.length(), cp);
                    this.lastBeginning = this.lastBeginning + ch;
                    e.consume();
                    this.lastCaretPosition = comp.getCaretPosition();
                    this.lastCompletions = this.findCompletions(this.lastBeginning, comp);
                    this.lastShownCompletion = 0;
                    for (int i = 0; i < this.lastCompletions.length; ++i) {
                        Object lastCompletion = this.lastCompletions[i];
                        if (!((String)lastCompletion).endsWith(this.toSetIn)) continue;
                        this.lastShownCompletion = i;
                        break;
                    }
                    if (this.toSetIn.length() < 2) {
                        this.toSetIn = null;
                    }
                    return;
                }
            }
            if (this.toSetIn != null && (this.toSetIn.length() <= 1 || ch != this.toSetIn.charAt(1))) {
                this.lastBeginning = this.lastBeginning + ch;
                Object[] completed = this.findCompletions(this.lastBeginning, comp);
                if (completed != null && completed.length > 0) {
                    this.lastShownCompletion = 0;
                    this.lastCompletions = completed;
                    String sno = (String)completed[0];
                    int lastLen = this.toSetIn.length() - 1;
                    this.toSetIn = sno.substring(this.lastBeginning.length() - 1);
                    String text = comp.getText();
                    comp.setText(text.substring(0, this.lastCaretPosition - lastLen) + this.toSetIn + text.substring(this.lastCaretPosition));
                    comp.select(this.lastCaretPosition + 1 - lastLen, this.lastCaretPosition + this.toSetIn.length() - lastLen);
                    this.lastCaretPosition = comp.getCaretPosition();
                    e.consume();
                    return;
                }
                this.toSetIn = null;
                return;
            }
            StringBuffer currentword = this.getCurrentWord(comp);
            if (currentword == null) {
                return;
            }
            currentword.append(ch);
            Object[] completed = this.findCompletions(currentword.toString(), comp);
            int no = 0;
            if (completed != null && completed.length > 0) {
                this.lastShownCompletion = 0;
                this.lastCompletions = completed;
                String sno = (String)completed[no];
                this.toSetIn = sno.substring(currentword.length() - 1);
                StringBuffer alltext = new StringBuffer(comp.getText());
                int cp = comp.getCaretPosition();
                alltext.insert(cp, this.toSetIn);
                comp.setText(alltext.toString());
                comp.setCaretPosition(cp);
                comp.select(cp + 1, cp + 1 + sno.length() - currentword.length());
                e.consume();
                this.lastCaretPosition = comp.getCaretPosition();
                this.lastBeginning = currentword.toString();
                return;
            }
        }
        this.toSetIn = null;
        this.lastCompletions = null;
    }

    protected Object[] findCompletions(String beginning, JTextComponent comp) {
        return this.completer.complete(beginning);
    }

    protected StringBuffer getCurrentWord(JTextComponent comp) {
        StringBuffer res = new StringBuffer();
        try {
            String upToCaret = comp.getText(0, comp.getCaretPosition());
            if (!this.completer.isSingleUnitField()) {
                if (comp.getCaretPosition() < comp.getText().length() && !Character.isWhitespace(comp.getText().charAt(comp.getCaretPosition()))) {
                    return null;
                }
                boolean found = false;
                int piv = upToCaret.length() - 1;
                while (!found && piv >= 0) {
                    if (Character.isWhitespace(upToCaret.charAt(piv))) {
                        found = true;
                        continue;
                    }
                    --piv;
                }
                res.append(upToCaret.substring(piv + 1));
            } else {
                res.append(upToCaret);
            }
        }
        catch (BadLocationException ex) {
            // empty catch block
        }
        return res;
    }

    protected int findNamePositionStatus(JTextComponent comp) {
        try {
            String upToCaret = comp.getText(0, comp.getCaretPosition());
            upToCaret = upToCaret.substring(upToCaret.lastIndexOf(" and ") + 1);
            int commaIndex = upToCaret.indexOf(44);
            if (commaIndex < 0) {
                return 0;
            }
            return 1;
        }
        catch (BadLocationException ex) {
            return 0;
        }
    }

    public void focusGained(FocusEvent event) {
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusGained(event);
        }
    }

    public void focusLost(FocusEvent event) {
        if (this.lastCompletions != null) {
            JTextComponent comp = (JTextComponent)event.getSource();
            this.clearCurrentSuggestion(comp);
        }
        if (this.nextFocusListener != null) {
            this.nextFocusListener.focusLost(event);
        }
    }

    public void clearCurrentSuggestion(JTextComponent comp) {
        if (this.lastCompletions != null) {
            int selStart = comp.getSelectionStart();
            String text = comp.getText();
            comp.setText(text.substring(0, selStart) + text.substring(comp.getSelectionEnd()));
            comp.setCaretPosition(selStart);
            this.lastCompletions = null;
            this.lastShownCompletion = 0;
            this.lastCaretPosition = -1;
            this.toSetIn = null;
        }
    }
}

