/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;

public class DuplicateCheck {
    public static boolean isDuplicate(BibtexEntry one, BibtexEntry two) {
        float req;
        if (one.getType() != two.getType()) {
            return false;
        }
        String[] fields = one.getType().getRequiredFields();
        float reqWeight = 2.0f;
        if (fields == null) {
            req = 0.0f;
            reqWeight = 0.0f;
        } else {
            req = DuplicateCheck.compareFieldSet(fields, one, two);
        }
        fields = one.getType().getOptionalFields();
        if (fields != null) {
            float opt = DuplicateCheck.compareFieldSet(fields, one, two);
            return (reqWeight * req + opt) / (1.0f + reqWeight) >= Globals.duplicateThreshold;
        }
        return req >= Globals.duplicateThreshold;
    }

    private static float compareFieldSet(String[] fields, BibtexEntry one, BibtexEntry two) {
        int res = 0;
        int empty = 0;
        for (int i = 0; i < fields.length; ++i) {
            int result = DuplicateCheck.compareSingleField(fields[i], one, two);
            if (result == 1) {
                ++res;
                continue;
            }
            if (result != 4) continue;
            ++empty;
        }
        if (fields.length > empty) {
            return (float)res / (float)(fields.length - empty);
        }
        return 0.5f;
    }

    private static int compareSingleField(String field, BibtexEntry one, BibtexEntry two) {
        String s1 = one.getField(field);
        String s2 = two.getField(field);
        if (s1 == null) {
            if (s2 == null) {
                return 4;
            }
            return 2;
        }
        if (s2 == null) {
            return 3;
        }
        s1 = s1.toLowerCase();
        s2 = s2.toLowerCase();
        if (field.equals("author") || field.equals("editor")) {
            String[] aus1 = AuthorList.fixAuthor_lastNameFirst(s1).split(" and ");
            String[] aus2 = AuthorList.fixAuthor_lastNameFirst(s2).split(" and ");
            String[] au1 = aus1[0].split(",");
            String[] au2 = aus2[0].split(",");
            if (aus1.length > 0 && aus1.length == aus2.length && au1[0].trim().equals(au2[0].trim())) {
                return 1;
            }
            return 0;
        }
        if (s1.trim().equals(s2.trim())) {
            return 1;
        }
        return 0;
    }

    public static double compareEntriesStrictly(BibtexEntry one, BibtexEntry two) {
        HashSet<String> allFields = new HashSet<String>();
        allFields.addAll(one.getAllFields());
        allFields.addAll(two.getAllFields());
        int score = 0;
        for (String field : allFields) {
            String en = one.getField(field);
            String to = two.getField(field);
            if (en != null && to != null && en.equals(to)) {
                ++score;
                continue;
            }
            if (en != null || to != null) continue;
            ++score;
        }
        if (score == allFields.size()) {
            return 1.01;
        }
        return (double)score / (double)allFields.size();
    }

    public static BibtexEntry containsDuplicate(BibtexDatabase database, BibtexEntry entry) {
        for (BibtexEntry other : database.getEntries()) {
            if (!DuplicateCheck.isDuplicate(entry, other)) continue;
            return other;
        }
        return null;
    }
}

