/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.MethodInvocationException;

public class Predicates {
    public static final IMethodHandler FALSE = new IMethodHandler(){

        public Object invoke(Object receiver, IArgs args) throws MethodInvocationException {
            return false;
        }
    };
    public static final IMethodHandler TRUE = new IMethodHandler(){

        public Object invoke(Object receiver, IArgs args) throws MethodInvocationException {
            return true;
        }
    };

    public static IMethodHandler and(IMethodHandler ... op) {
        if (op == null || op.length == 0) {
            return FALSE;
        }
        if (op.length == 1) {
            return op[0];
        }
        return new And(op);
    }

    public static IMethodHandler or(IMethodHandler ... op) {
        if (op == null || op.length == 0) {
            return TRUE;
        }
        if (op.length == 1) {
            return op[0];
        }
        return new Or(op);
    }

    public static class And
    implements IMethodHandler {
        private final IMethodHandler[] operators;

        public And(IMethodHandler[] operators) {
            this.operators = operators;
        }

        public Object invoke(Object receiver, IArgs args) throws MethodInvocationException {
            IMethodHandler[] iMethodHandlerArray = this.operators;
            int n = this.operators.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodHandler handler = iMethodHandlerArray[n2];
                if (handler.invoke(receiver, args) != Boolean.TRUE) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public static class Or
    implements IMethodHandler {
        private final IMethodHandler[] operators;

        public Or(IMethodHandler[] operators) {
            this.operators = operators;
        }

        public Object invoke(Object receiver, IArgs args) throws MethodInvocationException {
            IMethodHandler[] iMethodHandlerArray = this.operators;
            int n = this.operators.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodHandler handler = iMethodHandlerArray[n2];
                if (handler.invoke(receiver, args) == Boolean.TRUE) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

