/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reflect;

import de.intarsys.tools.component.IInitializeable;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import de.intarsys.tools.reflect.IBasicInvocationSupport;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.MethodInvocationException;
import de.intarsys.tools.reflect.MethodNotFoundException;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTools {
    private static final Object[] EMPTY_PARAMETERS = new Object[0];
    private static final Class[] EMPTY_PARAMETERTYPES = new Class[0];
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";

    protected static Object basicGet(Object object, String name) throws FieldException {
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicGetValue(name);
        }
        try {
            Method method = ObjectTools.findGetter(object, name);
            return method.invoke(object, null);
        }
        catch (Exception method) {
            try {
                Field field = object.getClass().getField(name);
                return field.get(object);
            }
            catch (Exception field) {
                try {
                    Method method2 = object.getClass().getMethod(name, null);
                    return method2.invoke(object, null);
                }
                catch (Exception e) {
                    throw new FieldAccessException(name, e);
                }
            }
        }
    }

    protected static Object basicInsert(Object object, String name, Object value) throws FieldException {
        try {
            Method method = ObjectTools.findInserter(object, name, value);
            return method.invoke(object, value);
        }
        catch (Exception method) {
            Object tempValue = ObjectTools.get(object, name);
            if (tempValue instanceof Collection) {
                if (((Collection)tempValue).add(value)) {
                    return value;
                }
                return null;
            }
            throw new IllegalAccessError("can't insert in " + name);
        }
    }

    protected static Object basicInvoke(Object object, String name, Object ... values) throws MethodException {
        if (object instanceof IBasicInvocationSupport) {
            return ((IBasicInvocationSupport)object).basicInvoke(name, values);
        }
        Method method = ObjectTools.findMethod(object, name, values);
        try {
            return method.invoke(object, values);
        }
        catch (Exception e) {
            throw new MethodInvocationException(name, e);
        }
    }

    protected static Object basicRemove(Object object, String name, Object value) throws FieldException {
        try {
            Method method = ObjectTools.findRemover(object, name, value);
            return method.invoke(object, value);
        }
        catch (Exception method) {
            Object tempValue = ObjectTools.get(object, name);
            if (tempValue instanceof Collection) {
                if (((Collection)tempValue).remove(value)) {
                    return value;
                }
                return null;
            }
            throw new IllegalAccessError("can't remove from " + name);
        }
    }

    protected static Object basicSet(Object object, String name, Object value) throws FieldException {
        if (object instanceof IBasicAccessSupport) {
            return ((IBasicAccessSupport)object).basicSetValue(name, value);
        }
        try {
            Method method = ObjectTools.findSetter(object, name, value);
            return method.invoke(object, value);
        }
        catch (InvocationTargetException e) {
            throw new FieldAccessException(name, e.getCause());
        }
        catch (Exception e) {
            try {
                Field field = object.getClass().getField(name);
                Object oldValue = field.get(object);
                field.set(object, value);
                return oldValue;
            }
            catch (Exception e2) {
                throw new FieldAccessException(name, e2);
            }
        }
    }

    protected static boolean checkCandidate(Method method, String methodName, Class[] pClasses) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        Class[] mClasses = method.getParameterTypes();
        return ObjectTools.checkCandidateClasses(mClasses, pClasses);
    }

    protected static boolean checkCandidateClass(Class mClass, Class pClass) {
        return mClass.isAssignableFrom(pClass);
    }

    protected static boolean checkCandidateClasses(Class[] mClasses, Class[] pClasses) {
        if (mClasses.length != pClasses.length) {
            return false;
        }
        int i = 0;
        while (i < mClasses.length) {
            if (!ObjectTools.checkCandidateClass(mClasses[i], pClasses[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> T createObject(Class clazz, Class<T> expectedClass) throws ObjectCreationException {
        return ObjectTools.createObject(clazz, expectedClass, EMPTY_PARAMETERTYPES, EMPTY_PARAMETERS);
    }

    public static <T> T createObject(Class clazz, Class<T> expectedClass, Class[] parameterTypes, Object[] parameters) throws ObjectCreationException {
        if (clazz == null) {
            throw new ObjectCreationException("class missing");
        }
        try {
            Object object;
            if (expectedClass != null && !expectedClass.isAssignableFrom(clazz)) {
                throw new ObjectCreationException("class '" + clazz.getName() + "' not compatible with expected type '" + expectedClass + "'");
            }
            if (parameters == EMPTY_PARAMETERS) {
                object = clazz.newInstance();
            } else {
                Constructor constructor = clazz.getConstructor(parameterTypes);
                object = constructor.newInstance(parameters);
            }
            if (object instanceof IInitializeable) {
                ((IInitializeable)object).initialize();
            }
            return object;
        }
        catch (NoClassDefFoundError e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (InstantiationException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (IllegalAccessException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (SecurityException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (NoSuchMethodException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (IllegalArgumentException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (InvocationTargetException e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
        catch (Exception e) {
            throw new ObjectCreationException("class '" + clazz.getName() + "' can't be instantiated", e);
        }
    }

    public static <T> T createObject(String className, Class<T> expectedClass, ClassLoader classLoader) throws ObjectCreationException {
        Class<T> clazz = ClassTools.createClass(className, expectedClass, classLoader);
        return ObjectTools.createObject(clazz, expectedClass);
    }

    protected static Method findAnyMethod(Class clazz, String name, Class ... classes) throws MethodException {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (method.getName().equals(name)) {
                boolean found = true;
                Class<?>[] parameterTypes = method.getParameterTypes();
                int j = 0;
                while (j < parameterTypes.length) {
                    Class<?> parameterType = parameterTypes[j];
                    if (!parameterType.isAssignableFrom(classes[j])) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    return method;
                }
            }
            ++i;
        }
        throw new MethodNotFoundException(name);
    }

    public static Method findGetter(Object object, String name) throws MethodException {
        try {
            String methodName = GET_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            return object.getClass().getMethod(methodName, null);
        }
        catch (Exception methodName) {
            String methodName2 = IS_PREFIX + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            try {
                return object.getClass().getMethod(methodName2, null);
            }
            catch (Exception e) {
                throw new MethodNotFoundException(name);
            }
        }
    }

    public static Method findInserter(Object object, String attribute, Object value) throws MethodException {
        String methodName = "insert" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(object, methodName, value);
    }

    protected static Method findMatchingMethod(Class clazz, String name, Class[] classes) throws MethodException {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if (ObjectTools.checkCandidate(method, name, classes)) {
                return method;
            }
            ++i;
        }
        try {
            return clazz.getMethod(name, classes);
        }
        catch (Exception e) {
            throw new MethodNotFoundException(name);
        }
    }

    public static Method findMethod(Object object, String methodName, Object ... parameters) throws MethodException {
        Class<?> clazz = object.getClass();
        Class[] parameterClasses = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            parameterClasses[i] = parameters[i].getClass();
            ++i;
        }
        Method method = null;
        try {
            method = ObjectTools.findSimpleMethod(clazz, methodName, parameterClasses);
        }
        catch (Exception e) {
            method = ObjectTools.findAnyMethod(clazz, methodName, parameterClasses);
        }
        return method;
    }

    public static Method findRemover(Object object, String attribute, Object value) throws MethodException {
        String methodName = "remove" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(object, methodName, value);
    }

    public static Method findSetter(Object object, String attribute, Object value) throws MethodException {
        String methodName = "set" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
        return ObjectTools.findMethod(object, methodName, value);
    }

    protected static Method findSimpleMethod(Class clazz, String name, Class ... classes) throws MethodException {
        try {
            return clazz.getMethod(name, classes);
        }
        catch (Exception e) {
            throw new MethodNotFoundException(name);
        }
    }

    public static Object get(Object object, String name) throws FieldException {
        int pos;
        String tempExpr = name.replace('[', '.');
        if (tempExpr != name) {
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicGet(object, name);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.get(result, pathTrail);
    }

    public static Object insert(Object object, String name, Object value) throws FieldException {
        int pos;
        String tempExpr = name.replace('[', '.');
        if (tempExpr != name) {
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicInsert(object, name, value);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.insert(result, pathTrail, value);
    }

    public static Object invoke(Object object, String name, Object ... values) throws MethodException {
        Object result;
        int pos;
        String tempExpr = name.replace('[', '.');
        if (tempExpr != name) {
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicInvoke(object, name, values);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        try {
            result = ObjectTools.basicGet(object, pathPrefix);
        }
        catch (FieldException e) {
            throw new MethodInvocationException(name, e);
        }
        return ObjectTools.invoke(result, pathTrail, values);
    }

    public static Object remove(Object object, String name, Object value) throws FieldException {
        int pos;
        String tempExpr = name.replace('[', '.');
        if (tempExpr != name) {
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicRemove(object, name, value);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.remove(result, pathTrail, value);
    }

    public static Object set(Object object, String name, Object value) throws FieldException {
        int pos;
        String tempExpr = name.replace('[', '.');
        if (tempExpr != name) {
            tempExpr = tempExpr.replace(']', ' ');
        }
        if ((pos = tempExpr.indexOf(46)) == -1) {
            return ObjectTools.basicSet(object, name, value);
        }
        String pathPrefix = tempExpr.substring(0, pos);
        String pathTrail = tempExpr.substring(pos + 1);
        Object result = ObjectTools.basicGet(object, pathPrefix);
        return ObjectTools.set(result, pathTrail, value);
    }
}

