/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.hex;

import de.intarsys.tools.hex.HexData;
import de.intarsys.tools.hex.HexTools;

public class HexRow {
    public static int DEFAULT_LENGTH = 16;
    private HexData hexData;
    private int length = DEFAULT_LENGTH;
    private int offset;

    protected HexRow(HexData hexData, int offset, int length) {
        this.hexData = hexData;
        this.offset = offset;
        this.length = length;
    }

    public String getAsString() {
        return new String(this.hexData.basicGetBytes(), this.offset, Math.min(this.length, this.hexData.length() - this.offset));
    }

    public byte getCellValue(int column) {
        int index = this.offset + column;
        if (index >= this.hexData.length()) {
            return 0;
        }
        return this.hexData.basicGetValue(this.offset + column);
    }

    public String getCellValueAsString(int column) {
        int index = this.offset + column;
        if (index >= this.hexData.length()) {
            return "  ";
        }
        return new String(HexTools.ByteToHex[0xFF & this.hexData.basicGetValue(this.offset + column)]);
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setCellValue(int column, byte value) {
        this.hexData.basicSetValue(this.offset + column, value);
    }

    public void setCellValue(int column, String value) {
        this.hexData.basicSetValue(this.offset + column, (byte)HexTools.hexStringToInt(value));
    }

    public void setLength(int width) {
        this.length = width;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

