/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.EmptyArgs;
import de.intarsys.tools.functor.IArgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Args
implements IArgs {
    public static final IArgs EMPTY = new EmptyArgs();
    private Map valueMap;
    private List valueList;

    public static Args create() {
        return new Args();
    }

    public static Args createIndexed() {
        ArrayList list = new ArrayList();
        return new Args(list);
    }

    public static Args createIndexed(Object p1) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(p1);
        return new Args(list);
    }

    public static Args createIndexed(Object p1, Object p2) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(p1);
        list.add(p2);
        return new Args(list);
    }

    public static Args createIndexed(Object p1, Object p2, Object p3) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(p1);
        list.add(p2);
        list.add(p3);
        return new Args(list);
    }

    public static Args createNamed() {
        HashMap map = new HashMap();
        return new Args(map);
    }

    public static Args createNamed(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        return new Args(map);
    }

    public static Args createNamed(String key1, Object value1, String key2, Object value2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key1, value1);
        map.put(key2, value2);
        return new Args(map);
    }

    public Args() {
    }

    public Args(IArgs args) {
        if (args == null) {
            return;
        }
        if (args.isIndexed()) {
            this.valueList = new ArrayList();
            int i = 0;
            while (i < args.size()) {
                this.valueList.add(args.get(i));
                ++i;
            }
        }
        if (args.isNamed()) {
            this.valueMap = new HashMap();
            for (String name : args.names()) {
                this.valueMap.put(name, args.get(name));
            }
        }
    }

    public Args(List values) {
        this.valueList = values;
    }

    public Args(Map values) {
        this.valueMap = values;
    }

    public Args(Object[] values) {
        if (values != null) {
            this.valueList = Arrays.asList(values);
        }
    }

    public void add(Object object) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(object);
    }

    public void clear() {
        if (this.valueList != null) {
            this.valueList.clear();
        }
        if (this.valueMap != null) {
            this.valueMap.clear();
        }
    }

    public IArgs declare(String name, int index, Object value) {
        this.put(index, value);
        this.put(name, value);
        return this;
    }

    public Object get(int index) {
        if (this.valueList == null || index < 0 || this.valueList.size() <= index) {
            return null;
        }
        return this.valueList.get(index);
    }

    public Object get(int index, Object defaultValue) {
        if (this.valueList == null || index < 0 || this.valueList.size() <= index) {
            return defaultValue;
        }
        return this.valueList.get(index);
    }

    public Object get(String name) {
        if (this.valueMap == null) {
            return null;
        }
        return this.valueMap.get(name);
    }

    public Object get(String name, Object defaultValue) {
        if (this.valueMap == null) {
            return defaultValue;
        }
        Object result = this.valueMap.get(name);
        if (result == null && !this.valueMap.containsKey(name)) {
            return defaultValue;
        }
        return result;
    }

    public boolean isDefined(int index) {
        if (this.valueList == null) {
            return false;
        }
        return index >= 0 && index < this.valueList.size();
    }

    public boolean isDefined(String name) {
        if (this.valueMap == null) {
            return false;
        }
        return this.valueMap.containsKey(name);
    }

    public boolean isIndexed() {
        return this.valueList != null;
    }

    public boolean isNamed() {
        return this.valueMap != null;
    }

    public Set names() {
        if (this.valueMap == null) {
            return Collections.EMPTY_SET;
        }
        return this.valueMap.keySet();
    }

    public void put(int index, Object value) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        while (index >= this.valueList.size()) {
            this.valueList.add(null);
        }
        this.valueList.set(index, value);
    }

    public void put(String name, Object value) {
        if (this.valueMap == null) {
            this.valueMap = new HashMap();
        }
        this.valueMap.put(name, value);
    }

    public int size() {
        if (this.valueList != null) {
            return this.valueList.size();
        }
        if (this.valueMap != null) {
            return this.valueMap.size();
        }
        return 0;
    }

    public String toString() {
        return ArgTools.toString(this, "");
    }
}

