/*
 * Decompiled with CFR 0.152.
 */
package bibtex.parser;

import java.io.IOException;
import java.io.Reader;

final class LookAheadReader {
    private final int BUFFERLEN = 512;
    private final Reader input;
    private boolean eof;
    private int line;
    private int column;
    private char[] buffer;
    private int bufferFilledUntil;
    private int bufferPos;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("bibtex.parser.LookAheadReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public LookAheadReader(Reader input) throws IOException {
        this.input = input;
        this.bufferPos = -1;
        this.bufferFilledUntil = 0;
        this.buffer = new char[512];
        this.eof = false;
        this.line = 1;
        this.column = 0;
        this.step();
    }

    public void step() throws IOException {
        char currentChar;
        if (this.eof) {
            return;
        }
        ++this.bufferPos;
        if (this.bufferFilledUntil <= this.bufferPos) {
            this.bufferFilledUntil = this.input.read(this.buffer);
            if (this.bufferFilledUntil == -1) {
                this.eof = true;
                this.input.close();
            }
            this.bufferPos = 0;
        }
        if ((currentChar = this.buffer[this.bufferPos]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
    }

    public char getCurrent() {
        if (!$assertionsDisabled && this.eof) {
            throw new AssertionError();
        }
        return this.buffer[this.bufferPos];
    }

    public boolean eof() {
        return this.eof;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

