/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.environment;

import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IGraphicsObject;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.common.ShapeWrapper;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsEnvironment;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import de.intarsys.tools.geometry.ShapeTools;
import de.intarsys.tools.geometry.TransformedShape;
import de.intarsys.tools.resourcetracker.ResourceTracker;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class CwtSwtGraphicsContext
implements IGraphicsContext {
    static final int BACKGROUND = 2;
    static final int FOREGROUND = 1;
    private static ResourceTracker tracker = new ResourceTracker(){

        protected void basicDispose(Object object) {
            ((Path)object).dispose();
        }
    };
    private boolean applyTransform = false;
    private java.awt.Color backgroundColor = null;
    private Pattern backgroundPattern;
    private BlendMode blendMode = (BlendMode)BlendMode.META.getDefault();
    private AffineTransform cachedAWTShapeTransform;
    private Transform cachedSWTShapeTransform;
    private TransformedShape currentClip;
    private AffineTransform currentTransform;
    private Device device;
    private Shape deviceClip;
    private float[] elements = new float[6];
    private double[] flatmatrix = new double[6];
    private org.eclipse.swt.graphics.Font font;
    private Transform fontTransform;
    private java.awt.Color foregroundColor;
    private Pattern foregroundPattern;
    private GC gc;
    private boolean setAlphaBackground;
    private boolean setAlphaForeground;
    private int swtBackgroundAlpha = 255;
    private Color swtBackgroundColor = null;
    private int swtForegroundAlpha;
    private Color swtForegroundColor;
    private Transform swtTransform;

    public static Path toPath(Device device, PathIterator pathIterator) {
        Path path = new Path(device);
        if (pathIterator.isDone()) {
            path.addRectangle(0.0f, 0.0f, 0.0f, 0.0f);
            return path;
        }
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 4: {
                    path.close();
                    break;
                }
                case 3: {
                    path.cubicTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 1: {
                    path.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 0: {
                    path.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    path.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                default: {
                    throw new InternalError("Program execution should not reach this point.");
                }
            }
            pathIterator.next();
        }
        return path;
    }

    public static Rectangle2D toRectangle2D(Rectangle rectangle) {
        return new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static Transform toTransform(Device device, AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return new Transform(device, (float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
    }

    public static Transform toTransform(Device device, Transform transform, AffineTransform affineTransform) {
        if (transform == null) {
            return new Transform(device, (float)affineTransform.getScaleX(), (float)affineTransform.getShearX(), (float)affineTransform.getShearY(), (float)affineTransform.getScaleY(), (float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY());
        }
        transform.setElements((float)affineTransform.getScaleX(), (float)affineTransform.getShearX(), (float)affineTransform.getShearY(), (float)affineTransform.getScaleY(), (float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY());
        return transform;
    }

    public CwtSwtGraphicsContext(GC gC, Device device) {
        this.device = device;
        this.font = null;
        this.swtForegroundAlpha = 255;
        this.swtForegroundColor = null;
        this.foregroundColor = null;
        this.gc = gC;
        this.setAlphaForeground = false;
        this.setAlphaBackground = false;
        this.swtTransform = new Transform(device);
        gC.getTransform(this.swtTransform);
        this.swtTransform.getElements(this.elements);
        this.currentTransform = new AffineTransform(this.elements);
        Rectangle2D rectangle2D = CwtSwtGraphicsContext.toRectangle2D(gC.getClipping());
        this.currentClip = ApplySpaceChangeShape.create((Shape)rectangle2D, (AffineTransform)this.currentTransform);
        gC.setAntialias(0);
        gC.setInterpolation(0);
    }

    protected void applyTransform() {
        if (this.applyTransform) {
            this.applyTransform = false;
            this.currentTransform.getMatrix(this.flatmatrix);
            this.swtTransform.setElements((float)this.flatmatrix[0], (float)this.flatmatrix[1], (float)this.flatmatrix[2], (float)this.flatmatrix[3], (float)this.flatmatrix[4], (float)this.flatmatrix[5]);
            this.gc.setTransform(this.swtTransform);
        }
    }

    public void clip(Shape shape) {
        if (this.currentClip != null) {
            Area area = new Area(shape);
            Area area2 = new Area((Shape)this.currentClip);
            area2.intersect(area);
            shape = new ShapeWrapper(area2);
        }
        this.setClip(shape);
    }

    protected Path createPath(Shape shape) {
        Path path;
        if (shape instanceof IGraphicsObject && (path = (Path)((IGraphicsObject)((Object)shape)).getData()) != null) {
            return path;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            path = new Path(this.device);
            path.addRectangle((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        } else {
            path = CwtSwtGraphicsContext.toPath(this.device, shape.getPathIterator(null));
        }
        tracker.trackPhantom((Object)shape, (Object)path);
        if (shape instanceof IGraphicsObject) {
            ((IGraphicsObject)((Object)shape)).setData(path);
        }
        return path;
    }

    public void dispose() {
        this.applyTransform();
        if (this.swtBackgroundColor != null) {
            this.swtBackgroundColor.dispose();
        }
        if (this.backgroundPattern != null) {
            this.backgroundPattern.dispose();
        }
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.fontTransform != null) {
            this.fontTransform.dispose();
        }
        if (this.swtForegroundColor != null) {
            this.swtForegroundColor.dispose();
        }
        if (this.foregroundPattern != null) {
            this.foregroundPattern.dispose();
        }
        if (this.swtTransform != null) {
            this.swtTransform.dispose();
        }
        if (this.cachedSWTShapeTransform != null) {
            this.cachedSWTShapeTransform.dispose();
        }
    }

    public void draw(Shape shape) {
        if (this.setAlphaForeground) {
            this.setAlphaForeground = false;
            if (this.gc.getAlpha() != this.swtForegroundAlpha) {
                this.gc.setAlpha(this.swtForegroundAlpha);
                if (this.swtBackgroundAlpha != this.swtForegroundAlpha) {
                    this.setAlphaBackground = true;
                }
            }
        }
        if (shape instanceof TransformedShape && this.gc.getForegroundPattern() == null) {
            Shape shape2;
            AffineTransform affineTransform = ((TransformedShape)shape).getTransform();
            if (affineTransform != null) {
                if (affineTransform != this.cachedAWTShapeTransform) {
                    this.cachedAWTShapeTransform = affineTransform;
                    if (this.cachedSWTShapeTransform != null) {
                        this.cachedSWTShapeTransform.dispose();
                    }
                    this.cachedSWTShapeTransform = CwtSwtGraphicsContext.toTransform(this.device, affineTransform);
                }
                shape2 = new Transform(this.device);
                this.currentTransform.getMatrix(this.flatmatrix);
                shape2.setElements((float)this.flatmatrix[0], (float)this.flatmatrix[1], (float)this.flatmatrix[2], (float)this.flatmatrix[3], (float)this.flatmatrix[4], (float)this.flatmatrix[5]);
                shape2.multiply(this.cachedSWTShapeTransform);
                this.gc.setTransform((Transform)shape2);
            } else {
                this.applyTransform();
            }
            shape2 = ((TransformedShape)shape).getBaseShape();
            this.gc.drawPath(this.createPath(shape2));
            this.gc.setTransform(this.swtTransform);
        } else {
            this.applyTransform();
            this.gc.drawPath(this.createPath(shape));
        }
    }

    public void drawImage(IImage iImage, float f, float f2) {
        this.applyTransform();
        iImage.drawFromGraphicsContext(this, f, f2);
    }

    public void drawString(String string, float f, float f2) {
        this.applyTransform();
        if (this.setAlphaForeground) {
            this.setAlphaForeground = false;
            if (this.gc.getAlpha() != this.swtForegroundAlpha) {
                this.gc.setAlpha(this.swtForegroundAlpha);
                if (this.swtBackgroundAlpha != this.swtForegroundAlpha) {
                    this.setAlphaBackground = true;
                }
            }
        }
        boolean bl = false;
        if (this.fontTransform != null) {
            if (this.swtTransform == null) {
                this.swtTransform = new Transform(this.device);
            }
            this.gc.getTransform(this.swtTransform);
            this.swtTransform.getElements(this.elements);
            this.swtTransform.translate(f, f2);
            float[] fArray = new float[]{0.0f, 0 - this.gc.textExtent((String)string).y};
            this.fontTransform.transform(fArray);
            this.swtTransform.translate(fArray[0], fArray[1]);
            this.swtTransform.multiply(this.fontTransform);
            this.gc.setTransform(this.swtTransform);
            bl = true;
        }
        try {
            this.gc.drawString(string, 0, 0);
        }
        finally {
            if (bl) {
                this.swtTransform.setElements(this.elements[0], this.elements[1], this.elements[2], this.elements[3], this.elements[4], this.elements[5]);
                this.gc.setTransform(this.swtTransform);
            }
        }
    }

    public void fill(Shape shape) {
        if (this.setAlphaBackground) {
            this.setAlphaBackground = false;
            if (this.gc.getAlpha() != this.swtBackgroundAlpha) {
                this.gc.setAlpha(this.swtBackgroundAlpha);
                if (this.swtForegroundAlpha != this.swtBackgroundAlpha) {
                    this.setAlphaForeground = true;
                }
            }
        }
        if (shape instanceof TransformedShape && this.gc.getBackgroundPattern() == null) {
            Shape shape2;
            AffineTransform affineTransform = ((TransformedShape)shape).getTransform();
            if (affineTransform != null) {
                if (affineTransform != this.cachedAWTShapeTransform) {
                    this.cachedAWTShapeTransform = affineTransform;
                    if (this.cachedSWTShapeTransform != null) {
                        this.cachedSWTShapeTransform.dispose();
                    }
                    this.cachedSWTShapeTransform = CwtSwtGraphicsContext.toTransform(this.device, affineTransform);
                }
                shape2 = new Transform(this.device);
                this.currentTransform.getMatrix(this.flatmatrix);
                shape2.setElements((float)this.flatmatrix[0], (float)this.flatmatrix[1], (float)this.flatmatrix[2], (float)this.flatmatrix[3], (float)this.flatmatrix[4], (float)this.flatmatrix[5]);
                shape2.multiply(this.cachedSWTShapeTransform);
                this.gc.setTransform((Transform)shape2);
            } else {
                this.applyTransform();
            }
            shape2 = ((TransformedShape)shape).getBaseShape();
            if (ShapeTools.getWindingRule((Shape)shape2) == 0) {
                this.gc.setFillRule(1);
            } else {
                this.gc.setFillRule(2);
            }
            Path path = this.createPath(shape2);
            this.gc.fillPath(path);
            this.gc.setTransform(this.swtTransform);
        } else {
            this.applyTransform();
            PathIterator pathIterator = shape.getPathIterator(null);
            if (pathIterator.getWindingRule() == 0) {
                this.gc.setFillRule(1);
            } else {
                this.gc.setFillRule(2);
            }
            Path path = this.createPath(shape);
            this.gc.fillPath(path);
        }
    }

    public java.awt.Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            RGB rGB = this.swtBackgroundColor.getRGB();
            this.backgroundColor = new java.awt.Color(rGB.red, rGB.green, rGB.blue);
        }
        return this.backgroundColor;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    public Shape getClip() {
        return (Shape)this.currentClip.clone();
    }

    public Device getDevice() {
        return this.device;
    }

    public Font getFont() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public java.awt.Color getForegroundColor() {
        if (this.foregroundColor == null) {
            RGB rGB = this.swtForegroundColor.getRGB();
            this.foregroundColor = new java.awt.Color(rGB.red, rGB.green, rGB.blue);
        }
        return this.foregroundColor;
    }

    public GC getGc() {
        return this.gc;
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtSwtGraphicsEnvironment.get();
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(null);
        int n = this.gc.getAntialias();
        if (n == -1) {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if (n == 0) {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        n = this.gc.getInterpolation();
        if (n == 2) {
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        n = this.gc.getTextAntialias();
        if (n == -1) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        } else if (n == 0) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return renderingHints;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.currentTransform.clone();
    }

    protected float[] getTransformationValues(AffineTransform affineTransform) {
        affineTransform.getMatrix(this.flatmatrix);
        this.elements[0] = (float)this.flatmatrix[0];
        this.elements[1] = (float)this.flatmatrix[1];
        this.elements[2] = (float)this.flatmatrix[2];
        this.elements[3] = (float)this.flatmatrix[3];
        this.elements[4] = (float)this.flatmatrix[4];
        this.elements[5] = (float)this.flatmatrix[5];
        return this.elements;
    }

    public void resetAdvanced() {
        this.gc.setAdvanced(false);
    }

    public void rotate(float f) {
        this.currentTransform.rotate(f);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }

    public void scale(float f, float f2) {
        this.currentTransform.scale(f, f2);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }

    public void setBackgroundColor(java.awt.Color color) {
        this.backgroundColor = color;
        this.swtBackgroundAlpha = color.getAlpha();
        this.setAlphaBackground = true;
        Color color2 = new Color(this.device, color.getRed(), color.getGreen(), color.getBlue());
        this.setBackgroundColor(color2);
    }

    public void setBackgroundColor(Color color) {
        if (this.swtBackgroundColor != null) {
            this.swtBackgroundColor.dispose();
        }
        this.swtBackgroundColor = color;
        this.backgroundColor = null;
        this.gc.setBackground(this.swtBackgroundColor);
    }

    public void setBackgroundPaint(IPaint iPaint) {
        this.swtBackgroundAlpha = (int)(iPaint.getAlphaValue() * 255.0f);
        this.setAlphaBackground = true;
        iPaint.setBackgroundPaintFromGraphicsContext(this);
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.backgroundPattern != null) {
            this.backgroundPattern.dispose();
        }
        this.backgroundPattern = pattern;
        this.gc.setBackgroundPattern(this.backgroundPattern);
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    public void setClip(Shape shape) {
        if (shape == null) {
            this.currentClip = null;
            this.gc.setClipping(null);
            return;
        }
        this.currentClip = ApplySpaceChangeShape.create((Shape)shape, (AffineTransform)this.currentTransform);
        this.applyTransform();
        Path path = this.createPath(shape);
        if (ShapeTools.getWindingRule((Shape)shape) == 0) {
            this.gc.setFillRule(1);
        } else {
            this.gc.setFillRule(2);
        }
        this.gc.setClipping(path);
    }

    public void setFont(Font font) {
        AffineTransform affineTransform;
        if (this.font != null) {
            this.font.dispose();
        }
        int n = 0;
        if ((font.getStyle() & 1) > 0) {
            n |= 1;
        }
        if ((font.getStyle() & 2) > 0) {
            n |= 2;
        }
        if (this.fontTransform != null) {
            this.fontTransform.dispose();
        }
        this.fontTransform = (affineTransform = font.getTransform()).isIdentity() ? null : new Transform(this.device, this.getTransformationValues(affineTransform));
        this.font = new org.eclipse.swt.graphics.Font(this.device, font.getFontName(), font.getSize(), n);
        this.gc.setFont(this.font);
    }

    public void setForegroundColor(java.awt.Color color) {
        this.foregroundColor = color;
        this.swtForegroundAlpha = color.getAlpha();
        this.setAlphaForeground = true;
        Color color2 = new Color(this.device, color.getRed(), color.getGreen(), color.getBlue());
        this.setForegroundColor(color2);
    }

    public void setForegroundColor(Color color) {
        if (this.swtForegroundColor != null) {
            this.swtForegroundColor.dispose();
        }
        this.swtForegroundColor = color;
        this.foregroundColor = null;
        this.gc.setForeground(this.swtForegroundColor);
    }

    public void setForegroundPaint(IPaint iPaint) {
        this.swtForegroundAlpha = (int)(iPaint.getAlphaValue() * 255.0f);
        this.setAlphaForeground = true;
        iPaint.setForegroundPaintFromGraphicsContext(this);
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.foregroundPattern != null) {
            this.foregroundPattern.dispose();
        }
        this.foregroundPattern = pattern;
        this.gc.setForegroundPattern(this.foregroundPattern);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == RenderingHints.KEY_ALPHA_INTERPOLATION) {
            return;
        }
        if (key == RenderingHints.KEY_ANTIALIASING) {
            if (object == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
                this.gc.setAntialias(-1);
            } else if (object == RenderingHints.VALUE_ANTIALIAS_OFF) {
                this.gc.setAntialias(0);
            } else {
                this.gc.setAntialias(1);
            }
            return;
        }
        if (key == RenderingHints.KEY_COLOR_RENDERING) {
            return;
        }
        if (key == RenderingHints.KEY_DITHERING) {
            return;
        }
        if (key == RenderingHints.KEY_FRACTIONALMETRICS) {
            return;
        }
        if (key == RenderingHints.KEY_INTERPOLATION) {
            if (object == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.gc.setInterpolation(2);
            } else if (object == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                this.gc.setInterpolation(2);
            } else {
                this.gc.setInterpolation(1);
            }
            return;
        }
        if (key == RenderingHints.KEY_RENDERING) {
            return;
        }
        if (key == RenderingHints.KEY_STROKE_CONTROL) {
            return;
        }
        if (key == RenderingHints.KEY_TEXT_ANTIALIASING) {
            if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                this.gc.setTextAntialias(-1);
            } else if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                this.gc.setTextAntialias(0);
            } else {
                this.gc.setTextAntialias(1);
            }
        }
    }

    public void setRenderingHints(Map map) {
        map.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION);
        if (map.containsKey(RenderingHints.KEY_ANTIALIASING)) {
            if (map.get(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
                this.gc.setAntialias(-1);
            } else if (map.get(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_OFF) {
                this.gc.setAntialias(0);
            } else {
                this.gc.setAntialias(1);
            }
        } else {
            this.gc.setAntialias(-1);
        }
        map.containsKey(RenderingHints.KEY_COLOR_RENDERING);
        map.containsKey(RenderingHints.KEY_DITHERING);
        map.containsKey(RenderingHints.KEY_FRACTIONALMETRICS);
        if (map.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (map.get(RenderingHints.KEY_INTERPOLATION) == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.gc.setInterpolation(2);
            } else if (map.get(RenderingHints.KEY_INTERPOLATION) == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                this.gc.setInterpolation(2);
            } else {
                this.gc.setInterpolation(1);
            }
        } else {
            this.gc.setInterpolation(0);
        }
        map.containsKey(RenderingHints.KEY_RENDERING);
        map.containsKey(RenderingHints.KEY_STROKE_CONTROL);
        if (map.containsKey(RenderingHints.KEY_TEXT_ANTIALIASING)) {
            if (map.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                this.gc.setTextAntialias(-1);
            } else if (map.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                this.gc.setTextAntialias(0);
            } else {
                this.gc.setTextAntialias(1);
            }
        } else {
            this.gc.setTextAntialias(-1);
        }
    }

    public void setStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            LineAttributes lineAttributes = new LineAttributes(basicStroke.getLineWidth());
            float[] fArray = basicStroke.getDashArray();
            if (fArray == null) {
                lineAttributes.style = 1;
            } else {
                int n = 0;
                while (n < fArray.length) {
                    if (fArray[n] <= 0.0f) {
                        fArray[n] = 1.0f;
                    }
                    ++n;
                }
                lineAttributes.style = 6;
                lineAttributes.dash = fArray;
            }
            int n = basicStroke.getEndCap();
            lineAttributes.cap = n == 0 ? 1 : (n == 1 ? 2 : 3);
            n = basicStroke.getLineJoin();
            lineAttributes.join = n == 2 ? 3 : (n == 0 ? 1 : 2);
            this.gc.setLineAttributes(lineAttributes);
            this.gc.setLineCap(lineAttributes.cap);
            return;
        }
    }

    public void setTransform(AffineTransform affineTransform) {
        this.currentTransform = (AffineTransform)affineTransform.clone();
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip = ApplySpaceChangeShape.setTransform((Shape)this.currentClip, (AffineTransform)this.currentTransform);
        }
    }

    public java.awt.Point textExtent(String string) {
        Point point = this.gc.textExtent(string);
        return new java.awt.Point(point.x, point.y);
    }

    public void transform(AffineTransform affineTransform) {
        this.currentTransform.concatenate(affineTransform);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }

    public void translate(float f, float f2) {
        this.currentTransform.translate(f, f2);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }
}

