/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.PdfFileFilter;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;
import splmm.Thread.EventSenderThread;

public class UpdateMonitoringDirAction
extends AbstractMonitoringAction {
    private MindMapNode selected;

    public UpdateMonitoringDirAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_update"), controller);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = this.controller.getSelected();
        this.updateMonitoringNode();
    }

    public void performAction(MindMapNode node) {
        this.selected = node;
        this.updateMonitoringNode();
    }

    private void updateMonitoringNode() {
        this.directory = new File(this.selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_PATH));
        if (!this.directory.exists()) {
            JOptionPane.showMessageDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("splmm_monitoringDir_dirNotFound"));
            this.RemoveMonitoringAtrributes(this.selected);
        }
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
        this.ExecuteMyTask(new MyTask());
        this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
        this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        List<File> monDirFiles;
        List<MindMapNode> monDirFilesLinkedNodes;
        List<BibTex> bibTexList;
        MindMapNode node;
        MindMapNode equalNode;
        PdfFileFilter pdfFilter = new PdfFileFilter();

        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            this.newFileCounter = 0;
            this.name = "update";
            this.bibTexList = BookmarkMindMapNode.ReadBibtexFile();
            this.monDirFilesLinkedNodes = this.getNodesLinkedToMonDirFiles(UpdateMonitoringDirAction.this.controller.getRootNode());
            boolean importSubfolder = UpdateMonitoringDirAction.this.isImportSubfolder(UpdateMonitoringDirAction.this.selected);
            this.monDirFiles = this.getMonDirFilesFromDir(UpdateMonitoringDirAction.this.directory, importSubfolder);
            block0: for (final File monDirFile : this.monDirFiles) {
                final List<MindMapNode> equalNodes = UpdateMonitoringDirAction.this.GetFileLinkedNodesFromList(this.monDirFilesLinkedNodes, monDirFile);
                if (equalNodes.size() == 0) {
                    ++this.newFileCounter;
                    this.node = this.pdfFilter.accept(monDirFile) ? this.ImportBookmarksFromFile(monDirFile, this.bibTexList) : new BookmarkMindMapNode(monDirFile.getPath(), monDirFile.getName(), UpdateMonitoringDirAction.this.controller.getController());
                    if (this.node == null) continue;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            UpdateMonitoringDirAction.this.controller.paste(MyTask.this.node, UpdateMonitoringDirAction.this.selected);
                            UpdateMonitoringDirAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                        }
                    });
                    continue;
                }
                this.firePropertyChange("watchFolder", "", LocalizationSupport.message("importing.bookmarks.from.file") + this.cutStringForOutput(monDirFile.getName(), 36));
                Date monDirFileLastModified = new Date(monDirFile.lastModified());
                for (MindMapNode node : equalNodes) {
                    SplmmAttributes splmmAttributes = node.getSPLMMAttributes();
                    if (splmmAttributes != null && !splmmAttributes.getBookmarksUpdated().before(monDirFileLastModified) || !this.pdfFilter.accept(monDirFile)) continue;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            UpdateMonitoringDirAction.this.importBookmarks(equalNodes, monDirFile, UpdateMonitoringDirAction.this.selected);
                        }
                    });
                    continue block0;
                }
            }
            new EventSenderThread(SciPloreUtils.EVENT_READ_MON_DIR, "" + this.newFileCounter);
            return null;
        }
    }
}

