/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import splmm.Actions.AbstractMonitoringAction;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.PdfFileFilter;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.SplmmAttributes;
import splmm.Thread.EventSenderThread;

public class EditMonitoringDirAction
extends AbstractMonitoringAction {
    private MindMapNode selected;
    private String oldDirectory;
    private ArrayList<MindMapNode> nodesFromOldDirectory;

    public EditMonitoringDirAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_monitoringDir_edit"), controller);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.selected = this.controller.getSelected();
        this.oldDirectory = this.selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_PATH);
        int result = this.ShowFileChooser(new File(this.oldDirectory));
        if (result == 0) {
            if (this.directory != null) {
                new EventSenderThread(SciPloreUtils.EVENT_EDIT_MON_DIR, this.directory.getPath());
            } else {
                new EventSenderThread(SciPloreUtils.EVENT_EDIT_MON_DIR, "");
            }
            this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_importBookmarks"));
            this.selected.getAttributes().setValue(this.selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_PATH), this.directory);
            this.ExecuteMyTask(new MyTask());
            int deleteQuestion = JOptionPane.showConfirmDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("splmm_monitoringDir_deleteNodes"), "", 0);
            if (deleteQuestion == 0) {
                for (MindMapNode node : this.nodesFromOldDirectory) {
                    this.controller.deleteNode(node);
                }
            }
            this.controller.getFrame().out(LocalizationSupport.message("splmm_monitoringDir_pasteBookmarks"));
            this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
        }
    }

    private class MyTask
    extends AbstractMonitoringAction.Task {
        List<File> monDirFiles;
        List<MindMapNode> monDirFilesLinkedNodes;
        List<BibTex> bibTexList;
        MindMapNode node;
        MindMapNode equalNode;
        PdfFileFilter pdfFilter = new PdfFileFilter();

        private MyTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            EditMonitoringDirAction.this.nodesFromOldDirectory = EditMonitoringDirAction.this.getNodesToRemove(EditMonitoringDirAction.this.selected, new File(EditMonitoringDirAction.this.oldDirectory));
            this.bibTexList = BookmarkMindMapNode.ReadBibtexFile();
            this.monDirFilesLinkedNodes = this.getNodesLinkedToMonDirFiles(EditMonitoringDirAction.this.controller.getRootNode());
            boolean importSubfolder = EditMonitoringDirAction.this.isImportSubfolder(EditMonitoringDirAction.this.selected);
            this.monDirFiles = this.getMonDirFilesFromDir(EditMonitoringDirAction.this.directory, importSubfolder);
            for (File monDirFile : this.monDirFiles) {
                this.equalNode = EditMonitoringDirAction.this.GetEqualNodeFromList(this.monDirFilesLinkedNodes, monDirFile);
                if (this.equalNode == null) {
                    this.node = this.pdfFilter.accept(monDirFile) ? this.ImportBookmarksFromFile(monDirFile, this.bibTexList) : new BookmarkMindMapNode(monDirFile.getPath(), monDirFile.getName(), EditMonitoringDirAction.this.controller.getController());
                    if (this.node == null) continue;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            EditMonitoringDirAction.this.controller.paste(MyTask.this.node, EditMonitoringDirAction.this.selected);
                            EditMonitoringDirAction.this.controller.getController().getMapModule().getView().repaintSelecteds();
                        }
                    });
                    continue;
                }
                if (EditMonitoringDirAction.this.nodesFromOldDirectory.contains(this.equalNode)) {
                    EditMonitoringDirAction.this.nodesFromOldDirectory.remove(this.equalNode);
                }
                if (!this.pdfFilter.accept(this.equalNode.getLink())) continue;
                SplmmAttributes splmmAttr = this.equalNode.getSPLMMAttributes();
                Date monDirFileLastModified = new Date(monDirFile.lastModified());
                if (splmmAttr != null && !splmmAttr.getBookmarksUpdated().before(monDirFileLastModified) || !EditMonitoringDirAction.this.isNodeParent(EditMonitoringDirAction.this.selected, this.equalNode)) continue;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        EditMonitoringDirAction.this.importBookmarks(MyTask.this.equalNode);
                    }
                });
            }
            return null;
        }
    }
}

