/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import splmm.Actions.SplmmAbstractAction;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.DirectoryFileFilter;
import splmm.FileFilter.MonDirFileFilter;
import splmm.Gui.WaitDialog;
import splmm.Listeners.SplmmWindowStateListener;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;
import splmm.Thread.EventSenderThread;

public abstract class AbstractMonitoringAction
extends SplmmAbstractAction {
    protected File directory;
    protected Task task;

    public AbstractMonitoringAction(String name, MindMapController controller) {
        super(name, controller);
    }

    protected int ShowFileChooser(File directory) {
        JFileChooser fileChooser = new JFileChooser();
        if (directory != null && directory.exists()) {
            fileChooser = new JFileChooser(directory);
        }
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle(LocalizationSupport.message("choose.a.directory.with.pdf.files"));
        int result = fileChooser.showOpenDialog(this.controller.getFrame().getJFrame());
        if (result == 0) {
            this.directory = fileChooser.getSelectedFile();
        }
        return result;
    }

    protected void ExecuteMyTask(Task myTask) {
        try {
            WaitDialog waitDialog = new WaitDialog(this.controller.getFrame(), this.task);
            waitDialog.setTitle(LocalizationSupport.message("splmm_monitoringDir_update"));
            this.task = myTask;
            this.task.addPropertyChangeListener(waitDialog);
            waitDialog.addPropertyChangeListener(this.task);
            waitDialog.addWindowStateListener(new SplmmWindowStateListener());
            waitDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    if (AbstractMonitoringAction.this.task.name != null && AbstractMonitoringAction.this.task.name == "update") {
                        new EventSenderThread(SciPloreUtils.EVENT_ABORT_READ_MON_DIR, "" + AbstractMonitoringAction.this.task.newFileCounter);
                    }
                    AbstractMonitoringAction.this.task.cancel(true);
                }
            });
            this.task.execute();
            waitDialog.pack();
            waitDialog.setVisible(true);
            while (!this.task.isDone()) {
            }
        }
        catch (Exception e) {
            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
        }
    }

    protected void deleteMonitoredPdfFiles(MindMapNode selected, String path) throws FileNotFoundException {
        File directory = new File(path);
        if (directory.exists()) {
            ArrayList<MindMapNode> nodesToRemove = this.getNodesToRemove(selected, directory);
            for (MindMapNode node : nodesToRemove) {
                this.controller.deleteNode(node);
            }
        } else {
            JOptionPane.showMessageDialog(this.controller.getFrame().getJFrame(), LocalizationSupport.message("directory.not.found"), LocalizationSupport.message("error.while.removing.the.nodes"), 0);
            throw new FileNotFoundException();
        }
    }

    protected ArrayList<MindMapNode> getNodesToRemove(MindMapNode selected, File directory) {
        ArrayList<MindMapNode> nodesToRemove = new ArrayList<MindMapNode>();
        ListIterator childrenIterator = selected.childrenUnfolded();
        while (childrenIterator.hasNext()) {
            MindMapNode child = (MindMapNode)childrenIterator.next();
            if (child.getLink() == null) continue;
            String dirPath = directory.getPath().toLowerCase();
            String linkPath = child.getLink().toLowerCase();
            if (!linkPath.contains(dirPath)) continue;
            nodesToRemove.add(child);
        }
        return nodesToRemove;
    }

    protected void SetNodeColor(MindMapNode node, Color color) {
        node.setColor(color);
        List children = node.getChildren();
        for (MindMapNode child : children) {
            this.SetNodeColor(child, color);
        }
    }

    private boolean NodeIsLinkedToMonitorDirectory(MindMapNode node) {
        if (node.getLink() != null) {
            if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                String dirPath = this.directory.getPath().toLowerCase();
                String linkPath = this.getFileFromLink(node).getPath().toLowerCase();
                if (linkPath.contains(dirPath)) {
                    return true;
                }
            } else {
                String dirPath = this.directory.getPath();
                String linkPath = this.getFileFromLink(node).getPath();
                if (linkPath.contains(dirPath)) {
                    return true;
                }
            }
        }
        return false;
    }

    protected MindMapNode GetEqualNodeFromList(List<MindMapNode> nodes, File file) {
        for (MindMapNode listNode : nodes) {
            File linkedFile = this.getFileFromLink(listNode);
            if (linkedFile.compareTo(file) != 0) continue;
            return listNode;
        }
        return null;
    }

    protected List<MindMapNode> GetEqualNodesFromList(List<MindMapNode> nodes, File file) {
        ArrayList<MindMapNode> result = new ArrayList<MindMapNode>();
        for (MindMapNode listNode : nodes) {
            File linkedFile = this.getFileFromLink(listNode);
            if (linkedFile.compareTo(file) != 0 || !listNode.getText().equalsIgnoreCase(file.getName())) continue;
            result.add(listNode);
        }
        return result;
    }

    protected List<MindMapNode> GetFileLinkedNodesFromList(List<MindMapNode> nodes, File file) {
        ArrayList<MindMapNode> result = new ArrayList<MindMapNode>();
        for (MindMapNode listNode : nodes) {
            File linkedFile = this.getFileFromLink(listNode);
            if (linkedFile.compareTo(file) != 0) continue;
            result.add(listNode);
        }
        return result;
    }

    protected void AddMonitoringAtrributes(MindMapNode node) {
        if (node.getAttributeTableLength() == 0) {
            node.createAttributeTableModel();
        }
        node.getAttributes().addRowNoUndo(new Attribute(SciPloreUtils.SPLMM_DIRMON_PATH, this.directory.getPath()));
        node.getAttributes().addRowNoUndo(new Attribute(SciPloreUtils.SPLMM_DIRMON_AUTO, "" + SciPloreUtils.parseBoolean(SplmmPreferences.getAutoMonDir())));
        node.getAttributes().addRowNoUndo(new Attribute(SciPloreUtils.SPLMM_DIRMON_SUBDIRS, "" + SciPloreUtils.parseBoolean(SplmmPreferences.getImportSubfolders())));
    }

    protected void RemoveMonitoringAtrributes(MindMapNode selected) {
        NodeAttributeTableModel attributes = selected.getAttributes();
        attributes.removeRow(selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_PATH));
        attributes.removeRow(selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_AUTO));
        attributes.removeRow(selected.getAttributePosition(SciPloreUtils.SPLMM_DIRMON_SUBDIRS));
    }

    protected boolean isImportSubfolder(MindMapNode selected) {
        return selected.getAttribute(SciPloreUtils.SPLMM_DIRMON_SUBDIRS).equalsIgnoreCase("1");
    }

    public abstract class Task
    extends SwingWorker<Void, Void>
    implements PropertyChangeListener {
        public int newFileCounter;
        public String name;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equalsIgnoreCase("canceled")) {
                this.cancel(true);
            }
        }

        protected MindMapNode ImportBookmarksFromFile(File file, List<BibTex> bibTexList) {
            this.firePropertyChange("watchFolder", "", LocalizationSupport.message("importing.bookmarks.from.file") + this.cutStringForOutput(file.getName(), 36));
            return BookmarkMindMapNode.getBookmarksFromFile(file, AbstractMonitoringAction.this.controller.getController(), bibTexList);
        }

        protected List<MindMapNode> getNodesLinkedToMonDirFiles(MindMapNode node) {
            ArrayList<MindMapNode> nodeList = new ArrayList<MindMapNode>();
            this.firePropertyChange("watchFolder", "", LocalizationSupport.message("scanning.for.nodes.linked.to.pdf") + this.cutStringForOutput(node.getText(), 44));
            if (AbstractMonitoringAction.this.isLinkedToMonDirFile(node) && AbstractMonitoringAction.this.NodeIsLinkedToMonitorDirectory(node)) {
                nodeList.add(node);
            }
            List children = node.getChildren();
            for (MindMapNode child : children) {
                nodeList.addAll(this.getNodesLinkedToMonDirFiles(child));
            }
            return nodeList;
        }

        protected List<File> getMonDirFilesFromDir(File directory, boolean importSubfolder) {
            if (!directory.isDirectory()) {
                return new ArrayList<File>();
            }
            this.firePropertyChange("watchFolder", "", LocalizationSupport.message("searching.pdfs.in.directory") + this.cutStringForOutput(directory.getPath(), 39));
            ArrayList<File> monDirFiles = new ArrayList<File>();
            File[] files = directory.listFiles(new MonDirFileFilter());
            monDirFiles.addAll(Arrays.asList(files));
            if (importSubfolder) {
                File[] directories;
                for (File dir : directories = directory.listFiles(new DirectoryFileFilter())) {
                    monDirFiles.addAll(this.getMonDirFilesFromDir(dir, importSubfolder));
                }
            }
            return monDirFiles;
        }

        protected String cutStringForOutput(String string, int length) {
            return string;
        }
    }
}

