/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.pool;

import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.pool.IPoolObjectFactory;
import java.util.Stack;

public class GenericPool
implements IPool {
    private final IPoolObjectFactory objectFactory;
    private final Stack<Object> objects;
    private boolean closed;

    public GenericPool(IPoolObjectFactory iPoolObjectFactory) {
        this.objectFactory = iPoolObjectFactory;
        this.objects = new Stack();
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin(Object object) throws Exception {
        this.deactivateObject(object);
        GenericPool genericPool = this;
        synchronized (genericPool) {
            this.assertOpen();
            this.objects.push(object);
        }
    }

    protected void deactivateObject(Object object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.deactivateObject(object);
    }

    protected void destroyObject(Object object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.destroyObject(object);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("pool closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object checkout() throws Exception {
        Object object = null;
        GenericPool genericPool = this;
        synchronized (genericPool) {
            this.assertOpen();
            object = this.objects.isEmpty() ? this.createObject() : this.objects.pop();
        }
        this.activateObject(object);
        return object;
    }

    protected void activateObject(Object object) throws Exception {
        if (this.objectFactory == null) {
            return;
        }
        this.objectFactory.activateObject(object);
    }

    protected Object createObject() throws Exception {
        if (this.objectFactory == null) {
            throw new IllegalStateException("can not create new object");
        }
        Object object = this.objectFactory.createObject();
        if (object == null) {
            throw new IllegalStateException("new object can't be null");
        }
        return object;
    }

    public void close() throws Exception {
        this.closed = true;
    }

    public void destroy(Object object) throws Exception {
        this.destroyObject(object);
    }
}

