/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.tools.collection.ByteArrayTools;

public class PDFontDescriptorEmbedded
extends PDFontDescriptor {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Descent = COSName.constant("Descent");
    public static final COSName DK_CapHeight = COSName.constant("CapHeight");
    public static final COSName DK_FontStretch = COSName.constant("FontStretch");
    public static final COSName DK_FontWeight = COSName.constant("FontWeight");
    public static final COSName DK_CharSet = COSName.constant("CharSet");
    public static final COSName DK_CIDSet = COSName.constant("CIDSet");
    public static final COSName DK_Style = COSName.constant("Style");
    public static final COSName DK_Lang = COSName.constant("Lang");
    public static final COSName DK_FD = COSName.constant("FD");
    public static final COSName DK_AvgWidth = COSName.constant("AvgWidth");
    public static final COSName DK_Ascent = COSName.constant("Ascent");
    public static final COSName DK_XHeight = COSName.constant("XHeight");
    public static final COSName DK_StemV = COSName.constant("StemV");
    public static final COSName DK_StemH = COSName.constant("StemH");
    public static final COSName DK_MissingWidth = COSName.constant("MissingWidth");
    public static final COSName DK_MaxWidth = COSName.constant("MaxWidth");
    public static final COSName DK_Leading = COSName.constant("Leading");
    public static final COSName DK_ItalicAngle = COSName.constant("ItalicAngle");
    public static final COSName DK_FontName = COSName.constant("FontName");
    public static final COSName DK_FontBBox = COSName.constant("FontBBox");
    public static final COSName DK_Flags = COSName.constant("Flags");
    public static final COSName DK_FontFile = COSName.constant("FontFile");
    public static final COSName DK_FontFile2 = COSName.constant("FontFile2");
    public static final COSName DK_FontFile3 = COSName.constant("FontFile3");
    public static final COSName DK_Length1 = COSName.constant("Length1");
    public static final COSName DK_Length2 = COSName.constant("Length2");
    public static final COSName DK_Length3 = COSName.constant("Length3");
    public static final COSName DK_FontFamily = COSName.constant("FontFamily");

    protected PDFontDescriptorEmbedded(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSStream cosGetFontFile() {
        return this.cosGetField(DK_FontFile).asStream();
    }

    public COSStream cosGetFontFile2() {
        return this.cosGetField(DK_FontFile2).asStream();
    }

    public COSStream cosGetFontFile3() {
        return this.cosGetField(DK_FontFile3).asStream();
    }

    public float getAscent() {
        return this.getFieldFixed(DK_Ascent, 0.0f);
    }

    public float getAvgWidth() {
        return this.getFieldFixed(DK_AvgWidth, 0.0f);
    }

    public float getCapHeight() {
        return this.getFieldFixed(DK_CapHeight, 0.0f);
    }

    public String getCharSet() {
        return this.getFieldString(DK_CharSet, null);
    }

    public float getDescent() {
        return this.getFieldFixed(DK_Descent, 0.0f);
    }

    public int getFlagsValue() {
        return this.getFieldInt(DK_Flags, 0);
    }

    public CDSRectangle getFontBB() {
        COSArray cOSArray = this.cosGetField(DK_FontBBox).asArray();
        if (cOSArray == null) {
            return null;
        }
        return CDSRectangle.createFromCOS(cOSArray);
    }

    public String getFontFamily() {
        COSString cOSString = this.cosGetField(DK_FontFamily).asString();
        return cOSString == null ? null : cOSString.stringValue();
    }

    public byte[] getFontFile() {
        COSStream cOSStream = this.cosGetField(DK_FontFile).asStream();
        if (cOSStream == null) {
            return null;
        }
        return cOSStream.getDecodedBytes();
    }

    public byte[] getFontFile2() {
        COSStream cOSStream = this.cosGetField(DK_FontFile2).asStream();
        if (cOSStream == null) {
            return null;
        }
        return cOSStream.getDecodedBytes();
    }

    public byte[] getFontFile3() {
        COSStream cOSStream = this.cosGetField(DK_FontFile3).asStream();
        if (cOSStream == null) {
            return null;
        }
        return cOSStream.getDecodedBytes();
    }

    public String getFontName() {
        COSName cOSName = this.cosGetField(DK_FontName).asName();
        return cOSName == null ? null : cOSName.stringValue();
    }

    public String getFontStretch() {
        return this.getFieldString(DK_FontStretch, null);
    }

    public int getFontWeight() {
        return this.getFieldInt(DK_FontWeight, 400);
    }

    public float getItalicAngle() {
        return this.getFieldFixed(DK_ItalicAngle, 0.0f);
    }

    public int getLeading() {
        return this.getFieldInt(DK_Leading, 0);
    }

    public int getMaxWidth() {
        return this.getFieldInt(DK_MaxWidth, 0);
    }

    public int getMissingWidth() {
        return this.getFieldInt(DK_MissingWidth, 0);
    }

    public int getStemH() {
        return this.getFieldInt(DK_StemH, 0);
    }

    public int getStemV() {
        return this.getFieldInt(DK_StemV, 0);
    }

    public float getXHeight() {
        return this.getFieldInt(DK_XHeight, 0);
    }

    public void removeFontFile2() {
        this.cosGetDict().remove(DK_FontFile2);
    }

    public void setAscent(int n) {
        this.setFieldInt(DK_Ascent, n);
    }

    public void setAvgWidth(int n) {
        this.setFieldInt(DK_AvgWidth, n);
    }

    public void setCapHeight(int n) {
        this.setFieldInt(DK_CapHeight, n);
    }

    public void setCharSet(String string) {
        this.setFieldString(DK_CharSet, string);
    }

    public void setDescent(int n) {
        this.setFieldInt(DK_Descent, n);
    }

    public void setFlags(int n) {
        this.setFieldInt(DK_Flags, n);
    }

    public void setFlagsValue(int n) {
        this.setFieldInt(DK_Flags, n);
    }

    public void setFontBB(CDSRectangle cDSRectangle) {
        this.setFieldObject(DK_FontBBox, cDSRectangle);
    }

    public void setFontFamily(String string) {
        this.setFieldName(DK_FontFamily, string);
    }

    public void setFontFile(byte[] byArray) {
        COSStream cOSStream = COSStream.create(null);
        this.setLengths(cOSStream, byArray);
        cOSStream.setDecodedBytes(byArray);
        cOSStream.addFilter(Filter.CN_Filter_FlateDecode);
        this.cosSetField(DK_FontFile, cOSStream);
    }

    public void setFontFile2(byte[] byArray) {
        COSStream cOSStream = COSStream.create(null);
        cOSStream.getDict().put(DK_Length1, COSInteger.create(byArray.length));
        cOSStream.addFilter(Filter.CN_Filter_FlateDecode);
        cOSStream.setDecodedBytes(byArray);
        this.cosSetField(DK_FontFile2, cOSStream);
    }

    public void setFontFile3(byte[] byArray) {
        COSStream cOSStream = COSStream.create(null);
        cOSStream.setDecodedBytes(byArray);
        this.cosSetField(DK_FontFile3, cOSStream);
    }

    public void setFontName(String string) {
        this.cosSetField(DK_FontName, COSName.create(string));
    }

    public void setFontStretch(String string) {
        this.setFieldString(DK_FontStretch, string);
    }

    public void setFontWeight(int n) {
        this.setFieldInt(DK_FontWeight, n);
    }

    public void setItalicAngle(float f) {
        this.setFieldFixed(DK_ItalicAngle, f);
    }

    public void setLeading(int n) {
        this.setFieldInt(DK_Leading, n);
    }

    protected void setLengths(COSStream cOSStream, byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray2 = "currentfile eexec".getBytes();
        int n5 = ByteArrayTools.indexOf((byte[])byArray, (int)0, (int)byArray.length, (byte[])byArray2, (int)0, (int)byArray2.length, (int)0);
        if (n5 != -1) {
            n2 = n5 + byArray2.length;
        }
        if ((n = ByteArrayTools.indexOf((byte[])byArray, (int)0, (int)byArray.length, (byte[])(byArray2 = "0000000000000000000000000000000000000000000000000000000000000000".getBytes()), (int)0, (int)byArray2.length, (int)0)) == -1) {
            n3 = byArray.length - n2;
        } else {
            n3 = n - n2;
            n4 = byArray.length - n;
        }
        cOSStream.getDict().put(DK_Length1, COSInteger.create(n2));
        cOSStream.getDict().put(DK_Length2, COSInteger.create(n3));
        cOSStream.getDict().put(DK_Length3, COSInteger.create(n4));
    }

    public void setMaxWidth(int n) {
        this.setFieldInt(DK_MaxWidth, n);
    }

    public void setMissingWidth(int n) {
        this.setFieldInt(DK_MissingWidth, n);
    }

    public void setStemH(int n) {
        this.setFieldInt(DK_StemH, n);
    }

    public void setStemV(int n) {
        this.setFieldInt(DK_StemV, n);
    }

    public void setXHeight(int n) {
        this.setFieldInt(DK_XHeight, n);
    }

    public static class MetaClass
    extends PDFontDescriptor.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFontDescriptorEmbedded(cOSObject);
        }
    }
}

