/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.crypt.ArcFourCryptHandler;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ICryptHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;

public class SystemSecurityHandlerV2
extends SystemSecurityHandler {
    private ICryptHandler cryptHandler;

    protected SystemSecurityHandlerV2(COSDictionary cOSDictionary) {
        super(cOSDictionary);
    }

    protected ICryptHandler createCryptHandler() throws COSSecurityException {
        ArcFourCryptHandler arcFourCryptHandler = new ArcFourCryptHandler();
        arcFourCryptHandler.initialize(this.getSecurityHandler().getCryptKey());
        return arcFourCryptHandler;
    }

    protected byte[] decrypt(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        return this.getCryptHandler().decrypt(cOSObjectKey, byArray);
    }

    public byte[] decryptFile(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        return this.decrypt(cOSObjectKey, byArray);
    }

    public byte[] decryptStream(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        return this.decrypt(cOSObjectKey, byArray);
    }

    public byte[] decryptString(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        return this.decrypt(cOSObjectKey, byArray);
    }

    protected byte[] encrypt(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        if (!this.isEnabled()) {
            return byArray;
        }
        return this.getCryptHandler().encrypt(cOSObjectKey, byArray);
    }

    public byte[] encryptFile(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        return this.encrypt(cOSObjectKey, byArray);
    }

    public byte[] encryptStream(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        return this.encrypt(cOSObjectKey, byArray);
    }

    public byte[] encryptString(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        return this.encrypt(cOSObjectKey, byArray);
    }

    protected ICryptHandler getCryptHandler() throws COSSecurityException {
        if (this.cryptHandler == null) {
            this.cryptHandler = this.createCryptHandler();
        }
        return this.cryptHandler;
    }

    public int getVersion() {
        return 2;
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        COSEncryption cOSEncryption = this.getEncryption();
        cOSEncryption.setFieldInt(COSEncryption.DK_Length, 128);
    }
}

