/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;

public class COSFixed
extends COSNumber {
    public static final int DEFAULT_PRECISION = 5;
    private final float floatValue;
    private byte precision;

    public static COSFixed create(byte[] byArray, int n, int n2) {
        long l = 0L;
        long l2 = 1L;
        int n3 = n + n2;
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        int n5 = n;
        byte by = byArray[n5];
        if (by == 43) {
            ++n5;
        } else if (by == 45) {
            bl = true;
            ++n5;
        }
        while (n5 < n3) {
            byte by2 = byArray[n5];
            if (by2 == 46) {
                bl2 = true;
            } else {
                l = l * 10L + (long)by2 - 48L;
                if (bl2) {
                    l2 *= 10L;
                    ++n4;
                }
            }
            ++n5;
        }
        if (bl) {
            return new COSFixed(-((float)((double)l / (double)l2)), n4);
        }
        return new COSFixed((float)((double)l / (double)l2), n4);
    }

    public static COSFixed create(double d) {
        return new COSFixed((float)d, 5);
    }

    public static COSFixed create(double d, int n) {
        return new COSFixed((float)d, n);
    }

    public static COSFixed create(float f) {
        return new COSFixed(f, 5);
    }

    public static COSFixed create(float f, int n) {
        return new COSFixed(f, n);
    }

    protected COSFixed(float f, int n) {
        this.floatValue = f;
        this.precision = (byte)n;
    }

    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromFixed(this);
    }

    public COSFixed asFixed() {
        return this;
    }

    protected String basicToString() {
        return String.valueOf(this.floatValue);
    }

    protected COSObject copyBasic() {
        return new COSFixed(this.floatValue, this.precision);
    }

    public boolean equals(Object object) {
        if (!(object instanceof COSFixed)) {
            return false;
        }
        return this.floatValue == ((COSFixed)object).floatValue;
    }

    public float floatValue() {
        return this.floatValue;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.floatValue);
    }

    public int intValue() {
        return (int)this.floatValue;
    }

    public void restoreState(Object object) {
        super.restoreState(object);
        COSFixed cOSFixed = (COSFixed)object;
        this.precision = cOSFixed.precision;
    }

    public Object saveState() {
        COSFixed cOSFixed = new COSFixed(this.floatValue, this.precision);
        cOSFixed.container = this.container.saveStateContainer();
        return cOSFixed;
    }

    public void setPrecision(int n) {
        this.precision = (byte)n;
    }
}

