/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.action;

import de.intarsys.pdf.app.action.ActionProcessor;
import de.intarsys.pdf.app.action.PACKAGE;
import de.intarsys.pdf.app.action.TriggerEvent;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cds.CDSTreeEntry;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.tools.attribute.Attribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionTools {
    public static final COSName DK_JavaScript = COSName.constant("JavaScript");
    private static final Logger Log = PACKAGE.Log;
    private static final Attribute ATTR_DISABLEDACTIONS = new Attribute("disabledActions");

    public static TriggerEvent annotationTriggerBlurred(PDAnnotation pDAnnotation) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "blurred [" + pDAnnotation.toString() + "]");
        }
        PDWidgetAnnotation pDWidgetAnnotation = (PDWidgetAnnotation)pDAnnotation;
        PDAcroFormField pDAcroFormField = pDWidgetAnnotation.getAcroFormField();
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_Bl);
        triggerEvent.setTarget(pDAcroFormField.getLogicalRoot());
        triggerEvent.setValue(pDAcroFormField.getValueString());
        triggerEvent.setTargetName(pDAcroFormField.getQualifiedName());
        ActionTools.process(triggerEvent, pDAcroFormField);
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerFocus(PDAnnotation pDAnnotation) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "focus [" + pDAnnotation.toString() + "]");
        }
        PDWidgetAnnotation pDWidgetAnnotation = (PDWidgetAnnotation)pDAnnotation;
        PDAcroFormField pDAcroFormField = pDWidgetAnnotation.getAcroFormField();
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_Fo);
        triggerEvent.setTarget(pDAcroFormField.getLogicalRoot());
        triggerEvent.setValue(pDAcroFormField.getValueString());
        triggerEvent.setTargetName(pDAcroFormField.getQualifiedName());
        ActionTools.process(triggerEvent, pDAcroFormField);
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerKeystroke(PDAnnotation pDAnnotation, String string, boolean bl, int n, boolean bl2, int n2, int n3, boolean bl3, String string2) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "keystroke [" + pDAnnotation.toString() + "]");
        }
        PDWidgetAnnotation pDWidgetAnnotation = (PDWidgetAnnotation)pDAnnotation;
        PDAcroFormField pDAcroFormField = pDWidgetAnnotation.getAcroFormField().getLogicalRoot();
        TriggerEvent triggerEvent = new TriggerEvent(pDAcroFormField.getDoc(), PDAdditionalActions.CN_trigger_K);
        triggerEvent.setChange(string);
        triggerEvent.setWillCommit(bl);
        triggerEvent.setCommitKey(n);
        triggerEvent.setModifier(bl2);
        triggerEvent.setSelStart(n2);
        triggerEvent.setSelEnd(n3);
        triggerEvent.setShift(bl3);
        triggerEvent.setTarget(pDAcroFormField.getLogicalRoot());
        triggerEvent.setTargetName(pDAcroFormField.getQualifiedName());
        triggerEvent.setValue(string2);
        ActionTools.process(triggerEvent, pDAcroFormField);
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerMouseDown(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "mouse down [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_D)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_D);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerMouseEnter(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "mouse enter [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_E)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_E);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerMouseExit(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "mouse exit [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_X)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_X);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerMouseUp(PDAnnotation pDAnnotation) {
        TriggerEvent triggerEvent;
        COSDictionary cOSDictionary;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "mouse up [" + pDAnnotation.toString() + "]");
        }
        if ((cOSDictionary = pDAnnotation.cosGetField(PDAnnotation.DK_A).asDictionary()) != null) {
            triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), null);
            triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
            COSName cOSName = cOSDictionary.get(PDAction.DK_S).asName();
            ActionProcessor.get().process(triggerEvent, cOSName, cOSDictionary);
        } else {
            PDAction pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_U);
            if (pDAction == null) {
                return null;
            }
            triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_U);
            triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
            ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        }
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerPageClose(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "page close [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_PC)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_PC);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerPageInvisible(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "page invisible [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_PI)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_PI);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerPageOpen(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "page open [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_PO)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_PO);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static TriggerEvent annotationTriggerPageVisible(PDAnnotation pDAnnotation) {
        PDAction pDAction;
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "page visible [" + pDAnnotation.toString() + "]");
        }
        if ((pDAction = ActionTools.getAction(pDAnnotation, PDAdditionalActions.CN_trigger_PV)) == null) {
            return null;
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDAnnotation.getDoc(), PDAdditionalActions.CN_trigger_PV);
        triggerEvent.setTarget(ActionTools.getTriggerEventTarget(pDAnnotation));
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
        return triggerEvent;
    }

    public static ActionDisablement disableActions(COSDocument cOSDocument, COSName cOSName) {
        ArrayList<ActionDisablement> arrayList = (ArrayList<ActionDisablement>)cOSDocument.getAttribute(ATTR_DISABLEDACTIONS);
        if (arrayList == null) {
            arrayList = new ArrayList<ActionDisablement>();
            cOSDocument.setAttribute(ATTR_DISABLEDACTIONS, arrayList);
        }
        ActionDisablement actionDisablement = new ActionDisablement();
        actionDisablement.actionType = cOSName;
        arrayList.add(actionDisablement);
        return actionDisablement;
    }

    public static void documentProcessModules(PDDocument pDDocument) {
        COSCatalog cOSCatalog = pDDocument.getCatalog();
        if (cOSCatalog == null) {
            return;
        }
        COSDictionary cOSDictionary = cOSCatalog.cosGetNames();
        if (cOSDictionary == null) {
            return;
        }
        CDSNameTreeNode cDSNameTreeNode = CDSNameTreeNode.createFromCos(cOSDictionary.get(DK_JavaScript).asDictionary());
        if (cDSNameTreeNode == null) {
            return;
        }
        Iterator iterator = cDSNameTreeNode.iterator();
        while (iterator.hasNext()) {
            Object object;
            CDSTreeEntry cDSTreeEntry = (CDSTreeEntry)iterator.next();
            COSObject cOSObject = cDSTreeEntry.getKey();
            if (cOSObject != null && !cOSObject.isNull() && ((String)(object = cOSObject.stringValue())).toUpperCase().startsWith("!ADBE::")) continue;
            object = cDSTreeEntry.getValue();
            TriggerEvent triggerEvent = new TriggerEvent(pDDocument, null);
            ActionProcessor.get().process(triggerEvent, DK_JavaScript, (COSObject)object);
        }
    }

    public static TriggerEvent documentTriggerClose(PDDocument pDDocument) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "document close [" + pDDocument.getName() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDDocument, PDAdditionalActions.CN_trigger_DC);
        triggerEvent.setTarget(pDDocument);
        ActionTools.process(triggerEvent, pDDocument);
        triggerEvent = new TriggerEvent(pDDocument, PDAdditionalActions.CN_trigger_WC);
        triggerEvent.setTarget(pDDocument);
        ActionTools.process(triggerEvent, pDDocument);
        return triggerEvent;
    }

    public static TriggerEvent documentTriggerDidPrint(PDDocument pDDocument) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "did print [" + pDDocument.getName() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDDocument, PDAdditionalActions.CN_trigger_DP);
        triggerEvent.setTarget(pDDocument);
        ActionTools.process(triggerEvent, pDDocument);
        return triggerEvent;
    }

    public static TriggerEvent documentTriggerDidSave(PDDocument pDDocument) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "did save [" + pDDocument.getName() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDDocument, PDAdditionalActions.CN_trigger_DS);
        triggerEvent.setTarget(pDDocument);
        ActionTools.process(triggerEvent, pDDocument);
        return triggerEvent;
    }

    public static TriggerEvent documentTriggerOpen(PDDocument pDDocument) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "document open [" + pDDocument.getName() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDDocument, null);
        triggerEvent.setTarget(pDDocument);
        COSObject cOSObject = pDDocument.getCatalog().cosGetOpenAction();
        if (cOSObject.isNull()) {
            return null;
        }
        COSName cOSName = null;
        cOSName = cOSObject instanceof COSDictionary ? ((COSDictionary)cOSObject).get(PDAction.DK_S).asName() : PDActionGoTo.CN_ActionType_GoTo;
        ActionProcessor.get().process(triggerEvent, cOSName, cOSObject);
        return triggerEvent;
    }

    public static TriggerEvent documentTriggerWillPrint(PDDocument pDDocument) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "will print [" + pDDocument.getName() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDDocument, PDAdditionalActions.CN_trigger_WP);
        triggerEvent.setTarget(pDDocument);
        ActionTools.process(triggerEvent, pDDocument);
        return triggerEvent;
    }

    public static TriggerEvent documentTriggerWillSave(PDDocument pDDocument) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "will save [" + pDDocument.getName() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDDocument, PDAdditionalActions.CN_trigger_WS);
        triggerEvent.setTarget(pDDocument);
        ActionTools.process(triggerEvent, pDDocument);
        return triggerEvent;
    }

    public static void enableActions(COSDocument cOSDocument, ActionDisablement actionDisablement) {
        ArrayList arrayList = (ArrayList)cOSDocument.getAttribute(ATTR_DISABLEDACTIONS);
        if (arrayList == null) {
            arrayList = new ArrayList();
            cOSDocument.setAttribute(ATTR_DISABLEDACTIONS, arrayList);
        }
        arrayList.remove(actionDisablement);
    }

    public static TriggerEvent fieldTriggerCalculate(PDAcroFormField pDAcroFormField, String string, PDAcroFormField pDAcroFormField2) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "calculate [" + pDAcroFormField.toString() + "]");
        }
        pDAcroFormField = pDAcroFormField.getLogicalRoot();
        TriggerEvent triggerEvent = new TriggerEvent(pDAcroFormField2, pDAcroFormField.getDoc(), PDAdditionalActions.CN_trigger_C);
        triggerEvent.setTarget(pDAcroFormField);
        triggerEvent.setValue(string);
        triggerEvent.setTargetName(pDAcroFormField.getQualifiedName());
        ActionTools.process(triggerEvent, pDAcroFormField);
        return triggerEvent;
    }

    public static TriggerEvent fieldTriggerFormat(PDAcroFormField pDAcroFormField, boolean bl, int n, String string) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "format [" + pDAcroFormField.toString() + "]");
        }
        pDAcroFormField = pDAcroFormField.getLogicalRoot();
        TriggerEvent triggerEvent = new TriggerEvent(pDAcroFormField.getDoc(), PDAdditionalActions.CN_trigger_F);
        triggerEvent.setWillCommit(bl);
        triggerEvent.setCommitKey(n);
        triggerEvent.setTarget(pDAcroFormField.getLogicalRoot());
        triggerEvent.setTargetName(pDAcroFormField.getQualifiedName());
        triggerEvent.setValue(string);
        ActionTools.process(triggerEvent, pDAcroFormField);
        return triggerEvent;
    }

    public static TriggerEvent fieldTriggerValidate(PDAcroFormField pDAcroFormField, String string) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "validate [" + pDAcroFormField.toString() + "]");
        }
        pDAcroFormField = pDAcroFormField.getLogicalRoot();
        TriggerEvent triggerEvent = new TriggerEvent(pDAcroFormField.getDoc(), PDAdditionalActions.CN_trigger_V);
        triggerEvent.setTarget(pDAcroFormField.getLogicalRoot());
        triggerEvent.setTargetName(pDAcroFormField.getQualifiedName());
        triggerEvent.setValue(string);
        ActionTools.process(triggerEvent, pDAcroFormField);
        return triggerEvent;
    }

    protected static PDAction getAction(IAdditionalActionSupport iAdditionalActionSupport, COSName cOSName) {
        if (iAdditionalActionSupport == null) {
            return null;
        }
        PDAdditionalActions pDAdditionalActions = iAdditionalActionSupport.getAdditionalActions();
        if (pDAdditionalActions == null) {
            return null;
        }
        return pDAdditionalActions.getAction(cOSName);
    }

    protected static Object getTriggerEventTarget(PDAnnotation pDAnnotation) {
        if (pDAnnotation.isWidgetAnnotation()) {
            return ((PDWidgetAnnotation)pDAnnotation).getAcroFormField().getLogicalRoot();
        }
        return pDAnnotation;
    }

    public static boolean isEnabled(COSDocument cOSDocument, COSName cOSName) {
        List list = (List)cOSDocument.getAttribute(ATTR_DISABLEDACTIONS);
        if (list == null) {
            return true;
        }
        for (ActionDisablement actionDisablement : list) {
            if (actionDisablement.actionType != null && !actionDisablement.actionType.equals(cOSName)) continue;
            return false;
        }
        return true;
    }

    public static TriggerEvent pageTriggerClose(PDPage pDPage) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "close [" + pDPage.toString() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDPage.getDoc(), PDAdditionalActions.CN_trigger_C);
        triggerEvent.setTarget(pDPage);
        ActionTools.process(triggerEvent, pDPage);
        return triggerEvent;
    }

    public static TriggerEvent pageTriggerOpen(PDPage pDPage) {
        if (Log.isLoggable(Level.FINEST)) {
            Log.log(Level.FINEST, "open [" + pDPage.toString() + "]");
        }
        TriggerEvent triggerEvent = new TriggerEvent(pDPage.getDoc(), PDAdditionalActions.CN_trigger_O);
        triggerEvent.setTarget(pDPage);
        ActionTools.process(triggerEvent, pDPage);
        return triggerEvent;
    }

    protected static void process(TriggerEvent triggerEvent, IAdditionalActionSupport iAdditionalActionSupport) {
        if (iAdditionalActionSupport == null && triggerEvent.getTarget() instanceof IAdditionalActionSupport) {
            iAdditionalActionSupport = (IAdditionalActionSupport)triggerEvent.getTarget();
        }
        if (iAdditionalActionSupport == null) {
            return;
        }
        PDAdditionalActions pDAdditionalActions = iAdditionalActionSupport.getAdditionalActions();
        if (pDAdditionalActions == null) {
            return;
        }
        PDAction pDAction = pDAdditionalActions.getAction(triggerEvent.getReason());
        if (pDAction == null) {
            return;
        }
        ActionProcessor.get().process(triggerEvent, pDAction.cosGetActionType(), pDAction.cosGetObject());
    }

    public static class ActionDisablement {
        protected COSName actionType;
    }
}

