/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public class StringLocator
extends CommonLocator {
    private final String content;
    private String type;
    private String localName;
    private String encoding = System.getProperty("file.encoding");

    public StringLocator(String string, String string2, String string3) {
        this.content = string;
        this.localName = string2;
        this.type = string3;
    }

    public void delete() throws IOException {
    }

    public boolean exists() {
        return this.getContent() != null;
    }

    protected byte[] getBytes() {
        byte[] byArray;
        try {
            byArray = this.getContent().getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = this.getContent().getBytes();
        }
        return byArray;
    }

    public ILocator getChild(String string) {
        return null;
    }

    protected String getContent() {
        return this.content;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFullName() {
        if (this.getType() == null) {
            return this.getLocalName();
        }
        return String.valueOf(this.getLocalName()) + "." + this.getType();
    }

    public InputStream getInputStream() throws IOException {
        byte[] byArray = this.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public long getLength() throws IOException {
        return this.getBytes().length;
    }

    public String getLocalName() {
        return this.localName;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    public ILocator getParent() {
        return null;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        byte[] byArray = this.getBytes();
        return new RandomAccessByteArray(byArray);
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.getContent());
    }

    public Reader getReader(String string) throws IOException {
        return new StringReader(this.getContent());
    }

    public String getType() {
        return this.type;
    }

    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    public Writer getWriter(String string) throws IOException {
        throw new IOException("locator is read only");
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isOutOfSynch() {
        return false;
    }

    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    public ILocator[] listLocators(ILocatorNameFilter iLocatorNameFilter) throws IOException {
        return new ILocator[0];
    }

    public void rename(String string) throws IOException {
        this.localName = FileTools.getBaseName(string);
        this.type = FileTools.getExtension(string, this.getType());
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void synch() {
    }

    public URL toURL() {
        return null;
    }
}

