/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class FileLocatorFactory
implements ILocatorFactory {
    public static final String PATH_SEPARATOR = ";";
    private List searchPaths;
    private String searchPathDefinition;
    private boolean synchSynchronous = true;

    public FileLocatorFactory() {
        this.setSearchPathDefinition("./");
    }

    public void setSearchPathDefinition(String string) {
        this.searchPathDefinition = string;
        this.searchPaths = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(this.searchPathDefinition, PATH_SEPARATOR);
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string2 == null || string2.trim().length() <= 0 || this.searchPaths.contains(string2)) continue;
            this.searchPaths.add(string2);
        }
    }

    public String getSearchPathDefinition() {
        return this.searchPathDefinition;
    }

    public void setSearchPaths(List list) {
        this.searchPaths = list;
    }

    public List getSearchPaths() {
        return this.searchPaths;
    }

    public void setSynchSynchronous(boolean bl) {
        this.synchSynchronous = bl;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public ILocator createLocator(String string) {
        FileLocator fileLocator = null;
        for (String string2 : this.getSearchPaths()) {
            File file = new File(string2);
            File file2 = FileTools.resolvePath(file, string);
            fileLocator = new FileLocator(file2);
            if (fileLocator.exists()) break;
        }
        if (fileLocator != null) {
            fileLocator.setSynchSynchronous(this.isSynchSynchronous());
        }
        return fileLocator;
    }
}

