/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.event;

import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.IEventDispatcher;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;

public class EventDispatcher
implements INotificationSupport,
IEventDispatcher {
    private final Object owner;
    private EventType[] types = new EventType[4];
    private INotificationListener[] listeners = new INotificationListener[4];

    public EventDispatcher(Object object) {
        this.owner = object;
    }

    public synchronized void addNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        if (iNotificationListener == null) {
            throw new NullPointerException("listener may not be null");
        }
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.listeners[n2] == null) break;
            ++n2;
        }
        if (n2 >= n) {
            INotificationListener[] iNotificationListenerArray = new INotificationListener[n + 4];
            System.arraycopy(this.listeners, 0, iNotificationListenerArray, 0, n);
            this.listeners = iNotificationListenerArray;
            EventType[] eventTypeArray = new EventType[n + 4];
            System.arraycopy(this.types, 0, eventTypeArray, 0, n);
            this.types = eventTypeArray;
        }
        this.types[n2] = eventType;
        this.listeners[n2] = iNotificationListener;
    }

    public synchronized void attach(INotificationSupport iNotificationSupport) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            EventType eventType = this.types[n2];
            if (eventType != null) {
                iNotificationSupport.addNotificationListener(eventType, this.listeners[n2]);
            }
            ++n2;
        }
    }

    public synchronized void clear() {
        this.types = new EventType[4];
        this.listeners = new INotificationListener[4];
    }

    public synchronized void detach(INotificationSupport iNotificationSupport) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            EventType eventType = this.types[n2];
            if (eventType != null) {
                iNotificationSupport.removeNotificationListener(eventType, this.listeners[n2]);
            }
            ++n2;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    protected boolean hasListener(EventType eventType, INotificationListener iNotificationListener) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.types[n2] == eventType && this.listeners[n2] == iNotificationListener) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        int n = 0;
        while (n < this.listeners.length) {
            if (this.listeners[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized void removeNotificationListener(EventType eventType, INotificationListener iNotificationListener) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.types[n2] == eventType && this.listeners[n2] == iNotificationListener) {
                this.types[n2] = null;
                this.listeners[n2] = null;
                break;
            }
            ++n2;
        }
    }

    public void triggerEvent(Event event) {
        EventType eventType = event.getEventType();
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            EventType eventType2 = this.types[n2];
            if (eventType2 == eventType || eventType2 == EventType.ALWAYS) {
                this.listeners[n2].handleEvent(event);
            }
            ++n2;
        }
    }

    public void triggerEventReverse(Event event) {
        EventType eventType = event.getEventType();
        int n = this.listeners.length;
        while (n >= 0) {
            EventType eventType2 = this.types[n];
            if (eventType2 == eventType || eventType2 == EventType.ALWAYS) {
                this.listeners[n].handleEvent(event);
            }
            --n;
        }
    }
}

