/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import freemind.main.FreeMindMain;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;

public class SciPloreUtils {
    public static String SPLMM_REFKEY_NAME = "splmm_refkey";
    public static final String SPLMM_REFKEY_TITLE = "splmm_reftitle";
    public static String SPLMM_DIRMON_PATH = "splmm_dirmon_path";
    public static String SPLMM_DIRMON_AUTO = "splmm_dirmon_auto";
    public static String SPLMM_DIRMON_SUBDIRS = "splmm_dirmon_subdirs";
    public static String SPLMM_URL = "http://www.sciplore.org/software/sciplore_mindmapping/";
    public static String CONTACT_URL = "http://www.sciplore.org/contact_en.php?progID=1";
    public static String HELP_URL = "http://www.sciplore.org/software/sciplore_mindmapping/manual/en/";
    public static String PRIVACY_URL = "www.sciplore.org/privacy/splmm_en.php";
    public static String SAVE_TEXT = "<!-- To view this file, download free mind mapping software SciPlore MindMapping from http://www.sciplore.org/software/sciplore_mindmapping/ -->\n";
    public static String CURRENT_VERSION = "beta10";
    public static String CURRENT_VERSION_SHORT = "b10";
    public static double CURRENT_VERSION_Double = 1.0;
    public static String ABOUT_VERSION_TEXT = "SciPlore MindMapping -- Beta 10 \n";
    public static String UPDATE_URL = "http://sciplore.org/update.php?prog_id=1&version=" + CURRENT_VERSION_SHORT + "&userID=";
    private static FreeMindMain frame;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkForUpdate(FreeMindMain frame) {
        URL url;
        SciPloreUtils.frame = frame;
        if (!SplmmPreferences.getUpdateInfo().booleanValue()) {
            return;
        }
        InputStream is = null;
        try {
            url = new URL(UPDATE_URL + SplmmPreferences.getUserName() + "&backup=" + SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()) + "&ironmm=" + SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()) + "&ironld=" + SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonLD()));
            if (!InetAddress.getByName("www.sciplore.org").isReachable(5000)) {
                return;
            }
        }
        catch (MalformedURLException e) {
            return;
        }
        catch (UnknownHostException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        URLConnection urlConnection = url.openConnection();
        is = urlConnection.getInputStream();
        Scanner s = new Scanner(is);
        int i = 1;
        while (s.hasNext()) {
            String currVer = s.next();
            if (i == 5) {
                System.out.println(i + currVer);
                if (!currVer.equals(CURRENT_VERSION) && SplmmPreferences.getUpdateInfo().booleanValue()) {
                    String notification = LocalizationSupport.message("splmm_update_notification");
                    JLabel label = new JLabel(notification);
                    label.setFont(new Font("sansserif", 0, 14));
                    Object[] options = new Object[]{LocalizationSupport.message("splmm_update_cancel"), LocalizationSupport.message("splmm_update_ok")};
                    int n = JOptionPane.showOptionDialog(frame.getJFrame(), label, "", 0, 1, null, options, options[1]);
                    if (n == 1) {
                        SciPloreUtils.openURL(SPLMM_URL);
                    }
                    if (n == 0) {
                        SplmmPreferences.setUpdateInfo(false);
                    }
                }
            }
            ++i;
        }
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (IOException e) {}
        return;
        catch (MalformedURLException e) {
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException e2) {
                // empty catch block
            }
            return;
        }
        catch (IOException e2) {
            if (is == null) return;
            try {
                is.close();
                return;
            }
            catch (IOException e3) {
                // empty catch block
            }
            return;
            {
                catch (Throwable throwable) {
                    if (is == null) throw throwable;
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (IOException e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public static void openURL(String url) {
        try {
            String osName = System.getProperty("os.name");
            if (osName.substring(0, 3).equals("Win")) {
                String command = "rundll32 url.dll,FileProtocolHandler " + url;
                Runtime.getRuntime().exec(command);
            } else if (osName.startsWith("Mac OS")) {
                String command = "open -a //Applications//Safari.app " + url;
                Runtime.getRuntime().exec(command);
            } else {
                String command = "mozilla " + url;
                Runtime.getRuntime().exec(command);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static String parseBoolean(Boolean bool) {
        if (bool.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public static String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(" [ ");
        pw.print(exception.getClass().getName());
        pw.print(" ] ");
        pw.print(exception.getMessage());
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static void logException(String className, Exception exception, Level level) {
        Logger logger = frame.getLogger(className);
        String stringException = SciPloreUtils.getStackTraceAsString(exception);
        System.out.println(stringException);
        logger.log(level, className + ": " + stringException);
    }

    public static String getMindMapID(File file) {
        try {
            int endIndex;
            String string;
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((string = reader.readLine()) != null) {
                buffer.append(string);
            }
            int startIndex = buffer.indexOf("mapID=\"");
            if (startIndex != -1 && (endIndex = buffer.indexOf("\"", startIndex + 7)) != -1) {
                return buffer.substring(startIndex + 7, endIndex);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
        }
        catch (IOException e) {
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
        }
        return null;
    }

    public static String getResource(String key) {
        return frame.getResourceString(key);
    }

    public static byte[] zip(String mindmap) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedOutputStream bufos = null;
            bufos = new BufferedOutputStream(new GZIPOutputStream(bos));
            bufos.write(mindmap.getBytes());
            bufos.close();
            byte[] retval = bos.toByteArray();
            bos.close();
            return retval;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static String encodeToUnicodeStandard(String pData) {
        StringBuffer encodedData = new StringBuffer();
        StringBuffer sBuff = new StringBuffer(pData);
        for (int i = 0; i < sBuff.length(); ++i) {
            char ch = sBuff.charAt(i);
            char chVal = ch;
            if (chVal > '\u007f') {
                encodedData.append("&#x").append(Integer.toHexString(chVal)).append(";");
                continue;
            }
            encodedData.append(ch);
        }
        return encodedData.toString();
    }

    public static boolean isInternetReachable() {
        try {
            URL url = new URL("www.sciplore.org");
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            Object object = urlConnect.getContent();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

