/*
 * Decompiled with CFR 0.152.
 */
package splmm.Preferences;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;
import splmm.SciPloreWebClient;

public class SplmmPreferences {
    private static final Preferences preferences = Preferences.userRoot().node("SplmmPreferences");
    private static final String JAB_REF_PATH = "JabRefPath";
    private static final String UPDATE_INFO = "UpdateInfo";
    private static final String ALLOW_USAGE_MINING = "AllowUsageMining";
    private static final String ALLOW_IR_ON_MM = "AllowIRonMM";
    private static final String ALLOW_IR_ON_LD = "AllowIRonLD";
    private static final String ALLOW_BACKUP = "AllowBackup";
    private static final String VERSION = "Version";
    private static final String AUTO_IMPORT = "AutoImport";
    private static final String USER_NAME = "UserName";
    private static final String PASSWORD = "Password";
    private static final String CREDENTIALS_VALIDATED = "CredentialsValidated";
    private static final String ANONYMOUS_USER_NAME = "AnonymousUserName";
    private static final String BACKUP_SAVE = "BackupSave";

    public static void setVersion(double version) {
        preferences.putDouble(VERSION, version);
    }

    public static double getVersion() {
        return preferences.getDouble(VERSION, -1.0);
    }

    public static void setJabRefPath(String path) {
        preferences.put(JAB_REF_PATH, path);
    }

    public static String getJabRefPath() {
        return preferences.get(JAB_REF_PATH, null);
    }

    public static void setUpdateInfo(Boolean updateInfo) {
        preferences.putBoolean(UPDATE_INFO, updateInfo);
    }

    public static Boolean getUpdateInfo() {
        return preferences.getBoolean(UPDATE_INFO, true);
    }

    public static void setAllowUsageMining(Boolean allowUsageMining) {
        preferences.putBoolean(ALLOW_USAGE_MINING, allowUsageMining);
    }

    public static Boolean getAllowUsageMining() {
        return preferences.getBoolean(ALLOW_USAGE_MINING, true);
    }

    public static void setAllowIRonMM(Boolean allowIRonMM) {
        preferences.putBoolean(ALLOW_IR_ON_MM, allowIRonMM);
    }

    public static Boolean getAllowIRonMM() {
        return preferences.getBoolean(ALLOW_IR_ON_MM, true);
    }

    public static void setAllowIRonLD(Boolean allowIRonLD) {
        preferences.putBoolean(ALLOW_IR_ON_LD, allowIRonLD);
    }

    public static Boolean getAllowIRonLD() {
        return preferences.getBoolean(ALLOW_IR_ON_LD, true);
    }

    public static void setAllowBackup(Boolean allowBackup) {
        preferences.putBoolean(ALLOW_BACKUP, allowBackup);
    }

    public static Boolean getAllowBackup() {
        return preferences.getBoolean(ALLOW_BACKUP, true);
    }

    public static void setAutoImport(Boolean autoImport) {
        preferences.putBoolean(AUTO_IMPORT, autoImport);
    }

    public static Boolean getAutoImport() {
        return preferences.getBoolean(AUTO_IMPORT, true);
    }

    public static void setUserName(String userName) {
        preferences.put(USER_NAME, userName);
    }

    public static String getUserName() {
        return preferences.get(USER_NAME, null);
    }

    public static void setBackupSave(boolean backupSave) {
        preferences.putBoolean(BACKUP_SAVE, backupSave);
    }

    public static boolean getBackupSave() {
        return preferences.getBoolean(BACKUP_SAVE, false);
    }

    public static void setAnonymousUserName(String anonymousUserName) {
        preferences.put(ANONYMOUS_USER_NAME, anonymousUserName);
    }

    public static String getAnonymousUserName() {
        return preferences.get(ANONYMOUS_USER_NAME, null);
    }

    public static void setCredentialsValidated(Boolean validated) {
        preferences.putBoolean(CREDENTIALS_VALIDATED, validated);
    }

    public static Boolean getCredentialsValidated() {
        return preferences.getBoolean(CREDENTIALS_VALIDATED, false);
    }

    public static void setPassword(String password) {
        if (password == null || password.isEmpty()) {
            preferences.remove(PASSWORD);
            return;
        }
        try {
            password = SplmmPreferences.convertToSaltedMD5Digest("spl", password);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("could.not.save.password"), LocalizationSupport.message("error"), 0);
            password = null;
        }
        preferences.put(PASSWORD, password);
    }

    public static String getPassword() {
        return preferences.get(PASSWORD, null);
    }

    public static void createUUID() {
        if (SplmmPreferences.getAnonymousUserName() != null) {
            SplmmPreferences.setUserName(SplmmPreferences.getAnonymousUserName());
        } else {
            String username;
            SplmmPreferences.setCredentialsValidated(false);
            Boolean created = false;
            do {
                UUID uuid;
                if ((username = (uuid = UUID.randomUUID()).toString()) == null || username.isEmpty()) continue;
                SplmmPreferences.setAnonymousUserName(username);
                created = SciPloreWebClient.createAnonymousUser(username);
            } while (!created.booleanValue());
            SplmmPreferences.setUserName(username);
        }
        SplmmPreferences.setPassword(null);
    }

    public static boolean validateBackupEntry() {
        return SplmmPreferences.validateBackupEntry(SplmmPreferences.getUserName(), SplmmPreferences.getPassword());
    }

    public static boolean validateBackupEntry(String username, String password) {
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            JOptionPane.showMessageDialog(null, LocalizationSupport.message("enter.user.name.and.password.to.backup.mindmaps"), LocalizationSupport.message("error"), 0);
            return false;
        }
        SplmmPreferences.setUserName(username);
        SplmmPreferences.setPassword(password);
        SplmmPreferences.setCredentialsValidated(false);
        return SciPloreWebClient.validateUserData(username, password).booleanValue();
        {
        }
    }

    private static String convertToSaltedMD5Digest(String salt, String plainText) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update((salt + plainText).getBytes());
        byte[] md5Digest = md5.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aMd5Digest : md5Digest) {
            stringBuilder.append(SplmmPreferences.toHexString(aMd5Digest));
        }
        return stringBuilder.toString();
    }

    public static String toHexString(byte b) {
        int value = (b & 0x7F) + (b < 0 ? 128 : 0);
        String ret = value < 16 ? "0" : "";
        ret = ret + Integer.toHexString(value).toUpperCase();
        return ret;
    }
}

