/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexString;
import bibtex.parser.BibtexParser;
import bibtex.parser.ParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Vector;

public class BibTex {
    private String key;
    private String path;
    private String title;

    public BibTex() {
    }

    public BibTex(String key, String path) {
        this.key = key;
        this.path = path;
    }

    public BibTex(String key, String path, String title) {
        this.key = key;
        this.path = path;
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String toString() {
        return this.key + " " + this.path;
    }

    public List<BibTex> readBibtex(File file) {
        Vector<BibTex> list = new Vector<BibTex>();
        if (file != null && file.exists() && file.getName().endsWith("bib")) {
            try {
                FileReader fileReader = new FileReader(file);
                BibtexFile bibtexFile = new BibtexFile();
                BibtexParser bibtexParser = new BibtexParser(false);
                bibtexParser.parse(bibtexFile, (Reader)fileReader);
                for (Object potentialBibtexEntry : bibtexFile.getEntries()) {
                    String[] paths;
                    BibtexEntry bibtexEntry;
                    BibtexString bibtexString;
                    if (!(potentialBibtexEntry instanceof BibtexEntry) || (bibtexString = (BibtexString)(bibtexEntry = (BibtexEntry)potentialBibtexEntry).getFieldValue("file")) == null) continue;
                    String files = bibtexString.getContent();
                    for (String path : paths = files.split(";")) {
                        if ((path = this.parsePath(path)) == null) continue;
                        if (this.isRelativePath(path)) {
                            path = this.CreateAbsolutePath(file, path);
                        } else if (path.contains("\\:")) {
                            path = path.replace("\\:", ":");
                        }
                        String title = this.parseTitle((BibtexString)bibtexEntry.getFieldValue("title"));
                        BibTex bib = new BibTex(bibtexEntry.getEntryKey(), path, title);
                        list.add(bib);
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private String parseTitle(BibtexString bibtexString) {
        if (bibtexString != null) {
            String title = bibtexString.getContent();
            title = title.replaceAll("\\{", "");
            title = title.replaceAll("\\}", "");
            title = title.replaceAll("\t", " ");
            title = title.replaceAll("\r\n", "");
            return title;
        }
        return null;
    }

    private String parsePath(String path) {
        if (path != null) {
            String fileType = "";
            if (path.contains(":")) {
                int splitIndex = path.lastIndexOf(":");
                fileType = path.substring(splitIndex + 1);
                path = path.substring(path.indexOf(":") + 1, splitIndex);
            } else if (path.contains(".")) {
                int splitIndex = path.lastIndexOf(".");
                fileType = path.substring(splitIndex + 1);
            }
            if (path.contains("backslash")) {
                path = this.parseMendely(path);
            }
            path = path.replaceAll("\r\n", "");
            path = path.replaceAll("\t", " ");
            path = path.replace("\\\\", "\\");
            if (fileType.equalsIgnoreCase("pdf")) {
                return path;
            }
        }
        return null;
    }

    private String parseMendely(String path) {
        path = path.replace("$\\backslash$", "");
        path = path.replace("\\", "");
        path = path.replace('/', '\\');
        return path;
    }

    private String CreateAbsolutePath(File file, String path) {
        String absolutePath = file.getAbsolutePath();
        absolutePath = absolutePath.replace(file.getName(), "");
        return absolutePath + path;
    }

    private boolean isRelativePath(String path) {
        return !path.contains(":");
    }
}

