/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import splmm.BookmarkMindMapNode;
import splmm.FileFilter.MonDirFileFilter;
import splmm.SciPloreUtils;

public abstract class SplmmAbstractAction
extends AbstractAction {
    public MindMapController controller;

    public SplmmAbstractAction(String name, MindMapController controller) {
        super(name);
        this.controller = controller;
    }

    protected boolean isLinkedToPDF(MindMapNode node) {
        String link = node.getLink();
        if (link == null) {
            return false;
        }
        if (!link.contains(".")) {
            return false;
        }
        String dateiendung = link.substring(link.lastIndexOf("."));
        Boolean hasPDFendung = dateiendung.substring(1).equalsIgnoreCase("pdf");
        if (hasPDFendung.booleanValue()) {
            File file = this.getFileFromLink(node);
            return file != null && file.exists();
        }
        return false;
    }

    protected boolean isLinkedToMonDirFile(MindMapNode node) {
        MonDirFileFilter filter = new MonDirFileFilter();
        String link = node.getLink();
        if (filter.accept(link)) {
            File file = this.getFileFromLink(node);
            return file != null && file.exists();
        }
        return false;
    }

    protected File getFileFromLink(MindMapNode node) {
        File pdfFile;
        block11: {
            pdfFile = new File(node.getLink());
            if (!pdfFile.isAbsolute()) {
                pdfFile = new File(this.controller.getModel().getFile().getParent() + "\\\\" + node.getLink());
                if (pdfFile.exists()) {
                    try {
                        return pdfFile.getCanonicalFile();
                    }
                    catch (Exception e) {
                        SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                        break block11;
                    }
                }
                try {
                    URI uri = new URI("file:/" + node.getLink());
                    pdfFile = new File(uri);
                    pdfFile = new File(this.controller.getModel().getFile().getParent() + pdfFile.getPath());
                    if (pdfFile.exists()) {
                        try {
                            return pdfFile.getCanonicalFile();
                        }
                        catch (IOException e) {
                            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                        }
                    }
                }
                catch (Exception e) {
                    SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
                }
            }
        }
        try {
            return pdfFile.getCanonicalFile();
        }
        catch (Exception e) {
            SciPloreUtils.logException(this.getClass().getName(), e, Level.WARNING);
            return null;
        }
    }

    protected void importBookmarks(MindMapNode node) {
        File pdfFile;
        if (this.isLinkedToPDF(node) && (pdfFile = this.getFileFromLink(node)).exists()) {
            MindMapNode bookmarkNode = BookmarkMindMapNode.getBookmarksFromFile(pdfFile, this.controller.getController());
            this.pasteBookmarks(node, bookmarkNode);
            this.controller.getSelectedView().getAttributeView().setOptimalColumnWidth();
        }
    }

    private void pasteBookmarks(MindMapNode node, MindMapNode bookmarkNode) {
        List bookmarks = bookmarkNode.getChildren();
        for (MindMapNode bookmark : bookmarks) {
            MindMapNode equalChild = this.getEqualChild(bookmark, node);
            if (equalChild == null) {
                this.controller.paste(bookmark, node);
                continue;
            }
            this.pasteBookmarks(equalChild, bookmark);
        }
        if (node.getSPLMMAttributes() != null) {
            node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        }
    }

    private MindMapNode getEqualChild(MindMapNode bookmark, MindMapNode node) {
        ListIterator childrenFolded = node.childrenFolded();
        while (childrenFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenFolded.next();
            if (!child.getText().equalsIgnoreCase(bookmark.getText())) continue;
            return child;
        }
        ListIterator childrenUnFolded = node.childrenUnfolded();
        while (childrenUnFolded.hasNext()) {
            MindMapNode child = (MindMapNode)childrenUnFolded.next();
            if (!child.getText().equalsIgnoreCase(bookmark.getText())) continue;
            return child;
        }
        return null;
    }
}

