/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.jibx.runtime.impl.XMLWriterBase;

public abstract class StreamWriterBase
extends XMLWriterBase {
    protected static final byte[] QUOT_ENTITY = new byte[]{38, 113, 117, 111, 116, 59};
    protected static final byte[] AMP_ENTITY = new byte[]{38, 97, 109, 112, 59};
    protected static final byte[] GT_ENTITY = new byte[]{38, 103, 116, 59};
    protected static final byte[] LT_ENTITY = new byte[]{38, 108, 116, 59};
    protected static final byte[] LT_CDATASTART = new byte[]{60, 33, 91, 67, 68, 65, 84, 65, 91};
    protected static final byte[] LT_CDATAEND = new byte[]{93, 93, 62};
    private static final int INITIAL_BUFFER_SIZE = 2048;
    private final String m_encodingName;
    private OutputStream m_stream;
    protected byte[] m_buffer;
    protected int m_fillOffset;
    protected byte[][] m_prefixBytes;
    protected byte[][][] m_extensionBytes;
    private boolean m_indent;
    private int m_indentBase;
    private int m_indentPerLevel;
    private byte[] m_indentSequence;

    public StreamWriterBase(String string, String[] stringArray) {
        super(stringArray);
        this.m_encodingName = string;
        this.m_prefixBytes = new byte[stringArray.length][];
        this.m_buffer = new byte[2048];
    }

    public StreamWriterBase(StreamWriterBase streamWriterBase, String[] stringArray) {
        this(streamWriterBase.m_encodingName, stringArray);
        this.m_stream = streamWriterBase.m_stream;
        this.m_indent = streamWriterBase.m_indent;
        this.m_indentBase = streamWriterBase.m_indentBase;
        this.m_indentPerLevel = streamWriterBase.m_indentPerLevel;
        this.m_indentSequence = streamWriterBase.m_indentSequence;
    }

    public void setOutput(OutputStream outputStream) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_stream = outputStream;
        this.reset();
    }

    public void setIndentSpaces(int n, String string, char c) {
        if (n >= 0) {
            try {
                if (string == null) {
                    string = "\n";
                }
                this.m_indent = true;
                byte[] byArray = string.getBytes(this.m_encodingName);
                this.m_indentBase = byArray.length;
                byte[] byArray2 = new String(new char[]{c}).getBytes(this.m_encodingName);
                this.m_indentPerLevel = n * byArray2.length;
                int n2 = this.m_indentBase + this.m_indentPerLevel * 10;
                this.m_indentSequence = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    if (i < string.length()) {
                        this.m_indentSequence[i] = byArray[i];
                        continue;
                    }
                    int n3 = (i - this.m_indentBase) % byArray2.length;
                    this.m_indentSequence[i] = byArray2[n3];
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("Encoding " + this.m_encodingName + " not recognized by JVM");
            }
        } else {
            this.m_indent = false;
        }
    }

    protected void makeSpace(int n) throws IOException {
        if (this.m_fillOffset + n > this.m_buffer.length) {
            this.m_stream.write(this.m_buffer, 0, this.m_fillOffset);
            this.m_fillOffset = 0;
            if (n > this.m_buffer.length) {
                this.m_buffer = new byte[Math.max(n, this.m_buffer.length * 2)];
            }
        }
    }

    protected void undefineNamespace(int n) {
        if (n < this.m_prefixBytes.length) {
            this.m_prefixBytes[n] = null;
        } else if (this.m_extensionBytes != null) {
            n -= this.m_prefixes.length;
            for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                int n2 = this.m_extensionBytes[i].length;
                if (n < n2) {
                    this.m_extensionBytes[i][n] = null;
                    break;
                }
                n -= n2;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    protected void writePrefix(int n) throws IOException {
        try {
            byte[] byArray = null;
            if (n < this.m_prefixBytes.length) {
                byArray = this.m_prefixBytes[n];
            } else if (this.m_extensionBytes != null) {
                n -= this.m_prefixes.length;
                for (int i = 0; i < this.m_extensionBytes.length; ++i) {
                    int n2 = this.m_extensionBytes[i].length;
                    if (n < n2) {
                        byArray = this.m_extensionBytes[i][n];
                        break;
                    }
                    n -= n2;
                }
            }
            this.makeSpace(byArray.length);
            System.arraycopy(byArray, 0, this.m_buffer, this.m_fillOffset, byArray.length);
            this.m_fillOffset += byArray.length;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("Namespace URI has not been declared.");
        }
    }

    protected int writeEntity(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.m_buffer, n, byArray.length);
        return n + byArray.length;
    }

    public void pushExtensionNamespaces(String[] stringArray) {
        super.pushExtensionNamespaces(stringArray);
        byte[][] byArrayArray = new byte[stringArray.length][];
        if (this.m_extensionBytes == null) {
            this.m_extensionBytes = new byte[][][]{byArrayArray};
        } else {
            int n = this.m_extensionBytes.length;
            byte[][][] byArrayArray2 = new byte[n + 1][][];
            System.arraycopy(this.m_extensionBytes, 0, byArrayArray2, 0, n);
            byArrayArray2[n] = byArrayArray;
            this.m_extensionBytes = byArrayArray2;
        }
    }

    public void popExtensionNamespaces() {
        super.popExtensionNamespaces();
        int n = this.m_extensionBytes.length;
        if (n == 1) {
            this.m_extensionBytes = null;
        } else {
            byte[][][] byArrayArray = new byte[n - 1][][];
            System.arraycopy(this.m_extensionBytes, 0, byArrayArray, 0, n - 1);
            this.m_extensionBytes = byArrayArray;
        }
    }

    public void indent(int n) throws IOException {
        if (this.m_indent) {
            int n2 = this.m_indentBase + (this.getNestingDepth() + n) * this.m_indentPerLevel;
            if (n2 > this.m_indentSequence.length) {
                int n3 = Math.max(n2, this.m_indentSequence.length * 2 - this.m_indentBase);
                byte[] byArray = new byte[n3];
                System.arraycopy(this.m_indentSequence, 0, byArray, 0, this.m_indentSequence.length);
                for (int i = this.m_indentSequence.length; i < n3; ++i) {
                    byArray[i] = byArray[this.m_indentBase];
                }
                this.m_indentSequence = byArray;
            }
            this.makeSpace(n2);
            System.arraycopy(this.m_indentSequence, 0, this.m_buffer, this.m_fillOffset, n2);
            this.m_fillOffset += n2;
        }
    }

    public void indent() throws IOException {
        this.indent(0);
    }

    public void flush() throws IOException {
        if (this.m_stream != null) {
            this.indent();
            this.m_stream.write(this.m_buffer, 0, this.m_fillOffset);
            this.m_fillOffset = 0;
            this.m_stream.flush();
        }
    }

    public void close() throws IOException {
        this.flush();
        if (this.m_stream != null) {
            this.m_stream.close();
            this.m_stream = null;
        }
    }

    public void reset() {
        super.reset();
        this.m_fillOffset = 0;
    }
}

