/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.randomaccess.RandomAccessViewport;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;

public class TTTable {
    private byte[] name;
    private int checksum = 0;
    private long offset;
    private long length;
    private TTFont font;
    private byte[] bytes;

    protected TTTable(TTFont tTFont, long l, long l2) {
        this.font = tTFont;
        this.offset = l;
        this.length = l2;
    }

    protected int createChecksum() throws IOException {
        IRandomAccess iRandomAccess = this.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            long l = iRandomAccess.getLength() / 4L;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while ((long)n5 < l) {
                n4 += iRandomAccess.read();
                n3 += iRandomAccess.read();
                n2 += iRandomAccess.read();
                n += iRandomAccess.read();
                ++n5;
            }
            int n6 = n + (n2 << 8) + (n3 << 16) + (n4 << 24);
            return n6;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public int getChecksum() {
        if (this.checksum == 0) {
            try {
                this.checksum = this.createChecksum();
            }
            catch (IOException iOException) {}
        }
        return this.checksum;
    }

    public TTFont getFont() {
        return this.font;
    }

    public long getLength() {
        return this.length;
    }

    public byte[] getName() {
        return this.name;
    }

    public long getOffset() {
        return this.offset;
    }

    public IRandomAccess getRandomAccess() throws IOException {
        if (this.bytes != null) {
            return new RandomAccessByteArray(this.bytes);
        }
        IRandomAccess iRandomAccess = this.getFont().getLocator().getRandomAccess();
        RandomAccessViewport randomAccessViewport = new RandomAccessViewport(iRandomAccess, this.getOffset(), this.getLength());
        return randomAccessViewport;
    }

    protected void setBytes(byte[] byArray) {
        this.bytes = byArray;
        this.checksum = 0;
        this.length = byArray.length;
        this.offset = 0L;
    }

    protected void setChecksum(int n) {
        this.checksum = n;
    }

    public void setName(byte[] byArray) {
        this.name = byArray;
    }

    public String toString() {
        return new String(this.getName());
    }
}

