/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;

public class COSObjectStream
extends COSBasedObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_ObjStm = COSName.constant("ObjStm");
    public static final COSName DK_First = COSName.constant("First");
    public static final COSName DK_N = COSName.constant("N");
    public static final COSName DK_Extends = COSName.constant("Extends");
    private COSStream stream;
    private int[][] objectTable;
    private IRandomAccess randomAccess;

    protected COSObjectStream(COSObject cOSObject) {
        super(((COSStream)cOSObject).getDict());
        this.stream = (COSStream)cOSObject;
    }

    public int getFirst() {
        return this.getFieldInt(DK_First, -1);
    }

    public int getN() {
        return this.getFieldInt(DK_N, 0);
    }

    private int getOffsetByIndex(int n, COSDocumentParser cOSDocumentParser) throws IOException {
        if (this.objectTable == null) {
            this.objectTable = new int[this.getN()][2];
            this.getRandomAccess().seek(0L);
            int n2 = 0;
            while (n2 < this.objectTable.length) {
                this.objectTable[n2][0] = cOSDocumentParser.readInteger(this.getRandomAccess(), true);
                this.objectTable[n2][1] = cOSDocumentParser.readInteger(this.getRandomAccess(), true);
                ++n2;
            }
        }
        return this.objectTable[n][1];
    }

    protected IRandomAccess getRandomAccess() throws IOException {
        if (this.randomAccess == null) {
            this.randomAccess = new RandomAccessByteArray(this.stream.getDecodedBytes());
        }
        return this.randomAccess;
    }

    public COSObject loadObject(int n, COSDocumentParser cOSDocumentParser) throws IOException, COSLoadException {
        if (n >= this.getN()) {
            return null;
        }
        int n2 = this.getOffsetByIndex(n, cOSDocumentParser);
        this.getRandomAccess().seek((long)(this.getFirst() + n2));
        return (COSObject)cOSDocumentParser.parseElement(this.getRandomAccess());
    }

    public void parse(int n, COSDocumentParser cOSDocumentParser) throws IOException, COSLoadException {
        if (n >= this.getN()) {
            return;
        }
        int n2 = this.getOffsetByIndex(n, cOSDocumentParser);
        this.getRandomAccess().seek((long)(this.getFirst() + n2));
        cOSDocumentParser.parseElement(this.getRandomAccess());
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }
    }
}

