/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.postscript;

import de.intarsys.pdf.postscript.Token;

public class ParseException
extends Exception {
    public Token currentToken;
    protected String eol = System.getProperty("line.separator", "\n");
    public int[][] expectedTokenSequences;
    protected boolean specialConstructor;
    public String[] tokenImage;

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    public ParseException(Throwable throwable) {
        super(throwable);
    }

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    protected String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (n < string.length()) {
            switch (string.charAt(n)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    break;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    break;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    break;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    break;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    break;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    break;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    break;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    break;
                }
                default: {
                    char c = string.charAt(n);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u" + string2.substring(string2.length() - 4, string2.length()));
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (n2 < this.expectedTokenSequences.length) {
            if (n < this.expectedTokenSequences[n2].length) {
                n = this.expectedTokenSequences[n2].length;
            }
            int n3 = 0;
            while (n3 < this.expectedTokenSequences[n2].length) {
                stringBuilder.append(this.tokenImage[this.expectedTokenSequences[n2][n3]]).append(" ");
                ++n3;
            }
            if (this.expectedTokenSequences[n2][this.expectedTokenSequences[n2].length - 1] != 0) {
                stringBuilder.append("...");
            }
            stringBuilder.append(this.eol).append("    ");
            ++n2;
        }
        String string = "Encountered \"";
        Token token = this.currentToken.next;
        int n4 = 0;
        while (n4 < n) {
            if (n4 != 0) {
                string = String.valueOf(string) + " ";
            }
            if (token.kind == 0) {
                string = String.valueOf(string) + this.tokenImage[0];
                break;
            }
            string = String.valueOf(string) + this.add_escapes(token.image);
            token = token.next;
            ++n4;
        }
        string = String.valueOf(string) + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        string = String.valueOf(string) + "." + this.eol;
        string = this.expectedTokenSequences.length == 1 ? String.valueOf(string) + "Was expecting:" + this.eol + "    " : String.valueOf(string) + "Was expecting one of:" + this.eol + "    ";
        string = String.valueOf(string) + stringBuilder.toString();
        return string;
    }
}

