/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.CMapBFCharCodeMap;
import de.intarsys.pdf.font.CMapBFCharNameMap;
import de.intarsys.pdf.font.CMapBFRangeCodeMap;
import de.intarsys.pdf.font.CMapBFRangeNameMap;
import de.intarsys.pdf.font.CMapCIDCharCodeMap;
import de.intarsys.pdf.font.CMapCIDRangeCodeMap;
import de.intarsys.pdf.font.CMapCharMap;
import de.intarsys.pdf.font.CMapMap;
import de.intarsys.pdf.font.CMapNotDefRangeMap;
import de.intarsys.pdf.font.CMapOperator;
import de.intarsys.pdf.font.CMapRange;
import de.intarsys.pdf.font.CMapRangeMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class StreamBasedCMap
extends CMap {
    public static final COSName DK_CIDSystemInfo = COSName.constant("CIDSystemInfo");
    public static final COSName DK_CMapName = COSName.constant("CMapName");
    public static final COSName DK_UseCMap = COSName.constant("UseCMap");
    public static final COSName DK_WMode = COSName.constant("WMode");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private Map<COSName, COSObject> definitions = new HashMap<COSName, COSObject>();
    private List maps = new ArrayList();
    private List notdefs = new ArrayList();
    private CMapRange[][] ranges = new CMapRange[4][0];

    protected StreamBasedCMap(COSObject cOSObject) {
        super(cOSObject);
    }

    protected void addDefinition(COSName cOSName, COSObject cOSObject) {
        this.definitions.put(cOSName, cOSObject);
    }

    protected void addMap(CMapMap cMapMap) {
        this.maps.add(cMapMap);
    }

    protected void addNotdef(CMapMap cMapMap) {
        this.notdefs.add(cMapMap);
    }

    protected void addRange(CMapRange cMapRange) {
        int n = cMapRange.getByteCount();
        CMapRange[] cMapRangeArray = this.ranges[n];
        CMapRange[] cMapRangeArray2 = new CMapRange[cMapRangeArray.length + 1];
        System.arraycopy(cMapRangeArray, 0, cMapRangeArray2, 0, cMapRangeArray.length);
        cMapRangeArray2[cMapRangeArray.length] = cMapRange;
        this.ranges[n] = cMapRangeArray2;
    }

    protected boolean checkPrefix(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < this.ranges.length) {
            CMapRange[] cMapRangeArray = this.ranges[n2];
            int n3 = 0;
            while (n3 < cMapRangeArray.length) {
                CMapRange cMapRange = cMapRangeArray[n3];
                if (cMapRange.checkPrefix(byArray, n)) {
                    return true;
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    protected boolean checkRange(byte[] byArray, int n) {
        if (n >= this.ranges.length) {
            return false;
        }
        CMapRange[] cMapRangeArray = this.ranges[n];
        int n2 = 0;
        while (n2 < cMapRangeArray.length) {
            CMapRange cMapRange = cMapRangeArray[n2];
            if (cMapRange.checkRange(byArray, n)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void do_beginbfchar(CSOperation cSOperation) {
    }

    protected void do_beginbfrange(CSOperation cSOperation) {
    }

    protected void do_begincidchar(CSOperation cSOperation) {
    }

    protected void do_begincidrange(CSOperation cSOperation) {
    }

    protected void do_begincmap(CSOperation cSOperation) {
    }

    protected void do_begincodespacerange(CSOperation cSOperation) {
    }

    protected void do_beginnotdefchar(CSOperation cSOperation) {
    }

    protected void do_beginnotdefrange(CSOperation cSOperation) {
    }

    protected void do_def(CSOperation cSOperation) {
        COSDictionary cOSDictionary;
        Iterator iterator = cSOperation.getOperands();
        COSObject cOSObject = COSNull.NULL;
        if (iterator.hasNext()) {
            cOSObject = (COSObject)iterator.next();
        }
        if ((cOSDictionary = cOSObject.asDictionary()) == null) {
            COSName cOSName = cOSObject.asName();
            if (cOSName == null) {
                return;
            }
            COSObject cOSObject2 = COSNull.NULL;
            if (iterator.hasNext()) {
                cOSObject2 = (COSObject)iterator.next();
            }
            this.addDefinition(cOSName, cOSObject2);
        } else {
            Iterator iterator2 = cOSDictionary.entryIterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator2.next();
                COSName cOSName = (COSName)entry.getKey();
                COSObject cOSObject3 = (COSObject)entry.getValue();
                this.addDefinition(cOSName, cOSObject3);
            }
        }
    }

    protected void do_endbfchar(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            COSObject cOSObject = (COSObject)iterator.next();
            CMapCharMap cMapCharMap = cOSObject instanceof COSString ? new CMapBFCharCodeMap(cOSString.byteValue(), ((COSString)cOSObject).byteValue()) : new CMapBFCharNameMap(cOSString.byteValue(), (COSName)cOSObject);
            this.addMap(cMapCharMap);
        }
    }

    protected void do_endbfrange(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            COSString cOSString2 = (COSString)iterator.next();
            COSObject cOSObject = (COSObject)iterator.next();
            CMapRangeMap cMapRangeMap = cOSObject instanceof COSString ? new CMapBFRangeCodeMap(cOSString.byteValue(), cOSString2.byteValue(), ((COSString)cOSObject).byteValue()) : new CMapBFRangeNameMap(cOSString.byteValue(), cOSString2.byteValue(), (COSArray)cOSObject);
            this.addMap(cMapRangeMap);
        }
    }

    protected void do_endcidchar(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            COSInteger cOSInteger = (COSInteger)iterator.next();
            CMapCIDCharCodeMap cMapCIDCharCodeMap = new CMapCIDCharCodeMap(cOSString.byteValue(), cOSInteger.intValue());
            this.addMap(cMapCIDCharCodeMap);
        }
    }

    protected void do_endcidrange(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            COSString cOSString2 = (COSString)iterator.next();
            COSInteger cOSInteger = (COSInteger)iterator.next();
            CMapCIDRangeCodeMap cMapCIDRangeCodeMap = new CMapCIDRangeCodeMap(cOSString.byteValue(), cOSString2.byteValue(), cOSInteger.intValue());
            this.addMap(cMapCIDRangeCodeMap);
        }
    }

    protected void do_endcmap(CSOperation cSOperation) {
    }

    protected void do_endcodespacerange(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            if (!iterator.hasNext()) break;
            COSString cOSString2 = (COSString)iterator.next();
            CMapRange cMapRange = new CMapRange(cOSString.byteValue(), cOSString2.byteValue());
            this.addRange(cMapRange);
        }
    }

    protected void do_endnotdefchar(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            COSInteger cOSInteger = (COSInteger)iterator.next();
            CMapCIDCharCodeMap cMapCIDCharCodeMap = new CMapCIDCharCodeMap(cOSString.byteValue(), cOSInteger.intValue());
            this.addNotdef(cMapCIDCharCodeMap);
        }
    }

    protected void do_endnotdefrange(CSOperation cSOperation) {
        Iterator iterator = cSOperation.getOperands();
        while (iterator.hasNext()) {
            COSString cOSString = (COSString)iterator.next();
            COSString cOSString2 = (COSString)iterator.next();
            COSInteger cOSInteger = (COSInteger)iterator.next();
            CMapNotDefRangeMap cMapNotDefRangeMap = new CMapNotDefRangeMap(cOSString.byteValue(), cOSString2.byteValue(), cOSInteger.intValue());
            this.addNotdef(cMapNotDefRangeMap);
        }
    }

    protected void do_usecmap(CSOperation cSOperation) {
    }

    protected void do_usefont(CSOperation cSOperation) {
    }

    public int getDecoded(int n) {
        for (CMapMap cMapMap : this.maps) {
            int n2 = cMapMap.toCID(n);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public COSObject getDefinition(COSName cOSName) {
        COSObject cOSObject = this.definitions.get(cOSName);
        if (cOSObject == null) {
            return COSNull.NULL;
        }
        return cOSObject;
    }

    public int getEncoded(int n) {
        for (CMapMap cMapMap : this.maps) {
            int n2 = cMapMap.toCodepoint(n);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public int getNextDecoded(InputStream inputStream) throws IOException {
        return this.getDecoded(this.getNextEncoded(inputStream));
    }

    public int getNextEncoded(InputStream inputStream) throws IOException {
        int n;
        inputStream.mark(4);
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            n = inputStream.read();
            if (n == -1) {
                return -1;
            }
            byArray[n2++] = (byte)n;
            if (!this.checkRange(byArray, n2)) continue;
            return StreamBasedCMap.toInt(byArray, 0, n2);
        }
        inputStream.reset();
        byArray = new byte[4];
        n2 = 0;
        while (n2 < 4) {
            inputStream.mark(1);
            n = inputStream.read();
            if (n == -1) {
                return -1;
            }
            byArray[n2++] = (byte)n;
            if (this.checkPrefix(byArray, n2)) continue;
            inputStream.reset();
            return StreamBasedCMap.toInt(byArray, 0, --n2);
        }
        return -1;
    }

    protected void initializeFromContent(CSContent cSContent) {
        int n = cSContent.size();
        int n2 = 0;
        while (n2 < n) {
            CSOperation cSOperation = cSContent.getOperation(n2);
            this.initializeFromOperation(cSOperation);
            ++n2;
        }
    }

    protected void initializeFromOperation(CSOperation cSOperation) {
        if (cSOperation.matchesOperator(CMapOperator.CMO_beginbfchar)) {
            this.do_beginbfchar(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_beginbfrange)) {
            this.do_beginbfrange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_begincidchar)) {
            this.do_begincidchar(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_begincidrange)) {
            this.do_begincidrange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_begincmap)) {
            this.do_begincmap(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_begincodespacerange)) {
            this.do_begincodespacerange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_beginnotdefchar)) {
            this.do_beginnotdefchar(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_beginnotdefrange)) {
            this.do_beginnotdefrange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endbfchar)) {
            this.do_endbfchar(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endbfrange)) {
            this.do_endbfrange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endcidchar)) {
            this.do_endcidchar(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endcidrange)) {
            this.do_endcidrange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endcmap)) {
            this.do_endcmap(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endcodespacerange)) {
            this.do_endcodespacerange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endnotdefchar)) {
            this.do_endnotdefchar(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_endnotdefrange)) {
            this.do_endnotdefrange(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_usecmap)) {
            this.do_usecmap(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_usefont)) {
            this.do_usefont(cSOperation);
        } else if (cSOperation.matchesOperator(CMapOperator.CMO_def)) {
            this.do_def(cSOperation);
        }
    }

    public void putNextDecoded(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public void putNextEncoded(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n & 0xFF);
    }

    public static class MetaClass
    extends CMap.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }
    }
}

