/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.GlyphNameMap;
import de.intarsys.pdf.font.CMapRangeMap;
import java.util.Iterator;

public class CMapBFRangeNameMap
extends CMapRangeMap {
    private final COSArray names;
    private final int[] destinationCodes;

    public CMapBFRangeNameMap(byte[] byArray, byte[] byArray2, COSArray cOSArray) {
        super(byArray, byArray2);
        this.names = cOSArray;
        this.destinationCodes = new int[cOSArray.size()];
        int n = 0;
        Iterator iterator = cOSArray.iterator();
        while (iterator.hasNext()) {
            COSName cOSName = ((COSObject)iterator.next()).asName();
            this.destinationCodes[n] = cOSName == null ? 0 : GlyphNameMap.Standard.getUnicode(((COSObject)cOSName).stringValue());
            ++n;
        }
    }

    public int toCID(int n) {
        int n2 = n - this.start;
        if (n2 < 0 || n2 >= this.names.size()) {
            return 0;
        }
        return this.destinationCodes[n2];
    }

    public int toCodepoint(int n) {
        int n2 = 0;
        while (n2 < this.destinationCodes.length) {
            if (n == this.destinationCodes[n2]) {
                return this.start + n2;
            }
            ++n2;
        }
        return 0;
    }
}

