/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.security.MessageDigest;
import java.util.Iterator;

public class COSTrailer
extends COSBasedObject {
    public static final COSName DK_Info = COSName.constant("Info");
    public static final COSName DK_Prev = COSName.constant("Prev");
    public static final COSName DK_Root = COSName.constant("Root");
    public static final COSName DK_Size = COSName.constant("Size");
    public static final COSName DK_Encrypt = COSName.constant("Encrypt");
    public static final COSName DK_ID = COSName.constant("ID");
    public static final COSName DK_XRefStm = COSName.constant("XRefStm");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private COSCatalog cachedCatalog;

    protected COSTrailer(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSString cosGetDynamicFileID() {
        COSArray cOSArray = this.cosGetField(DK_ID).asArray();
        if (cOSArray == null || cOSArray.size() < 2) {
            return null;
        }
        return (COSString)cOSArray.get(1);
    }

    public COSDictionary cosGetEncryption() {
        return this.cosGetField(DK_Encrypt).asDictionary();
    }

    public COSArray cosGetFileID() {
        return this.cosGetField(DK_ID).asArray();
    }

    public COSArray cosGetID() {
        return this.cosGetField(DK_ID).asArray();
    }

    public COSString cosGetPermanentFileID() {
        COSArray cOSArray = this.cosGetField(DK_ID).asArray();
        if (cOSArray == null || cOSArray.size() == 0) {
            return null;
        }
        return (COSString)cOSArray.get(0);
    }

    public void cosSetEncryption(COSDictionary cOSDictionary) {
        this.cosSetField(DK_Encrypt, cOSDictionary);
    }

    protected byte[] createFileID() {
        ILocator iLocator;
        COSDocument cOSDocument;
        block8: {
            block7: {
                cOSDocument = this.cosGetDoc();
                if (cOSDocument != null) break block7;
                return null;
            }
            iLocator = cOSDocument.getLocator();
            if (iLocator != null) break block8;
            return null;
        }
        try {
            IRandomAccess iRandomAccess = cOSDocument.stGetDoc().getRandomAccess();
            if (iRandomAccess == null) {
                iRandomAccess = new RandomAccessByteArray(StringTools.toByteArray((String)"DummyValue"));
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            long l = System.currentTimeMillis();
            messageDigest.update(String.valueOf(l).getBytes());
            messageDigest.update(iLocator.getFullName().getBytes());
            messageDigest.update(String.valueOf(iRandomAccess.getLength()).getBytes());
            COSInfoDict cOSInfoDict = this.getInfoDict();
            if (cOSInfoDict != null) {
                Iterator iterator = cOSInfoDict.cosGetDict().iterator();
                while (iterator.hasNext()) {
                    COSObject cOSObject = (COSObject)iterator.next();
                    messageDigest.update(cOSObject.stringValue().getBytes());
                }
            }
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    public COSInfoDict getInfoDict() {
        return (COSInfoDict)COSInfoDict.META.createFromCos(this.cosGetField(DK_Info).asDictionary());
    }

    public int getPrev() {
        return this.getFieldInt(DK_Prev, -1);
    }

    public COSCatalog getRoot() {
        if (this.cachedCatalog == null) {
            this.cachedCatalog = (COSCatalog)COSCatalog.META.createFromCos(this.cosGetField(DK_Root));
        }
        return this.cachedCatalog;
    }

    public int getSize() {
        return this.getFieldInt(DK_Size, -1);
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setRoot((COSCatalog)COSCatalog.META.createNew());
        this.setInfoDict((COSInfoDict)COSInfoDict.META.createNew());
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedCatalog = null;
    }

    public void setInfoDict(COSInfoDict cOSInfoDict) {
        this.setFieldObject(DK_Info, cOSInfoDict);
    }

    public void setRoot(COSCatalog cOSCatalog) {
        this.setFieldObject(DK_Root, cOSCatalog);
    }

    public void updateFileID() {
        COSArray cOSArray = this.cosGetField(DK_ID).asArray();
        if (cOSArray == null || cOSArray.size() == 0) {
            cOSArray = COSArray.create();
            this.cosSetField(DK_ID, cOSArray);
            byte[] byArray = this.createFileID();
            COSString cOSString = COSString.create(byArray);
            cOSArray.add(cOSString);
            cOSArray.add(cOSString);
        } else {
            byte[] byArray = this.createFileID();
            COSString cOSString = COSString.create(byArray);
            if (cOSArray.size() < 2) {
                cOSArray.add(cOSString);
            } else {
                cOSArray.set(1, cOSString);
            }
        }
    }

    public static class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }
    }
}

