/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.annotation;

import de.intarsys.pdf.app.annotation.IAnnotationFactory;
import de.intarsys.pdf.app.annotation.IAnnotationOutlet;
import de.intarsys.pdf.cos.COSName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import sun.misc.Service;

public class StandardAnnotationOutlet
implements IAnnotationOutlet {
    private Map<COSName, IAnnotationFactory> instances = new HashMap<COSName, IAnnotationFactory>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected StandardAnnotationOutlet() {
    }

    protected IAnnotationFactory[] findProviders() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ArrayList<IAnnotationFactory> arrayList = new ArrayList<IAnnotationFactory>();
        Iterator iterator = Service.providers(IAnnotationFactory.class, (ClassLoader)classLoader);
        while (iterator.hasNext()) {
            try {
                arrayList.add((IAnnotationFactory)iterator.next());
            }
            catch (Throwable throwable) {}
        }
        return arrayList.toArray(new IAnnotationFactory[arrayList.size()]);
    }

    public synchronized IAnnotationFactory[] getAnnotationFactories() {
        this.init();
        return this.instances.values().toArray(new IAnnotationFactory[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAnnotationFactory[] iAnnotationFactoryArray = this.findProviders();
        int n = 0;
        while (n < iAnnotationFactoryArray.length) {
            IAnnotationFactory iAnnotationFactory = iAnnotationFactoryArray[n];
            this.registerAnnotationFactory(iAnnotationFactory);
            ++n;
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    public synchronized IAnnotationFactory lookupAnnotationFactory(COSName cOSName) {
        this.init();
        return this.instances.get(cOSName);
    }

    public synchronized void registerAnnotationFactory(IAnnotationFactory iAnnotationFactory) {
        this.instances.put(iAnnotationFactory.getAnnotationType(), iAnnotationFactory);
    }

    public void setLookupProviders(boolean bl) {
        this.lookupProviders = bl;
    }

    public synchronized void unregisterAnnotationFactory(IAnnotationFactory iAnnotationFactory) {
        this.instances.remove(iAnnotationFactory.getAnnotationType());
    }
}

