/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.acroform;

import de.intarsys.pdf.app.acroform.IFormHandler;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonFormHandler
implements IFormHandler {
    private PDDocument doc;
    private PDAcroForm acroForm;
    private boolean validate = true;
    private boolean calculate = true;

    protected CommonFormHandler(PDDocument pDDocument) {
        this.doc = pDDocument;
        if (pDDocument.getAcroForm() == null) {
            throw new IllegalArgumentException("doc has no form");
        }
        this.acroForm = this.getDoc().getAcroForm();
    }

    protected abstract void basicRecalculate(PDAcroFormField var1);

    protected abstract void basicSetFieldValue(PDAcroFormField var1, List var2);

    protected abstract void basicSetFieldValue(PDAcroFormField var1, PDSignature var2);

    protected abstract void basicSetFieldValue(PDAcroFormField var1, String var2);

    protected abstract void doResetFields(List var1);

    protected PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public String getFieldValue(Object object) {
        PDAcroFormField pDAcroFormField = this.marshalField(object);
        return pDAcroFormField.getValueString();
    }

    public boolean isCalculate() {
        return this.calculate;
    }

    public boolean isValidate() {
        return this.validate;
    }

    protected PDAcroFormField marshalField(Object object) {
        if (object instanceof PDWidgetAnnotation) {
            return ((PDWidgetAnnotation)object).getAcroFormField();
        }
        if (object instanceof PDAcroFormField) {
            return (PDAcroFormField)object;
        }
        if (object instanceof COSString) {
            object = ((COSString)object).stringValue();
        }
        if (object instanceof COSName) {
            object = ((COSName)object).stringValue();
        }
        if (object instanceof String) {
            return this.getAcroForm().getField((String)object);
        }
        throw new IllegalArgumentException("fieldRef of unknown type '" + object.getClass().getName() + "'");
    }

    public void recalculate() {
        this.basicRecalculate(null);
    }

    public void recalculate(Object object) {
        this.basicRecalculate(this.marshalField(object));
    }

    public void resetFields() {
        this.doResetFields(this.getAcroForm().collectLeafFields());
    }

    public void resetFields(List list, boolean bl) {
        ArrayList<PDAcroFormField> arrayList = new ArrayList<PDAcroFormField>();
        for (PDAcroFormField pDAcroFormField : this.getAcroForm().collectLeafFields()) {
            if (list.contains(pDAcroFormField.getQualifiedName())) {
                if (bl) continue;
                arrayList.add(pDAcroFormField);
                continue;
            }
            if (!bl) continue;
            arrayList.add(pDAcroFormField);
        }
        this.doResetFields(arrayList);
    }

    public void setCalculate(boolean bl) {
        this.calculate = bl;
    }

    public void setFieldValue(Object object, Object object2) {
        if (object2 instanceof List) {
            this.basicSetFieldValue(this.marshalField(object), (List)object2);
        } else if (object2 instanceof String) {
            this.basicSetFieldValue(this.marshalField(object), (String)object2);
        } else if (object2 instanceof COSName) {
            this.basicSetFieldValue(this.marshalField(object), ((COSName)object2).stringValue());
        } else if (object2 instanceof COSString) {
            this.basicSetFieldValue(this.marshalField(object), ((COSString)object2).stringValue());
        } else if (object2 instanceof COSNull) {
            this.basicSetFieldValue(this.marshalField(object), (String)null);
        } else if (object2 instanceof PDSignature) {
            this.basicSetFieldValue(this.marshalField(object), (PDSignature)object2);
        }
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }
}

