#include "VariableListDeltaTracker.h"

using namespace RakNet;

VariableListDeltaTracker::VariableListDeltaTracker() {nextWriteIndex=0;}
VariableListDeltaTracker::~VariableListDeltaTracker()
{
	unsigned int i;
	for (i=0; i < variableList.Size(); i++)
		rakFree_Ex(variableList[i].lastData,__FILE__,__LINE__);
}

// Call before using a series of WriteVar
void VariableListDeltaTracker::StartWrite(void) {nextWriteIndex=0;}

void VariableListDeltaTracker::FlagDirtyFromBitArray(unsigned char *bArray)
{
	unsigned short readOffset=0;
	for (readOffset=0; readOffset < variableList.Size(); readOffset++)
	{
		bool result = ( bArray[ readOffset >> 3 ] & ( 0x80 >> ( readOffset & 7 ) ) ) !=0;

		if (result==true)
			variableList[readOffset].isDirty=true;
	}
}
VariableListDeltaTracker::VariableLastValueNode::VariableLastValueNode()
{
	lastData=0;
}
VariableListDeltaTracker::VariableLastValueNode::VariableLastValueNode(const unsigned char *data, int _byteLength)
{
	lastData=(char*) rakMalloc_Ex(_byteLength,__FILE__,__LINE__);
	memcpy(lastData,data,_byteLength);
	byteLength=_byteLength;
	isDirty=false;
}
VariableListDeltaTracker::VariableLastValueNode::~VariableLastValueNode()
{
}