#ifndef __LOBBY_PC_TYPES_H
#define __LOBBY_PC_TYPES_H

typedef unsigned int LobbyClientUserId;
typedef unsigned int LobbyClientRoomId;
typedef unsigned int LobbyClientTitleId;
typedef unsigned int ScoreboardId;
typedef unsigned int EmailId;
typedef unsigned int ClanId;
typedef unsigned int ClanBoardPostId;

enum LobbyNetworkOperations
{
	LOBBY_MSGID_LOGIN,
	LOBBY_MSGID_SET_TITLE_LOGIN_ID,
	LOBBY_MSGID_LOGOFF,
	LOBBY_MSGID_REGISTER_ACCOUNT,
	LOBBY_MSGID_UPDATE_ACCOUNT,
	LOBBY_MSGID_CHANGE_HANDLE,
	LOBBY_MSGID_RETRIEVE_PASSWORD_RECOVERY_QUESTION,
	LOBBY_MSGID_RETRIEVE_PASSWORD,
	LOBBY_MSGID_DOWNLOAD_FRIENDS,
	LOBBY_MSGID_SEND_ADD_FRIEND_INVITE,
	LOBBY_MSGID_ACCEPT_ADD_FRIEND_INVITE,
	LOBBY_MSGID_DECLINE_ADD_FRIEND_INVITE,
	LOBBY_MSGID_NOTIFY_FRIEND_STATUS,
	LOBBY_MSGID_DOWNLOAD_IGNORE_LIST,
	LOBBY_MSGID_UPDATE_IGNORE_LIST,
	LOBBY_MSGID_REMOVE_FROM_IGNORE_LIST,
	LOBBY_MSGID_DOWNLOAD_EMAILS,
	LOBBY_MSGID_SEND_EMAIL,
	LOBBY_MSGID_DELETE_EMAIL,
	LOBBY_MSGID_UPDATE_EMAIL_STATUS,
	LOBBY_MSGID_INCOMING_EMAIL,
	LOBBY_MSGID_SEND_IM,
	LOBBY_MSGID_RECEIVE_IM, // AdditionalInfo: sender handle, 0, message body
	LOBBY_MSGID_CREATE_ROOM,
	LOBBY_MSGID_DOWNLOAD_ROOMS,
	LOBBY_MSGID_LEAVE_ROOM,
	LOBBY_MSGID_JOIN_ROOM,
	LOBBY_MSGID_JOIN_ROOM_BY_FILTER,
	LOBBY_MSGID_ROOM_CHAT,
	LOBBY_MSGID_INVITE_TO_ROOM,
	LOBBY_MSGID_SET_READY_TO_PLAY_STATUS,
	LOBBY_MSGID_KICK_ROOM_MEMBER,
	LOBBY_MSGID_SET_INVITE_ONLY,
	LOBBY_MSGID_SET_ROOM_ALLOW_SPECTATORS,
	LOBBY_MSGID_CHANGE_NUM_SLOTS,
	LOBBY_MSGID_GRANT_MODERATOR,
	LOBBY_MSGID_START_GAME,
	LOBBY_MSGID_SUBMIT_MATCH,
	LOBBY_MSGID_DOWNLOAD_RATING,
	LOBBY_MSGID_QUICK_MATCH,
	LOBBY_MSGID_CANCEL_QUICK_MATCH,
	LOBBY_MSGID_DOWNLOAD_ACTION_HISTORY,
	LOBBY_MSGID_ADD_TO_ACTION_HISTORY,
	LOBBY_MSGID_NOTIFY_ROOM_MEMBER_DROP,
	LOBBY_MSGID_NOTIFY_ROOM_MEMBER_JOIN,
	LOBBY_MSGID_NOTIFY_ROOM_MEMBER_READY_STATE,
	LOBBY_MSGID_NOTIFY_ROOM_NEW_MODERATOR,
	LOBBY_MSGID_NOTIFY_ROOM_SET_INVITE_ONLY,
	LOBBY_MSGID_NOTIFY_ROOM_SET_ALLOW_SPECTATORS,
	LOBBY_MSGID_NOTIFY_ROOM_CHANGE_NUM_SLOTS,
	LOBBY_MSGID_NOTIFY_ROOM_CHAT,
	LOBBY_MSGID_NOTIFY_ROOM_INVITE,
	LOBBY_MSGID_NOTIFY_ROOM_DESTROYED,
	LOBBY_MSGID_NOTIFY_KICKED_OUT_OF_ROOM,
	LOBBY_MSGID_NOTIFY_QUICK_MATCH_TIMEOUT,
	LOBBY_MSGID_NOTIFY_START_GAME,
	LOBBY_MSGID_NOTIFY_ADD_FRIEND_RESPONSE,
	LOBBY_MSGID_NOTIFY_CLAN_DISSOLVED,
	LOBBY_MSGID_NOTIFY_LEAVE_CLAN,
	LOBBY_MSGID_NOTIFY_SEND_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_NOTIFY_WITHDRAW_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_NOTIFY_ACCEPT_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_NOTIFY_REJECT_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_NOTIFY_SEND_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_NOTIFY_WITHDRAW_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_NOTIFY_ACCEPT_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_NOTIFY_REJECT_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_NOTIFY_SET_CLAN_MEMBER_RANK,
	LOBBY_MSGID_NOTIFY_CLAN_MEMBER_KICKED,
	LOBBY_MSGID_NOTIFY_CLAN_MEMBER_UNBLACKLISTED,
	LOBBY_MSGID_CREATE_CLAN,
	LOBBY_MSGID_CHANGE_CLAN_HANDLE,
	LOBBY_MSGID_LEAVE_CLAN,
	LOBBY_MSGID_DOWNLOAD_CLANS,
	LOBBY_MSGID_SEND_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_WITHDRAW_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_ACCEPT_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_REJECT_CLAN_JOIN_INVITATION,
	LOBBY_MSGID_SEND_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_WITHDRAW_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_ACCEPT_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_REJECT_CLAN_MEMBER_JOIN_REQUEST,
	LOBBY_MSGID_DOWNLOAD_BY_CLAN_MEMBER_STATUS,
	LOBBY_MSGID_SET_CLAN_MEMBER_RANK,
	LOBBY_MSGID_CLAN_KICK_AND_BLACKLIST_USER,
	LOBBY_MSGID_CLAN_UNBLACKLIST_USER,
	LOBBY_MSGID_ADD_POST_TO_CLAN_BOARD,
	LOBBY_MSGID_REMOVE_POST_FROM_CLAN_BOARD,
	LOBBY_MSGID_DOWNLOAD_MY_CLAN_BOARDS,
	LOBBY_MSGID_DOWNLOAD_CLAN_BOARD,
	LOBBY_MSGID_DOWNLOAD_CLAN_MEMBER,
	LOBBY_MSGID_VALIDATE_USER_KEY,
};

#endif
