/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.ThreadState;
import org.python.core.TraceFunction;
import org.python.util.BreakTraceFunction;
import org.python.util.PythonInterpreter;

public class InteractiveInterpreter
extends PythonInterpreter {
    public StringBuffer buffer = new StringBuffer();
    public String filename = "<stdin>";

    public InteractiveInterpreter() {
        this(null);
    }

    public InteractiveInterpreter(PyObject locals) {
        this(locals, null);
    }

    public InteractiveInterpreter(PyObject locals, PySystemState systemState) {
        super(locals, systemState);
        this.cflags = new CompilerFlags();
    }

    public boolean runsource(String source) {
        return this.runsource(source, "<input>", "single");
    }

    public boolean runsource(String source, String filename) {
        return this.runsource(source, filename, "single");
    }

    public boolean runsource(String source, String filename, String symbol) {
        PyObject code;
        try {
            code = Py.compile_command_flags(source, filename, symbol, this.cflags, true);
        }
        catch (PyException exc) {
            if (Py.matchException(exc, Py.SyntaxError)) {
                this.showexception(exc);
                return false;
            }
            if (Py.matchException(exc, Py.ValueError) || Py.matchException(exc, Py.OverflowError)) {
                this.showexception(exc);
                return false;
            }
            throw exc;
        }
        if (code == Py.None) {
            return true;
        }
        this.runcode(code);
        return false;
    }

    public void runcode(PyObject code) {
        try {
            this.exec(code);
        }
        catch (PyException exc) {
            if (Py.matchException(exc, Py.SystemExit)) {
                throw exc;
            }
            this.showexception(exc);
        }
    }

    public void showexception(PyException exc) {
        Py.printException(exc);
    }

    public void write(String data) {
        Py.stderr.write(data);
    }

    public void resetbuffer() {
        this.buffer.setLength(0);
    }

    public void interrupt(ThreadState ts) {
        BreakTraceFunction breaker = new BreakTraceFunction();
        TraceFunction oldTrace = ts.systemState.tracefunc;
        ts.systemState.tracefunc = breaker;
        if (ts.frame != null) {
            ts.frame.tracefunc = breaker;
        }
        ts.systemState.tracefunc = oldTrace;
    }
}

