/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.python.core.Py;
import org.python.core.PySystemState;
import org.python.core.ThreadState;

class ThreadStateMapping {
    private static boolean checkedJava2 = false;
    private static Hashtable threads;
    private static ThreadState cachedThreadState;
    private static int additionCounter;
    private static final int MAX_ADDITIONS = 25;

    static {
        additionCounter = 0;
    }

    ThreadStateMapping() {
    }

    public static ThreadStateMapping makeMapping() {
        if (!checkedJava2) {
            checkedJava2 = true;
            String version = System.getProperty("java.version");
            if (version.compareTo("1.2") >= 0) {
                try {
                    Class<?> c = Class.forName("org.python.core.ThreadStateMapping2");
                    return (ThreadStateMapping)c.newInstance();
                }
                catch (Throwable throwable) {}
            }
        }
        return new ThreadStateMapping();
    }

    public ThreadState getThreadState(PySystemState newSystemState) {
        Thread t = Thread.currentThread();
        ThreadState ts = cachedThreadState;
        if (ts != null && ts.thread == t) {
            return ts;
        }
        if (threads == null) {
            threads = new Hashtable();
        }
        if ((ts = (ThreadState)threads.get(t)) == null) {
            if (newSystemState == null) {
                Py.writeDebug("threadstate", "no current system state");
                newSystemState = Py.defaultSystemState;
            }
            ts = new ThreadState(t, newSystemState);
            threads.put(t, ts);
            if (++additionCounter > 25) {
                this.cleanupThreadTable();
                additionCounter = 0;
            }
        }
        cachedThreadState = ts;
        return ts;
    }

    private void cleanupThreadTable() {
        Enumeration e = threads.keys();
        while (e.hasMoreElements()) {
            try {
                Object key = e.nextElement();
                ThreadState tempThreadState = (ThreadState)threads.get(key);
                if (tempThreadState == null || tempThreadState.thread == null || tempThreadState.thread.isAlive()) continue;
                threads.remove(key);
            }
            catch (ClassCastException classCastException) {}
        }
    }
}

