/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyFloatDerived;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyFloat
extends PyObject {
    public static final String exposed_name = "float";
    private static final PyType FLOATTYPE = PyType.fromClass(PyFloat.class);
    private double value;

    public static void typeSetup(PyObject dict, PyType.Newstyle marker) {
        class Exposed___abs__
        extends PyBuiltinMethodNarrow {
            Exposed___abs__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___abs__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___abs__();
            }
        }
        dict.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyFloat.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinMethodNarrow {
            Exposed___float__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___float__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___float__();
            }
        }
        dict.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyFloat.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___int__
        extends PyBuiltinMethodNarrow {
            Exposed___int__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___int__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___int__();
            }
        }
        dict.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyFloat.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___long__
        extends PyBuiltinMethodNarrow {
            Exposed___long__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___long__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___long__();
            }
        }
        dict.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyFloat.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinMethodNarrow {
            Exposed___neg__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___neg__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___neg__();
            }
        }
        dict.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyFloat.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___pos__
        extends PyBuiltinMethodNarrow {
            Exposed___pos__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___pos__(self, this.info);
            }

            public PyObject __call__() {
                return ((PyFloat)this.self).float___pos__();
            }
        }
        dict.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyFloat.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinMethodNarrow {
            Exposed___add__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___add__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___add__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyFloat.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___div__
        extends PyBuiltinMethodNarrow {
            Exposed___div__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___div__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___div__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyFloat.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinMethodNarrow {
            Exposed___divmod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___divmod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___divmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyFloat.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___floordiv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___floordiv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___floordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyFloat.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___mod__
        extends PyBuiltinMethodNarrow {
            Exposed___mod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___mod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___mod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyFloat.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinMethodNarrow {
            Exposed___mul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___mul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___mul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyFloat.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___radd__
        extends PyBuiltinMethodNarrow {
            Exposed___radd__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___radd__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___radd__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyFloat.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rdiv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rdiv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rdiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyFloat.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rfloordiv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rfloordiv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rfloordiv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyFloat.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rmod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rmod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyFloat.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinMethodNarrow {
            Exposed___rmul__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rmul__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rmul__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyFloat.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinMethodNarrow {
            Exposed___rsub__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rsub__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rsub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyFloat.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinMethodNarrow {
            Exposed___rtruediv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rtruediv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rtruediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyFloat.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinMethodNarrow {
            Exposed___sub__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___sub__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___sub__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyFloat.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinMethodNarrow {
            Exposed___truediv__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___truediv__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___truediv__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyFloat.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___rdivmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rdivmod__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rdivmod__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rdivmod__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rdivmod__", (PyObject)new PyMethodDescr("__rdivmod__", PyFloat.class, 1, 1, new Exposed___rdivmod__(null, null)));
        class Exposed___rpow__
        extends PyBuiltinMethodNarrow {
            Exposed___rpow__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___rpow__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___rpow__(arg0);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__rpow__", (PyObject)new PyMethodDescr("__rpow__", PyFloat.class, 1, 1, new Exposed___rpow__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinMethodNarrow {
            Exposed___cmp__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___cmp__(self, this.info);
            }

            public PyObject __call__(PyObject arg0) {
                int ret = ((PyFloat)this.self).float___cmp__(arg0);
                if (ret == -2) {
                    throw Py.TypeError("float.__cmp__(x,y) requires y to be 'float', not a '" + arg0.getType().fastGetName() + "'");
                }
                return Py.newInteger(ret);
            }
        }
        dict.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyFloat.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinMethodNarrow {
            Exposed___pow__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___pow__(self, this.info);
            }

            public PyObject __call__(PyObject arg0, PyObject arg1) {
                PyObject ret = ((PyFloat)this.self).float___pow__(arg0, arg1);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }

            public PyObject __call__(PyObject arg0) {
                PyObject ret = ((PyFloat)this.self).float___pow__(arg0, null);
                if (ret == null) {
                    return Py.NotImplemented;
                }
                return ret;
            }
        }
        dict.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyFloat.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___nonzero__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyFloat)this.self).float___nonzero__());
            }
        }
        dict.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyFloat.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___repr__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyFloat)this.self).float_toString());
            }
        }
        dict.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyFloat.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinMethodNarrow {
            Exposed___str__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___str__(self, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyFloat)this.self).float_toString());
            }
        }
        dict.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyFloat.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinMethodNarrow {
            Exposed___hash__(PyObject self, PyBuiltinFunction.Info info) {
                super(self, info);
            }

            public PyBuiltinFunction bind(PyObject self) {
                return new Exposed___hash__(self, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(((PyFloat)this.self).float_hashCode());
            }
        }
        dict.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyFloat.class, 0, 0, new Exposed___hash__(null, null)));
        dict.__setitem__("__new__", (PyObject)new PyNewWrapper(PyFloat.class, "__new__", -1, -1){

            public PyObject new_impl(boolean init, PyType subtype, PyObject[] args, String[] keywords) {
                return PyFloat.float_new(this, init, subtype, args, keywords);
            }
        });
    }

    public static PyObject float_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser(exposed_name, args, keywords, new String[]{"x"}, 0);
        PyObject x = ap.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (x == null) {
                return new PyFloat(0.0);
            }
            return x.__float__();
        }
        if (x == null) {
            return new PyFloatDerived(subtype, 0.0);
        }
        return new PyFloatDerived(subtype, x.__float__().getValue());
    }

    public PyFloat(PyType subtype, double v) {
        super(subtype);
        this.value = v;
    }

    public PyFloat(double v) {
        this(FLOATTYPE, v);
    }

    public PyFloat(float v) {
        this((double)v);
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.float_toString();
    }

    final String float_toString() {
        String s = Double.toString(this.value);
        if (s.indexOf(69) == -1) {
            int n;
            while ((n = s.length()) > 2 && s.charAt(n - 1) == '0' && s.charAt(n - 2) != '.') {
                s = s.substring(0, n - 1);
            }
        }
        return s;
    }

    public int hashCode() {
        return this.float_hashCode();
    }

    final int float_hashCode() {
        double intPart = Math.floor(this.value);
        double fractPart = this.value - intPart;
        if (fractPart == 0.0) {
            if (intPart <= 2.147483647E9 && intPart >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >> 32);
    }

    public boolean __nonzero__() {
        return this.float___nonzero__();
    }

    final boolean float___nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class c) {
        if (c == Double.TYPE || c == Number.class || c == Double.class || c == Object.class || c == Serializable.class) {
            return new Double(this.value);
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.value);
        }
        return super.__tojava__(c);
    }

    public int __cmp__(PyObject other) {
        return this.float___cmp__(other);
    }

    final int float___cmp__(PyObject other) {
        if (!PyFloat.canCoerce(other)) {
            return -2;
        }
        double v = PyFloat.coerce(other);
        return this.value < v ? -1 : (this.value > v ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyFloat) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)other).getValue());
        }
        if (other instanceof PyLong) {
            return new PyFloat(((PyLong)other).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private static final double coerce(PyObject other) {
        if (other instanceof PyFloat) {
            return ((PyFloat)other).value;
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        if (other instanceof PyLong) {
            return ((PyLong)other).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        return this.float___add__(right);
    }

    final PyObject float___add__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value + rightv);
    }

    public PyObject __radd__(PyObject left) {
        return this.float___radd__(left);
    }

    final PyObject float___radd__(PyObject left) {
        return this.__add__(left);
    }

    public PyObject __sub__(PyObject right) {
        return this.float___sub__(right);
    }

    final PyObject float___sub__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value - rightv);
    }

    public PyObject __rsub__(PyObject left) {
        return this.float___rsub__(left);
    }

    final PyObject float___rsub__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(leftv - this.value);
    }

    public PyObject __mul__(PyObject right) {
        return this.float___mul__(right);
    }

    final PyObject float___mul__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value * rightv);
    }

    public PyObject __rmul__(PyObject left) {
        return this.float___rmul__(left);
    }

    final PyObject float___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    public PyObject __div__(PyObject right) {
        return this.float___div__(right);
    }

    final PyObject float___div__(PyObject right) {
        double rightv;
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        if ((rightv = PyFloat.coerce(right)) == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / rightv);
    }

    public PyObject __rdiv__(PyObject left) {
        return this.float___rdiv__(left);
    }

    final PyObject float___rdiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.value);
    }

    public PyObject __floordiv__(PyObject right) {
        return this.float___floordiv__(right);
    }

    final PyObject float___floordiv__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(this.value / rightv));
    }

    public PyObject __rfloordiv__(PyObject left) {
        return this.float___rfloordiv__(left);
    }

    final PyObject float___rfloordiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(leftv / this.value));
    }

    public PyObject __truediv__(PyObject right) {
        return this.float___truediv__(right);
    }

    final PyObject float___truediv__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / rightv);
    }

    public PyObject __rtruediv__(PyObject left) {
        return this.float___rtruediv__(left);
    }

    final PyObject float___rtruediv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.value);
    }

    private static double modulo(double x, double y) {
        if (y == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double z = Math.IEEEremainder(x, y);
        if (z * y < 0.0) {
            z += y;
        }
        return z;
    }

    public PyObject __mod__(PyObject right) {
        return this.float___mod__(right);
    }

    final PyObject float___mod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(PyFloat.modulo(this.value, rightv));
    }

    public PyObject __rmod__(PyObject left) {
        return this.float___rmod__(left);
    }

    final PyObject float___rmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(PyFloat.modulo(leftv, this.value));
    }

    public PyObject __divmod__(PyObject right) {
        return this.float___divmod__(right);
    }

    final PyObject float___divmod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(this.value / rightv);
        return new PyTuple(new PyObject[]{new PyFloat(z), new PyFloat(this.value - z * rightv)});
    }

    public PyObject __rdivmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(leftv / this.value);
        return new PyTuple(new PyObject[]{new PyFloat(z), new PyFloat(leftv - z * this.value)});
    }

    final PyObject float___rdivmod__(PyObject left) {
        return this.__rdivmod__(left);
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.float___pow__(right, modulo);
    }

    final PyObject float___pow__(PyObject right, PyObject modulo) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (modulo != null) {
            throw Py.TypeError("pow() 3rd argument not allowed unless all arguments are integers");
        }
        return PyFloat._pow(this.value, PyFloat.coerce(right), modulo);
    }

    final PyObject float___rpow__(PyObject left) {
        return this.__rpow__(left);
    }

    public PyObject __rpow__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(left), this.value, null);
    }

    private static PyFloat _pow(double value, double iw, PyObject modulo) {
        if (iw == 0.0) {
            if (modulo != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(modulo)));
            }
            return new PyFloat(1.0);
        }
        if (value == 0.0) {
            if (iw < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        if (value < 0.0 && iw != Math.floor(iw)) {
            throw Py.ValueError("negative number cannot be raised to a fractional power");
        }
        double ret = Math.pow(value, iw);
        if (modulo == null) {
            return new PyFloat(ret);
        }
        return new PyFloat(PyFloat.modulo(ret, PyFloat.coerce(modulo)));
    }

    public PyObject __neg__() {
        return this.float___neg__();
    }

    final PyObject float___neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this.float___pos__();
    }

    final PyObject float___pos__() {
        return Py.newFloat(this.value);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.float___abs__();
    }

    final PyObject float___abs__() {
        if (this.value >= 0.0) {
            return Py.newFloat(this.value);
        }
        return this.__neg__();
    }

    public PyObject __int__() {
        return this.float___int__();
    }

    final PyInteger float___int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    public PyLong __long__() {
        return this.float___long__();
    }

    final PyLong float___long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this.float___float__();
    }

    final PyFloat float___float__() {
        return Py.newFloat(this.value);
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isSequenceType() throws PyIgnoreMethodTag {
        return false;
    }
}

