/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInterpreterManager
extends AbstractInterpreterManager {
    public PythonInterpreterManager(IPreferenceStore preferences) {
        super(preferences);
    }

    @Override
    protected String getPreferenceName() {
        return "INTERPRETER_PATH_NEW";
    }

    @Override
    public String getInterpreterUIName() {
        return "Python";
    }

    @Override
    public Tuple<InterpreterInfo, String> internalCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException {
        return PythonInterpreterManager.doCreateInterpreterInfo(executable, monitor, askUser);
    }

    @Override
    protected String getPreferencesPageId() {
        return "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPagePython";
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor, boolean askUser) throws CoreException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (isJythonExecutable) {
            throw new RuntimeException("A jar cannot be used in order to get the info for the python interpreter.");
        }
        File script = PythonInterpreterManager.getInterpreterInfoPy();
        Tuple<String, String> outTup = new SimplePythonRunner().runAndGetOutputWithInterpreter(executable, FileUtils.getFileAbsolutePath((File)script), null, null, null, monitor, "utf-8");
        InterpreterInfo info = PythonInterpreterManager.createInfoFromOutput(monitor, outTup, askUser);
        if (info == null) {
            return null;
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)((String)outTup.o1));
    }

    public int getInterpreterType() {
        return 0;
    }

    public String getManagerRelatedName() {
        return "python";
    }
}

