/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.log.Log;
import org.python.pydev.navigator.InterpreterInfoTreeNodeRoot;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.elements.ProjectConfigError;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.utils.PyMarkerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInfoForPackageExplorer {
    public final Set<PythonSourceFolder> sourceFolders = new HashSet<PythonSourceFolder>();
    public final List<ProjectConfigError> configErrors = new ArrayList<ProjectConfigError>();
    public IInterpreterInfo interpreterInfo;
    private InterpreterInfoTreeNodeRoot<LabelAndImage> interpreterInfoTreeRoot;
    private static final Map<IProject, UpdatePydevPackageExplorerProblemMarkers> projectToJob = new HashMap<IProject, UpdatePydevPackageExplorerProblemMarkers>();
    private static final Object lock = new Object();

    public ProjectInfoForPackageExplorer(IProject project) {
        this.recreateInfo(project);
    }

    public void recreateInfo(IProject project) {
        this.interpreterInfoTreeRoot = null;
        this.configErrors.clear();
        Tuple<List<ProjectConfigError>, IInterpreterInfo> configErrorsAndInfo = this.getConfigErrorsAndInfo(project);
        this.configErrors.addAll((Collection)configErrorsAndInfo.o1);
        this.interpreterInfo = (IInterpreterInfo)configErrorsAndInfo.o2;
    }

    public synchronized InterpreterInfoTreeNodeRoot<LabelAndImage> getProjectInfoTreeStructure(IProject project, Object parent) {
        if (parent == null || this.interpreterInfo == null) {
            return null;
        }
        PythonNature nature = PythonNature.getPythonNature(project);
        if (this.interpreterInfoTreeRoot != null && this.interpreterInfoTreeRoot.getParent().equals(parent) && this.interpreterInfoTreeRoot.interpreterInfo.equals(this.interpreterInfo)) {
            return this.interpreterInfoTreeRoot;
        }
        this.interpreterInfoTreeRoot = null;
        try {
            ImageCache imageCache = PydevPlugin.getImageCache();
            this.interpreterInfoTreeRoot = new InterpreterInfoTreeNodeRoot<LabelAndImage>(this.interpreterInfo, nature, parent, new LabelAndImage(this.interpreterInfo.getNameForUI(), imageCache.get("icons/python_16x16.png")));
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
            return null;
        }
        return this.interpreterInfoTreeRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<List<ProjectConfigError>, IInterpreterInfo> getConfigErrorsAndInfo(IProject project) {
        if (project == null || !project.isOpen()) {
            return new Tuple(new ArrayList(), null);
        }
        PythonNature nature = PythonNature.getPythonNature(project);
        if (nature == null) {
            return new Tuple(new ArrayList(), null);
        }
        Tuple<List<ProjectConfigError>, IInterpreterInfo> configErrorsAndInfo = null;
        boolean goodToGo = false;
        int i = 0;
        while (i < 10 && !goodToGo) {
            try {
                configErrorsAndInfo = nature.getConfigErrorsAndInfo(project);
                goodToGo = true;
            }
            catch (PythonNatureWithoutProjectException pythonNatureWithoutProjectException) {
                goodToGo = false;
                ProjectInfoForPackageExplorer projectInfoForPackageExplorer = this;
                synchronized (projectInfoForPackageExplorer) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ++i;
        }
        if (configErrorsAndInfo == null) {
            return new Tuple(new ArrayList(), null);
        }
        if (nature != null) {
            Object object = lock;
            synchronized (object) {
                UpdatePydevPackageExplorerProblemMarkers job = projectToJob.get(project);
                if (job == null) {
                    job = new UpdatePydevPackageExplorerProblemMarkers("Update pydev package explorer markers for: " + project);
                    projectToJob.put(project, job);
                }
                job.setInfo(project, ((List)configErrorsAndInfo.o1).toArray(new ProjectConfigError[((List)configErrorsAndInfo.o1).size()]));
                job.schedule();
            }
        }
        return configErrorsAndInfo;
    }

    private static final class UpdatePydevPackageExplorerProblemMarkers
    extends Job {
        private IProject fProject;
        private ProjectConfigError[] fProjectConfigErrors;
        private final Object lockJob = new Object();

        private UpdatePydevPackageExplorerProblemMarkers(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ProjectConfigError[] projectConfigErrors;
            IProject project;
            Object object = this.lockJob;
            synchronized (object) {
                project = this.fProject;
                projectConfigErrors = this.fProjectConfigErrors;
                this.fProject = null;
                this.fProjectConfigErrors = null;
            }
            ArrayList lst = new ArrayList(projectConfigErrors.length);
            ProjectConfigError[] projectConfigErrorArray = projectConfigErrors;
            int n = projectConfigErrors.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectConfigError error = projectConfigErrorArray[n2];
                try {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("message", error.getLabel());
                    attributes.put("severity", 2);
                    lst.add(attributes);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                ++n2;
            }
            PyMarkerUtils.replaceMarkers((Map[])lst.toArray(new Map[lst.size()]), (IResource)project, (String)"org.python.pydev.PydevProjectErrorMarkers", (boolean)true, (IProgressMonitor)monitor);
            Object object2 = lock;
            synchronized (object2) {
                if (this.fProject == null) {
                    projectToJob.remove(project);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setInfo(IProject project, ProjectConfigError[] projectConfigErrors) {
            Object object = this.lockJob;
            synchronized (object) {
                this.fProject = project;
                this.fProjectConfigErrors = projectConfigErrors;
            }
        }
    }
}

